/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2016 OX Software GmbH.
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/drawinglayer/model/drawingmodel', [
    'io.ox/office/tk/utils',
    'io.ox/office/tk/object/timermixin',
    'io.ox/office/editframework/model/attributedmodel'
], function (Utils, TimerMixin, AttributedModel) {

    'use strict';

    // class DrawingModel =====================================================

    /**
     * The model of a drawing object.
     *
     * @constructor
     *
     * @extends AttributedModel
     * @extends TimerMixin
     *
     * @param {EditApplication} app
     *  The application instance containing this drawing object.
     *
     * @param {String} type
     *  The type of this drawing object.
     *
     * @param {Object} [initAttributes]
     *  An attribute set with initial formatting attributes for the drawing
     *  object.
     *
     * @param {Object} [initOptions]
     *  A map with additional options for the drawing object. The following
     *  options are supported:
     *  @param {String} [options.families]
     *      Additional explicit attribute families supported by this drawing
     *      model object (space-separated). The main attribute family 'drawing'
     *      supported by all drawing objects will be registered implicitly, and
     *      does not have to be added here.
     */
    function DrawingModel(app, type, initAttributes, initOptions) {

        // base constructors --------------------------------------------------

        AttributedModel.call(this, app, initAttributes, {
            styleFamily: 'drawing',
            families: Utils.getStringOption(initOptions, 'families')
        });

        TimerMixin.call(this);

        // public methods -----------------------------------------------------

        /**
         * Returns the type of this drawing model, as specified by the
         * operation that has created the drawing model.
         *
         * @returns {String}
         *  The type of this drawing model.
         */
        this.getType = function () {
            return type;
        };

        this.getCollection = function () {
            return null;
        };

        // initialization -----------------------------------------------------

        // destroy all class members on destruction
        this.registerDestructor(function () {
            app = initAttributes = initOptions = null;
        });

    } // class DrawingModel

    // exports ================================================================

    // derive this class from class AttributedModel
    return AttributedModel.extend({ constructor: DrawingModel });

});
