/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2016 OX Software GmbH.
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/baseframework/view/control/compoundbutton', [
    'io.ox/office/tk/utils',
    'io.ox/office/tk/forms',
    'io.ox/office/tk/control/group',
    'io.ox/office/tk/control/captionmixin',
    'io.ox/office/tk/control/widthmixin',
    'io.ox/office/baseframework/view/control/compoundmenumixin'
], function (Utils, Forms, Group, CaptionMixin, WidthMixin, CompoundMenuMixin) {

    'use strict';

    // class CompoundButton ===================================================

    /**
     * A generic drop-down button control that shows a complete self-contained
     * view component instance with completely independent controls in its
     * drop-down menu. See class CompoundSplitButton for a similar drop-down
     * control with an additional split button control.
     *
     * @constructor
     *
     * @extends Group
     * @extends CaptionMixin
     * @extends WidthMixin
     * @extends CompoundMenuMixin
     *
     * @param {BaseApplication} app
     *  The application containing this control.
     *
     * @param {Object} [initOptions]
     *  Optional parameters. Supports all options also supported by the base
     *  class Group, the mix-in class WidthMixin, and the mix-in class
     *  CompoundMenuMixin.
     */
    function CompoundButton(app, initOptions) {

        var // the drop-down button
            menuButton = $(Forms.createButtonMarkup(Utils.extendOptions({
                tooltip: Utils.getStringOption(initOptions, 'label', null, true),
                attributes: { 'aria-haspopup': true }
            }, initOptions)));

        Utils.addToPreventFocusChange(menuButton);

        // base constructors --------------------------------------------------

        Group.call(this, initOptions);
        CaptionMixin.call(this, menuButton, initOptions);
        WidthMixin.call(this, menuButton, initOptions);
        CompoundMenuMixin.call(this, app, Utils.extendOptions(initOptions, { button: menuButton }));

        // initialization -----------------------------------------------------

        // add the drop-down button to the group
        this.addChildNodes(menuButton);

        // destroy all class members
        this.registerDestructor(function () {
            app = initOptions = menuButton = null;
        });

    } // class CompoundButton

    // exports ================================================================

    // derive this class from class Group
    return Group.extend({ constructor: CompoundButton });

});
