Name:           open-xchange-documents-help
BuildArch:      noarch
BuildRequires:  ant
BuildRequires:  ant-nodeps
BuildRequires:  java-devel >= 1.6.0
BuildRequires:  nodejs >= 0.10.0
Version:        7.6.3
%define         ox_release 5
Release:        %{ox_release}_<CI_CNT>.<B_CNT>
Group:          Applications/Productivity
Vendor:         Open-Xchange
URL:            http://open-xchange.com
Packager:       Julian Baeume <julian.baeume@open-xchange.com>
License:        CC-BY-NC-SA
Summary:        OX Documents online help
Source:         %{name}_%{version}.orig.tar.bz2
BuildRoot:      %{_tmppath}/%{name}-%{version}-root

%if 0%{?rhel_version} || 0%{?fedora_version}
%define docroot /var/www/html/
%else
%define docroot /srv/www/htdocs/
%endif

%description
OX Documents help files

%package        common
Group:          Applications/Productivity
Summary:        Language-independent files of online help for OX Documents

%description    common
Language-independent files of online help for OX Documents

%package       de-de
Group:         Applications/Productivity
Summary:       Online help for OX Documents (de_DE)
Provides:      open-xchange-documents-help
Requires:      open-xchange-documents-help-common

%description   de-de
Online help for OX Documents (de_DE)

%package       en-gb
Group:         Applications/Productivity
Summary:       Online help for OX Documents (en_GB)
Provides:      open-xchange-documents-help
Requires:      open-xchange-documents-help-common

%description   en-gb
Online help for OX Documents (en_GB)

%package       en-us
Group:         Applications/Productivity
Summary:       Online help for OX Documents (en_US)
Provides:      open-xchange-documents-help
Requires:      open-xchange-documents-help-common

%description   en-us
Online help for OX Documents (en_US)

%package       es-es
Group:         Applications/Productivity
Summary:       Online help for OX Documents (es_ES)
Provides:      open-xchange-documents-help
Requires:      open-xchange-documents-help-common

%description   es-es
Online help for OX Documents (es_ES)

%package       es-mx
Group:         Applications/Productivity
Summary:       Online help for OX Documents (es_MX)
Provides:      open-xchange-documents-help
Requires:      open-xchange-documents-help-common

%description   es-mx
Online help for OX Documents (es_MX)

%package       fr-fr
Group:         Applications/Productivity
Summary:       Online help for OX Documents (fr_FR)
Provides:      open-xchange-documents-help
Requires:      open-xchange-documents-help-common

%description   fr-fr
Online help for OX Documents (fr_FR)

%package       it-it
Group:         Applications/Productivity
Summary:       Online help for OX Documents (it_IT)
Provides:      open-xchange-documents-help
Requires:      open-xchange-documents-help-common

%description   it-it
Online help for OX Documents (it_IT)

%package       ja-jp
Group:         Applications/Productivity
Summary:       Online help for OX Documents (ja_JP)
Provides:      open-xchange-documents-help
Requires:      open-xchange-documents-help-common

%description   ja-jp
Online help for OX Documents (ja_JP)

%package       nl-nl
Group:         Applications/Productivity
Summary:       Online help for OX Documents (nl_NL)
Provides:      open-xchange-documents-help
Requires:      open-xchange-documents-help-common

%description   nl-nl
Online help for OX Documents (nl_NL)

%package       pl-pl
Group:         Applications/Productivity
Summary:       Online help for OX Documents (pl_PL)
Provides:      open-xchange-documents-help
Requires:      open-xchange-documents-help-common

%description   pl-pl
Online help for OX Documents (pl_PL)

%package       zh-cn
Group:         Applications/Productivity
Summary:       Online help for OX Documents (zh_CN)
Provides:      open-xchange-documents-help
Requires:      open-xchange-documents-help-common

%description   zh-cn
Online help for OX Documents (zh_CN)

%package       zh-tw
Group:         Applications/Productivity
Summary:       Online help for OX Documents (zh_TW)
Provides:      open-xchange-documents-help
Requires:      open-xchange-documents-help-common

%description   zh-tw
Online help for OX Documents (zh_TW)

%prep

%setup -q

%build

%install
export NO_BRP_CHECK_BYTECODE_VERSION=true
ant -Dbasedir=build -DdestDir=%{buildroot} -DpackageName=%{name} -Dhtdoc=%{docroot} -Dlanguages=false -DkeepCache=true -f build/build.xml build
for LANG in de_DE en_GB en_US es_ES es_MX fr_FR it_IT ja_JP nl_NL pl_PL zh_CN zh_TW; do
    ant -Dbasedir=build -DdestDir=%{buildroot} -DpackageName=%{name} -Dhtdoc=%{docroot} -DinstallTarget=${LANG} -DkeepCache=true -Dnoclean=true -f build/build.xml clean build
done

%clean
%{__rm} -rf %{buildroot}

%files common
%defattr(-,root,root)
%dir %{docroot}/appsuite
%{docroot}/appsuite/help-documents
%exclude %{docroot}/appsuite/help-documents/l10n

%files de-de
%defattr(-,root,root)
%dir %{docroot}/appsuite/help-documents/l10n
%{docroot}/appsuite/help-documents/l10n/de_DE

%files en-gb
%defattr(-,root,root)
%dir %{docroot}/appsuite/help-documents/l10n
%{docroot}/appsuite/help-documents/l10n/en_GB

%files en-us
%defattr(-,root,root)
%dir %{docroot}/appsuite
%dir %{docroot}/appsuite/help-documents/l10n
%{docroot}/appsuite/help-documents/l10n/en_US

%files es-es
%defattr(-,root,root)
%dir %{docroot}/appsuite/help-documents/l10n
%{docroot}/appsuite/help-documents/l10n/es_ES

%files es-mx
%defattr(-,root,root)
%dir %{docroot}/appsuite/help-documents/l10n
%{docroot}/appsuite/help-documents/l10n/es_MX

%files fr-fr
%defattr(-,root,root)
%dir %{docroot}/appsuite/help-documents/l10n
%{docroot}/appsuite/help-documents/l10n/fr_FR

%files it-it
%defattr(-,root,root)
%dir %{docroot}/appsuite/help-documents/l10n
%{docroot}/appsuite/help-documents/l10n/it_IT

%files ja-jp
%defattr(-,root,root)
%dir %{docroot}/appsuite/help-documents/l10n
%{docroot}/appsuite/help-documents/l10n/ja_JP

%files nl-nl
%defattr(-,root,root)
%dir %{docroot}/appsuite/help-documents/l10n
%{docroot}/appsuite/help-documents/l10n/nl_NL

%files pl-pl
%defattr(-,root,root)
%dir %{docroot}/appsuite/help-documents/l10n
%{docroot}/appsuite/help-documents/l10n/pl_PL

%files zh-cn
%defattr(-,root,root)
%dir %{docroot}/appsuite/help-documents/l10n
%{docroot}/appsuite/help-documents/l10n/zh_CN

%files zh-tw
%defattr(-,root,root)
%dir %{docroot}/appsuite/help-documents/l10n
%{docroot}/appsuite/help-documents/l10n/zh_TW

%changelog
* Wed Sep 21 2016 Julian Bäume <julian.baeume@open-xchange.com>
Build for patch 2016-09-26 (3569)
* Wed Aug 24 2016 Julian Bäume <julian.baeume@open-xchange.com>
Build for patch 2016-08-29 (3519)
* Wed Jun 01 2016 Julian Bäume <julian.baeume@open-xchange.com>
Build for patch 2016-06-06 (3315)
* Mon Nov 23 2015 Julian Bäume <julian.baeume@open-xchange.com>
Second candidate for 7.6.3 release
* Mon Oct 26 2015 Julian Bäume <julian.baeume@open-xchange.com>
First candidate for 7.6.3 release
* Thu Jul 16 2015 Julian Bäume <julian.baeume@open-xchange.com>
Build for patch 2015-07-27 (2648)
* Fri Jul 03 2015 Julian Bäume <julian.baeume@open-xchange.com>
Build for patch 2015-07-10
* Wed Apr 22 2015 Julian Bäume <julian.baeume@open-xchange.com>
prepare for 7.6.3 release
* Mon Mar 09 2015 Julian Bäume <julian.baeume@open-xchange.com>
Twelfth candidate for 7.6.2 release
* Fri Mar 06 2015 Julian Bäume <julian.baeume@open-xchange.com>
Eleventh candidate for 7.6.2 release
* Wed Mar 04 2015 Julian Bäume <julian.baeume@open-xchange.com>
Tenth candidate for 7.6.2 release
* Tue Mar 03 2015 Julian Bäume <julian.baeume@open-xchange.com>
Ninth candidate for 7.6.2 release
* Tue Feb 24 2015 Julian Bäume <julian.baeume@open-xchange.com>
Eighth candidate for 7.6.2 release
* Wed Feb 11 2015 Julian Bäume <julian.baeume@open-xchange.com>
Seventh candidate for 7.6.2 release
* Fri Jan 30 2015 Julian Bäume <julian.baeume@open-xchange.com>
Sixth candidate for 7.6.2 release
* Tue Jan 27 2015 Julian Bäume <julian.baeume@open-xchange.com>
Fifth candidate for 7.6.2 release
* Wed Jan 21 2015 Julian Bäume <julian.baeume@open-xchange.com>
Build for patch 2015-01-26
* Fri Dec 12 2014 Julian Bäume <julian.baeume@open-xchange.com>
Fourth candidate for 7.6.2 release
* Fri Dec 05 2014 Julian Bäume <julian.baeume@open-xchange.com>
Third candidate for 7.6.2 release
* Fri Nov 21 2014 Julian Bäume <julian.baeume@open-xchange.com>
Second candidate for 7.6.2 release
* Fri Nov 14 2014 Julian Bäume <julian.baeume@open-xchange.com>
Build for patch 2014-11-17
* Tue Nov 04 2014 Julian Bäume <julian.baeume@open-xchange.com>
Ninth candidate for 7.6.1 release
* Fri Oct 31 2014 Julian Bäume <julian.baeume@open-xchange.com>
Initial Release.
