/*
 *
 *    OPEN-XCHANGE legal information *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2014 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.documentconverter;

import java.io.File;
import java.util.HashMap;
import java.util.Set;

/**
 * {@link Measures}
 *
 * @author <a href="mailto:kai.ahrens@open-xchange.com">Kai Ahrens</a>
 * @since v7.6.0
 */
public class Measures {

    /**
     * Initializes the {@link Measures} singleton framework
     *
     * @param rootDir
     */
    public static synchronized void init(File rootDir) {
        if (null == isMeasuring) {
            if (!(isMeasuring = new Measures(rootDir)).implIsValid()) {
                isMeasuring = null;
            }
        }
    }

    /**
     * @return True if the singleton instance of this class has been inialized
     */
    public static boolean isMeasuring() {
        return (null != isMeasuring);
    }

    /**
     * @return The {@link Measurement} object for the requested <code>perfIdObj</code> or <code>null</code> if no measurements are possible
     */
    public static Measurement getMeasure(Object perfIdObj, Enum<?> title, HashMap<String, Object> jobProperties) {
        return ((null != isMeasuring) ? isMeasuring.implGetMeasurement(perfIdObj, title, jobProperties, new File(isMeasuring.m_rootDir, perfIdObj.toString())) : null);
    }

    /**
     * @return
     */
    public static synchronized long getUniqueNanoTime() {
        long curNanoTime = System.nanoTime();

        while (curNanoTime <= m_lastNanoTime) {
            ++curNanoTime;
        }

        return (m_lastNanoTime = curNanoTime);
    }

    // - Implementation --------------------------------------------------------

    /**
     * private Ctor shall not be used
     */
    @SuppressWarnings("unused")
    private Measures() {
    }

    /**
     * Initializes a new {@link Measures}.
     */
    protected Measures(File rootDir) {
        super();

        if ((null != rootDir) && ((rootDir.isDirectory() && rootDir.canWrite()) | rootDir.mkdirs())) {
            m_rootDir = rootDir;
        }
    }

    /**
     * @return <code>true</code>, if this {@link Measures} object could be successfully initialized
     */
    protected boolean implIsValid() {
        return (null != m_rootDir);
    }

    /**
     * @param perfIdObj
     * @param titleMapping
     * @param outputFile
     * @return
     */
    protected Measurement implGetMeasurement(Object perfIdObj, Enum<?> title, HashMap<String, Object> jobProperties, File outputFile) {
        Measurement ret = null;

        if ((null != m_rootDir) && (null != perfIdObj)) {
            if (null == (ret = m_measurements.get(perfIdObj))) {
                m_measurements.put(perfIdObj, ret = new Measurement(perfIdObj, title, jobProperties, outputFile));
            }
        }

        return ret;
    }

    /**
     * @return The {@link Set} of keys to retrieve all {@link Measurement} objects
     */
    protected Set<Object> implGetMeasurementKeySet() {
        return m_measurements.keySet();
    }

    // - Members ---------------------------------------------------------------

    private HashMap<Object, Measurement> m_measurements = new HashMap<Object, Measurement>();

    private File m_rootDir = null;

    // - Static Members --------------------------------------------------------

    public static Measures isMeasuring = null;

    private static long m_lastNanoTime = 0;
}
