/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.interceptors;

import java.net.HttpURLConnection;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.net.ssl.HttpsURLConnection;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.security.SecurityContext;
import org.apache.cxf.security.transport.TLSSessionInfo;
import org.apache.cxf.transport.http.MessageTrustDecider;
import org.apache.cxf.transport.http.URLConnectionInfo;
import org.apache.cxf.transport.http.UntrustedURLConnectionIOException;
import org.apache.cxf.transport.https.HttpsURLConnectionInfo;
import org.apache.cxf.ws.policy.AbstractPolicyInterceptorProvider;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.policy.PolicyException;
import org.apache.cxf.ws.security.policy.SP11Constants;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.model.HttpsToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpsTokenInterceptorProvider
extends AbstractPolicyInterceptorProvider {
    private static final long serialVersionUID = -13951002554477036L;

    public HttpsTokenInterceptorProvider() {
        super(Arrays.asList(SP11Constants.HTTPS_TOKEN, SP12Constants.HTTPS_TOKEN));
        this.getOutInterceptors().add(new HttpsTokenOutInterceptor());
        this.getOutFaultInterceptors().add(new HttpsTokenOutInterceptor());
        this.getInInterceptors().add(new HttpsTokenInInterceptor());
        this.getInFaultInterceptors().add(new HttpsTokenInInterceptor());
    }

    private static Map<String, List<String>> getSetProtocolHeaders(Message message) {
        Map<String, List<String>> headers = CastUtils.cast((Map)message.get(Message.PROTOCOL_HEADERS));
        if (null == headers) {
            headers = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
            message.put(Message.PROTOCOL_HEADERS, headers);
        }
        return headers;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class HttpsTokenInInterceptor
    extends AbstractPhaseInterceptor<Message> {
        public HttpsTokenInInterceptor() {
            super("pre-stream");
        }

        @Override
        public void handleMessage(Message message) throws Fault {
            AssertionInfoMap aim = message.get(AssertionInfoMap.class);
            if (aim != null) {
                Collection ais = (Collection)aim.get(SP12Constants.HTTPS_TOKEN);
                if (ais == null) {
                    return;
                }
                if (!this.isRequestor(message)) {
                    TLSSessionInfo tlsInfo;
                    this.assertHttps(ais, message);
                    SecurityContext sc = message.get(SecurityContext.class);
                    if ((sc == null || sc.getUserPrincipal() == null) && (tlsInfo = message.get(TLSSessionInfo.class)) != null && tlsInfo.getPeerCertificates() != null && tlsInfo.getPeerCertificates().length > 0 && tlsInfo.getPeerCertificates()[0] instanceof X509Certificate) {
                        X509Certificate cert = (X509Certificate)tlsInfo.getPeerCertificates()[0];
                        message.put(SecurityContext.class, this.createSecurityContext(cert.getSubjectX500Principal()));
                    }
                } else {
                    for (AssertionInfo ai : ais) {
                        ai.setAsserted(true);
                    }
                }
            }
        }

        private void assertHttps(Collection<AssertionInfo> ais, Message message) {
            for (AssertionInfo ai : ais) {
                TLSSessionInfo tlsInfo;
                List auth;
                boolean asserted = true;
                HttpsToken token = (HttpsToken)ai.getAssertion();
                Map headers = HttpsTokenInterceptorProvider.getSetProtocolHeaders(message);
                if (token.isHttpBasicAuthentication() && ((auth = (List)headers.get("Authorization")) == null || auth.size() == 0 || !((String)auth.get(0)).startsWith("Basic"))) {
                    asserted = false;
                }
                if (token.isHttpDigestAuthentication() && ((auth = (List)headers.get("Authorization")) == null || auth.size() == 0 || !((String)auth.get(0)).startsWith("Digest"))) {
                    asserted = false;
                }
                if ((tlsInfo = message.get(TLSSessionInfo.class)) != null) {
                    if (token.isRequireClientCertificate() && (tlsInfo.getPeerCertificates() == null || tlsInfo.getPeerCertificates().length == 0)) {
                        asserted = false;
                    }
                } else {
                    asserted = false;
                }
                ai.setAsserted(asserted);
            }
        }

        private SecurityContext createSecurityContext(final Principal p) {
            return new SecurityContext(){

                public Principal getUserPrincipal() {
                    return p;
                }

                public boolean isUserInRole(String role) {
                    return false;
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class HttpsTokenOutInterceptor
    extends AbstractPhaseInterceptor<Message> {
        public HttpsTokenOutInterceptor() {
            super("pre-stream");
        }

        @Override
        public void handleMessage(Message message) throws Fault {
            AssertionInfoMap aim = message.get(AssertionInfoMap.class);
            if (aim != null) {
                Collection ais = (Collection)aim.get(SP12Constants.HTTPS_TOKEN);
                if (ais == null) {
                    return;
                }
                if (this.isRequestor(message)) {
                    this.assertHttps(ais, message);
                } else {
                    for (AssertionInfo ai : ais) {
                        ai.setAsserted(true);
                    }
                }
            }
        }

        private void assertHttps(Collection<AssertionInfo> ais, Message message) {
            for (AssertionInfo ai : ais) {
                HttpsToken token = (HttpsToken)ai.getAssertion();
                HttpURLConnection connection = (HttpURLConnection)message.get("http.connection");
                ai.setAsserted(true);
                Map headers = HttpsTokenInterceptorProvider.getSetProtocolHeaders(message);
                if (connection instanceof HttpsURLConnection) {
                    List auth;
                    if (token.isRequireClientCertificate()) {
                        final MessageTrustDecider orig = message.get(MessageTrustDecider.class);
                        MessageTrustDecider trust = new MessageTrustDecider(){

                            public void establishTrust(String conduitName, URLConnectionInfo connectionInfo, Message message) throws UntrustedURLConnectionIOException {
                                HttpsURLConnectionInfo info;
                                if (orig != null) {
                                    orig.establishTrust(conduitName, connectionInfo, message);
                                }
                                if ((info = (HttpsURLConnectionInfo)connectionInfo).getLocalCertificates() == null || info.getLocalCertificates().length == 0) {
                                    throw new UntrustedURLConnectionIOException("RequireClientCertificate is set, but no local certificates were negotiated.  Is the server set to ask for client authorization?");
                                }
                            }
                        };
                        message.put(MessageTrustDecider.class, trust);
                    }
                    if (token.isHttpBasicAuthentication() && ((auth = (List)headers.get("Authorization")) == null || auth.size() == 0 || !((String)auth.get(0)).startsWith("Basic"))) {
                        ai.setNotAsserted("HttpBasicAuthentication is set, but not being used");
                    }
                    if (token.isHttpDigestAuthentication() && ((auth = (List)headers.get("Authorization")) == null || auth.size() == 0 || !((String)auth.get(0)).startsWith("Digest"))) {
                        ai.setNotAsserted("HttpDigestAuthentication is set, but not being used");
                    }
                } else {
                    ai.setNotAsserted("HttpURLConnection is not a HttpsURLConnection");
                }
                if (ai.isAsserted()) continue;
                throw new PolicyException(ai);
            }
        }
    }
}

