/*
 * Decompiled with CFR 0.152.
 */
package au.com.bytecode.opencsv;

import java.io.Closeable;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.math.BigDecimal;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSVWriter
implements Closeable {
    public static final int INITIAL_STRING_SIZE = 128;
    private Writer rawWriter;
    private PrintWriter pw;
    private char separator;
    private char quotechar;
    private char escapechar;
    private String lineEnd;
    public static final char DEFAULT_ESCAPE_CHARACTER = '\"';
    public static final char DEFAULT_SEPARATOR = ',';
    public static final char DEFAULT_QUOTE_CHARACTER = '\"';
    public static final char NO_QUOTE_CHARACTER = '\u0000';
    public static final char NO_ESCAPE_CHARACTER = '\u0000';
    public static final String DEFAULT_LINE_END = "\n";

    public CSVWriter(Writer writer) {
        this(writer, ',');
    }

    public CSVWriter(Writer writer, char c) {
        this(writer, c, '\"');
    }

    public CSVWriter(Writer writer, char c, char c2) {
        this(writer, c, c2, '\"');
    }

    public CSVWriter(Writer writer, char c, char c2, char c3) {
        this(writer, c, c2, c3, DEFAULT_LINE_END);
    }

    public CSVWriter(Writer writer, char c, char c2, String string) {
        this(writer, c, c2, '\"', string);
    }

    public CSVWriter(Writer writer, char c, char c2, char c3, String string) {
        this.rawWriter = writer;
        this.pw = new PrintWriter(writer);
        this.separator = c;
        this.quotechar = c2;
        this.escapechar = c3;
        this.lineEnd = string;
    }

    public void writeAll(List<String[]> list) {
        for (String[] stringArray : list) {
            this.writeNext(stringArray);
        }
    }

    protected void writeColumnNames(ResultSetMetaData resultSetMetaData) throws SQLException {
        int n = resultSetMetaData.getColumnCount();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = resultSetMetaData.getColumnName(i + 1);
        }
        this.writeNext(stringArray);
    }

    public void writeAll(ResultSet resultSet, boolean bl) throws SQLException, IOException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        if (bl) {
            this.writeColumnNames(resultSetMetaData);
        }
        int n = resultSetMetaData.getColumnCount();
        while (resultSet.next()) {
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = CSVWriter.getColumnValue(resultSet, resultSetMetaData.getColumnType(i + 1), i + 1);
            }
            this.writeNext(stringArray);
        }
    }

    private static String getColumnValue(ResultSet resultSet, int n, int n2) throws SQLException, IOException {
        String string = "";
        switch (n) {
            case -7: {
                Object object = resultSet.getObject(n2);
                if (object == null) break;
                string = String.valueOf(object);
                break;
            }
            case 16: {
                boolean bl = resultSet.getBoolean(n2);
                if (resultSet.wasNull()) break;
                string = Boolean.valueOf(bl).toString();
                break;
            }
            case 2005: {
                Clob clob = resultSet.getClob(n2);
                if (clob == null) break;
                string = CSVWriter.read(clob);
                break;
            }
            case -5: {
                long l = resultSet.getLong(n2);
                if (resultSet.wasNull()) break;
                string = Long.toString(l);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                BigDecimal bigDecimal = resultSet.getBigDecimal(n2);
                if (bigDecimal == null) break;
                string = bigDecimal.toString();
                break;
            }
            case -6: 
            case 4: 
            case 5: {
                int n3 = resultSet.getInt(n2);
                if (resultSet.wasNull()) break;
                string = Integer.toString(n3);
                break;
            }
            case 2000: {
                Object object = resultSet.getObject(n2);
                if (object == null) break;
                string = String.valueOf(object);
                break;
            }
            case 91: {
                Date date = resultSet.getDate(n2);
                if (date == null) break;
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MMM-yyyy");
                string = simpleDateFormat.format(date);
                break;
            }
            case 92: {
                Time time = resultSet.getTime(n2);
                if (time == null) break;
                string = time.toString();
                break;
            }
            case 93: {
                Timestamp timestamp = resultSet.getTimestamp(n2);
                if (timestamp == null) break;
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
                string = simpleDateFormat.format(timestamp);
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                string = resultSet.getString(n2);
                break;
            }
            default: {
                string = "";
            }
        }
        if (string == null) {
            string = "";
        }
        return string;
    }

    private static String read(Clob clob) throws SQLException, IOException {
        StringBuilder stringBuilder = new StringBuilder((int)clob.length());
        Reader reader = clob.getCharacterStream();
        char[] cArray = new char[2048];
        int n = 0;
        while ((n = reader.read(cArray, 0, cArray.length)) != -1) {
            if (n <= 0) continue;
            stringBuilder.append(cArray, 0, n);
        }
        return stringBuilder.toString();
    }

    public void writeNext(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(128);
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            if (i != 0) {
                stringBuilder.append(this.separator);
            }
            if ((string = stringArray[i]) == null) continue;
            if (this.quotechar != '\u0000') {
                stringBuilder.append(this.quotechar);
            }
            stringBuilder.append(this.stringContainsSpecialCharacters(string) ? this.processLine(string) : string);
            if (this.quotechar == '\u0000') continue;
            stringBuilder.append(this.quotechar);
        }
        stringBuilder.append(this.lineEnd);
        this.pw.write(stringBuilder.toString());
    }

    private boolean stringContainsSpecialCharacters(String string) {
        return string.indexOf(this.quotechar) != -1 || string.indexOf(this.escapechar) != -1;
    }

    private StringBuilder processLine(String string) {
        StringBuilder stringBuilder = new StringBuilder(128);
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (this.escapechar != '\u0000' && c == this.quotechar) {
                stringBuilder.append(this.escapechar).append(c);
                continue;
            }
            if (this.escapechar != '\u0000' && c == this.escapechar) {
                stringBuilder.append(this.escapechar).append(c);
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder;
    }

    public void flush() throws IOException {
        this.pw.flush();
    }

    @Override
    public void close() throws IOException {
        this.pw.flush();
        this.pw.close();
        this.rawWriter.close();
    }
}

