/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.websockets;

import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.EmptyCompletionHandler;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.impl.FutureImpl;
import org.glassfish.grizzly.impl.SafeFutureImpl;
import org.glassfish.grizzly.websockets.DataFrame;
import org.glassfish.grizzly.websockets.FrameType;
import org.glassfish.grizzly.websockets.HandShake;
import org.glassfish.grizzly.websockets.StrictUtf8;
import org.glassfish.grizzly.websockets.Utf8DecodingError;
import org.glassfish.grizzly.websockets.Utf8Utils;
import org.glassfish.grizzly.websockets.WebSocket;
import org.glassfish.grizzly.websockets.WebSocketApplication;
import org.glassfish.grizzly.websockets.WebSocketEngine;
import org.glassfish.grizzly.websockets.WebSocketException;
import org.glassfish.grizzly.websockets.draft06.ClosingFrame;
import org.glassfish.grizzly.websockets.frametypes.BinaryFrameType;
import org.glassfish.grizzly.websockets.frametypes.TextFrameType;

public abstract class ProtocolHandler {
    protected Connection connection;
    private WebSocket webSocket;
    protected byte inFragmentedType;
    protected byte outFragmentedType;
    protected final boolean maskData;
    protected FilterChainContext ctx;
    protected boolean processingFragment;
    protected Charset utf8 = new StrictUtf8();
    protected CharsetDecoder currentDecoder = this.utf8.newDecoder();
    protected ByteBuffer remainder;

    public ProtocolHandler(boolean maskData) {
        this.maskData = maskData;
    }

    public HandShake handshake(FilterChainContext ctx, WebSocketApplication app, HttpContent request) {
        HandShake handshake = this.createHandShake(request);
        handshake.respond(ctx, app, ((HttpRequestPacket)request.getHttpHeader()).getResponse());
        return handshake;
    }

    public final GrizzlyFuture<DataFrame> send(DataFrame frame) {
        return this.send(frame, null);
    }

    public GrizzlyFuture<DataFrame> send(DataFrame frame, CompletionHandler<DataFrame> completionHandler) {
        return this.write(frame, completionHandler);
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection handler) {
        this.connection = handler;
    }

    public FilterChainContext getFilterChainContext() {
        return this.ctx;
    }

    public void setFilterChainContext(FilterChainContext ctx) {
        this.ctx = ctx;
    }

    public WebSocket getWebSocket() {
        return this.webSocket;
    }

    public void setWebSocket(WebSocket webSocket) {
        this.webSocket = webSocket;
    }

    public boolean isMaskData() {
        return this.maskData;
    }

    public abstract byte[] frame(DataFrame var1);

    public abstract HandShake createHandShake(HttpContent var1);

    public abstract HandShake createHandShake(URI var1);

    public GrizzlyFuture<DataFrame> send(byte[] data) {
        return this.send(new DataFrame((FrameType)new BinaryFrameType(), data));
    }

    public GrizzlyFuture<DataFrame> send(String data) {
        return this.send(new DataFrame((FrameType)new TextFrameType(), data));
    }

    public GrizzlyFuture<DataFrame> stream(boolean last, byte[] bytes, int off, int len) {
        return this.send(new DataFrame((FrameType)new BinaryFrameType(), bytes, last));
    }

    public GrizzlyFuture<DataFrame> stream(boolean last, String fragment) {
        return this.send(new DataFrame((FrameType)new TextFrameType(), fragment, last));
    }

    public GrizzlyFuture<DataFrame> close(int code, String reason) {
        return this.send(new ClosingFrame(code, reason), (CompletionHandler<DataFrame>)new EmptyCompletionHandler<DataFrame>(){

            public void failed(Throwable throwable) {
                ProtocolHandler.this.webSocket.onClose(null);
            }

            public void completed(DataFrame result) {
                if (!ProtocolHandler.this.maskData) {
                    ProtocolHandler.this.webSocket.onClose(null);
                }
            }
        });
    }

    private GrizzlyFuture<DataFrame> write(final DataFrame frame, final CompletionHandler<DataFrame> completionHandler) {
        Connection localConnection = this.connection;
        if (localConnection == null) {
            throw new IllegalStateException("Connection is null");
        }
        SafeFutureImpl localFuture = SafeFutureImpl.create();
        localConnection.write((Object)frame, (CompletionHandler)new EmptyCompletionHandler((FutureImpl)localFuture){
            final /* synthetic */ FutureImpl val$localFuture;
            {
                this.val$localFuture = futureImpl;
            }

            public void completed(Object result) {
                if (completionHandler != null) {
                    completionHandler.completed((Object)frame);
                }
                this.val$localFuture.result((Object)frame);
            }

            public void failed(Throwable throwable) {
                if (completionHandler != null) {
                    completionHandler.failed(throwable);
                }
                this.val$localFuture.failure(throwable);
            }
        });
        return localFuture;
    }

    public DataFrame unframe(Buffer buffer) {
        return this.parse(buffer);
    }

    public abstract DataFrame parse(Buffer var1);

    public long decodeLength(byte[] bytes) {
        return WebSocketEngine.toLong(bytes, 0, bytes.length);
    }

    public byte[] encodeLength(long length) {
        byte[] lengthBytes;
        if (length <= 125L) {
            lengthBytes = new byte[]{(byte)length};
        } else {
            byte[] b = WebSocketEngine.toArray(length);
            if (length <= 65535L) {
                lengthBytes = new byte[3];
                lengthBytes[0] = 126;
                System.arraycopy(b, 6, lengthBytes, 1, 2);
            } else {
                lengthBytes = new byte[9];
                lengthBytes[0] = 127;
                System.arraycopy(b, 0, lengthBytes, 1, 8);
            }
        }
        return lengthBytes;
    }

    protected void validate(byte fragmentType, byte opcode) {
        if (fragmentType != 0 && opcode != fragmentType && !this.isControlFrame(opcode)) {
            throw new WebSocketException("Attempting to send a message while sending fragments of another");
        }
    }

    protected abstract boolean isControlFrame(byte var1);

    protected byte checkForLastFrame(DataFrame frame, byte opcode) {
        byte local = opcode;
        if (!frame.isLast()) {
            this.validate(this.outFragmentedType, local);
            if (this.outFragmentedType != 0) {
                local = 0;
            } else {
                this.outFragmentedType = local;
                local = (byte)(local & 0x7F);
            }
        } else if (this.outFragmentedType != 0) {
            local = -128;
            this.outFragmentedType = 0;
        } else {
            local = (byte)(local | 0x80);
        }
        return local;
    }

    public void doClose() {
        Connection localConnection = this.connection;
        if (localConnection == null) {
            throw new IllegalStateException("Connection is null");
        }
        localConnection.closeSilently();
    }

    protected void utf8Decode(boolean finalFragment, byte[] data, DataFrame dataFrame) {
        CharBuffer cb;
        block7: {
            ByteBuffer b = this.getByteBuffer(data);
            int n = (int)((float)b.remaining() * this.currentDecoder.averageCharsPerByte());
            cb = CharBuffer.allocate(n);
            while (true) {
                CoderResult result;
                if ((result = this.currentDecoder.decode(b, cb, finalFragment)).isUnderflow()) {
                    if (finalFragment) {
                        this.currentDecoder.flush(cb);
                        if (b.hasRemaining()) {
                            throw new IllegalStateException("Final UTF-8 fragment received, but not all bytes consumed by decode process");
                        }
                        this.currentDecoder.reset();
                    } else if (b.hasRemaining()) {
                        this.remainder = b;
                    }
                    break block7;
                }
                if (result.isOverflow()) {
                    CharBuffer tmp = CharBuffer.allocate(2 * n + 1);
                    cb.flip();
                    tmp.put(cb);
                    cb = tmp;
                    continue;
                }
                if (result.isError() || result.isMalformed()) break;
            }
            throw new Utf8DecodingError("Illegal UTF-8 Sequence");
        }
        cb.flip();
        String res = cb.toString();
        dataFrame.setPayload(res);
        dataFrame.setPayload(Utf8Utils.encode(new StrictUtf8(), res));
    }

    protected ByteBuffer getByteBuffer(byte[] data) {
        if (this.remainder == null) {
            return ByteBuffer.wrap(data);
        }
        int rem = this.remainder.remaining();
        byte[] orig = this.remainder.array();
        byte[] b = new byte[rem + data.length];
        System.arraycopy(orig, orig.length - rem, b, 0, rem);
        System.arraycopy(data, 0, b, rem, data.length);
        this.remainder = null;
        return ByteBuffer.wrap(b);
    }
}

