/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sns;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.auth.AWS4Signer;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.DefaultErrorResponseHandler;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.StaxResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.services.sns.AmazonSNS;
import com.amazonaws.services.sns.model.AddPermissionRequest;
import com.amazonaws.services.sns.model.ConfirmSubscriptionRequest;
import com.amazonaws.services.sns.model.ConfirmSubscriptionResult;
import com.amazonaws.services.sns.model.CreatePlatformApplicationRequest;
import com.amazonaws.services.sns.model.CreatePlatformApplicationResult;
import com.amazonaws.services.sns.model.CreatePlatformEndpointRequest;
import com.amazonaws.services.sns.model.CreatePlatformEndpointResult;
import com.amazonaws.services.sns.model.CreateTopicRequest;
import com.amazonaws.services.sns.model.CreateTopicResult;
import com.amazonaws.services.sns.model.DeleteEndpointRequest;
import com.amazonaws.services.sns.model.DeletePlatformApplicationRequest;
import com.amazonaws.services.sns.model.DeleteTopicRequest;
import com.amazonaws.services.sns.model.GetEndpointAttributesRequest;
import com.amazonaws.services.sns.model.GetEndpointAttributesResult;
import com.amazonaws.services.sns.model.GetPlatformApplicationAttributesRequest;
import com.amazonaws.services.sns.model.GetPlatformApplicationAttributesResult;
import com.amazonaws.services.sns.model.GetSubscriptionAttributesRequest;
import com.amazonaws.services.sns.model.GetSubscriptionAttributesResult;
import com.amazonaws.services.sns.model.GetTopicAttributesRequest;
import com.amazonaws.services.sns.model.GetTopicAttributesResult;
import com.amazonaws.services.sns.model.ListEndpointsByPlatformApplicationRequest;
import com.amazonaws.services.sns.model.ListEndpointsByPlatformApplicationResult;
import com.amazonaws.services.sns.model.ListPlatformApplicationsRequest;
import com.amazonaws.services.sns.model.ListPlatformApplicationsResult;
import com.amazonaws.services.sns.model.ListSubscriptionsByTopicRequest;
import com.amazonaws.services.sns.model.ListSubscriptionsByTopicResult;
import com.amazonaws.services.sns.model.ListSubscriptionsRequest;
import com.amazonaws.services.sns.model.ListSubscriptionsResult;
import com.amazonaws.services.sns.model.ListTopicsRequest;
import com.amazonaws.services.sns.model.ListTopicsResult;
import com.amazonaws.services.sns.model.PublishRequest;
import com.amazonaws.services.sns.model.PublishResult;
import com.amazonaws.services.sns.model.RemovePermissionRequest;
import com.amazonaws.services.sns.model.SetEndpointAttributesRequest;
import com.amazonaws.services.sns.model.SetPlatformApplicationAttributesRequest;
import com.amazonaws.services.sns.model.SetSubscriptionAttributesRequest;
import com.amazonaws.services.sns.model.SetTopicAttributesRequest;
import com.amazonaws.services.sns.model.SubscribeRequest;
import com.amazonaws.services.sns.model.SubscribeResult;
import com.amazonaws.services.sns.model.UnsubscribeRequest;
import com.amazonaws.services.sns.model.transform.AddPermissionRequestMarshaller;
import com.amazonaws.services.sns.model.transform.AuthorizationErrorExceptionUnmarshaller;
import com.amazonaws.services.sns.model.transform.ConfirmSubscriptionRequestMarshaller;
import com.amazonaws.services.sns.model.transform.ConfirmSubscriptionResultStaxUnmarshaller;
import com.amazonaws.services.sns.model.transform.CreatePlatformApplicationRequestMarshaller;
import com.amazonaws.services.sns.model.transform.CreatePlatformApplicationResultStaxUnmarshaller;
import com.amazonaws.services.sns.model.transform.CreatePlatformEndpointRequestMarshaller;
import com.amazonaws.services.sns.model.transform.CreatePlatformEndpointResultStaxUnmarshaller;
import com.amazonaws.services.sns.model.transform.CreateTopicRequestMarshaller;
import com.amazonaws.services.sns.model.transform.CreateTopicResultStaxUnmarshaller;
import com.amazonaws.services.sns.model.transform.DeleteEndpointRequestMarshaller;
import com.amazonaws.services.sns.model.transform.DeletePlatformApplicationRequestMarshaller;
import com.amazonaws.services.sns.model.transform.DeleteTopicRequestMarshaller;
import com.amazonaws.services.sns.model.transform.EndpointDisabledExceptionUnmarshaller;
import com.amazonaws.services.sns.model.transform.GetEndpointAttributesRequestMarshaller;
import com.amazonaws.services.sns.model.transform.GetEndpointAttributesResultStaxUnmarshaller;
import com.amazonaws.services.sns.model.transform.GetPlatformApplicationAttributesRequestMarshaller;
import com.amazonaws.services.sns.model.transform.GetPlatformApplicationAttributesResultStaxUnmarshaller;
import com.amazonaws.services.sns.model.transform.GetSubscriptionAttributesRequestMarshaller;
import com.amazonaws.services.sns.model.transform.GetSubscriptionAttributesResultStaxUnmarshaller;
import com.amazonaws.services.sns.model.transform.GetTopicAttributesRequestMarshaller;
import com.amazonaws.services.sns.model.transform.GetTopicAttributesResultStaxUnmarshaller;
import com.amazonaws.services.sns.model.transform.InternalErrorExceptionUnmarshaller;
import com.amazonaws.services.sns.model.transform.InvalidParameterExceptionUnmarshaller;
import com.amazonaws.services.sns.model.transform.ListEndpointsByPlatformApplicationRequestMarshaller;
import com.amazonaws.services.sns.model.transform.ListEndpointsByPlatformApplicationResultStaxUnmarshaller;
import com.amazonaws.services.sns.model.transform.ListPlatformApplicationsRequestMarshaller;
import com.amazonaws.services.sns.model.transform.ListPlatformApplicationsResultStaxUnmarshaller;
import com.amazonaws.services.sns.model.transform.ListSubscriptionsByTopicRequestMarshaller;
import com.amazonaws.services.sns.model.transform.ListSubscriptionsByTopicResultStaxUnmarshaller;
import com.amazonaws.services.sns.model.transform.ListSubscriptionsRequestMarshaller;
import com.amazonaws.services.sns.model.transform.ListSubscriptionsResultStaxUnmarshaller;
import com.amazonaws.services.sns.model.transform.ListTopicsRequestMarshaller;
import com.amazonaws.services.sns.model.transform.ListTopicsResultStaxUnmarshaller;
import com.amazonaws.services.sns.model.transform.NotFoundExceptionUnmarshaller;
import com.amazonaws.services.sns.model.transform.PlatformApplicationDisabledExceptionUnmarshaller;
import com.amazonaws.services.sns.model.transform.PublishRequestMarshaller;
import com.amazonaws.services.sns.model.transform.PublishResultStaxUnmarshaller;
import com.amazonaws.services.sns.model.transform.RemovePermissionRequestMarshaller;
import com.amazonaws.services.sns.model.transform.SetEndpointAttributesRequestMarshaller;
import com.amazonaws.services.sns.model.transform.SetPlatformApplicationAttributesRequestMarshaller;
import com.amazonaws.services.sns.model.transform.SetSubscriptionAttributesRequestMarshaller;
import com.amazonaws.services.sns.model.transform.SetTopicAttributesRequestMarshaller;
import com.amazonaws.services.sns.model.transform.SubscribeRequestMarshaller;
import com.amazonaws.services.sns.model.transform.SubscribeResultStaxUnmarshaller;
import com.amazonaws.services.sns.model.transform.SubscriptionLimitExceededExceptionUnmarshaller;
import com.amazonaws.services.sns.model.transform.TopicLimitExceededExceptionUnmarshaller;
import com.amazonaws.services.sns.model.transform.UnsubscribeRequestMarshaller;
import com.amazonaws.transform.StandardErrorUnmarshaller;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmazonSNSClient
extends AmazonWebServiceClient
implements AmazonSNS {
    private AWSCredentialsProvider awsCredentialsProvider;
    protected final List<Unmarshaller<AmazonServiceException, Node>> exceptionUnmarshallers = new ArrayList<Unmarshaller<AmazonServiceException, Node>>();
    private AWS4Signer signer;

    public AmazonSNSClient() {
        this(new DefaultAWSCredentialsProviderChain(), new ClientConfiguration());
    }

    public AmazonSNSClient(ClientConfiguration clientConfiguration) {
        this(new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public AmazonSNSClient(AWSCredentials awsCredentials) {
        this(awsCredentials, new ClientConfiguration());
    }

    public AmazonSNSClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AmazonSNSClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, new ClientConfiguration());
    }

    public AmazonSNSClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    private void init() {
        this.exceptionUnmarshallers.add(new TopicLimitExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new NotFoundExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new EndpointDisabledExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new PlatformApplicationDisabledExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidParameterExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new AuthorizationErrorExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InternalErrorExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new SubscriptionLimitExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new StandardErrorUnmarshaller());
        this.setEndpoint("sns.us-east-1.amazonaws.com");
        this.signer = new AWS4Signer();
        this.signer.setServiceName("sns");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandlers.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/sns/request.handlers"));
    }

    @Override
    public ConfirmSubscriptionResult confirmSubscription(ConfirmSubscriptionRequest confirmSubscriptionRequest) throws AmazonServiceException, AmazonClientException {
        Request<ConfirmSubscriptionRequest> request = new ConfirmSubscriptionRequestMarshaller().marshall(confirmSubscriptionRequest);
        return this.invoke(request, new ConfirmSubscriptionResultStaxUnmarshaller());
    }

    @Override
    public CreatePlatformApplicationResult createPlatformApplication(CreatePlatformApplicationRequest createPlatformApplicationRequest) throws AmazonServiceException, AmazonClientException {
        Request<CreatePlatformApplicationRequest> request = new CreatePlatformApplicationRequestMarshaller().marshall(createPlatformApplicationRequest);
        return this.invoke(request, new CreatePlatformApplicationResultStaxUnmarshaller());
    }

    @Override
    public GetTopicAttributesResult getTopicAttributes(GetTopicAttributesRequest getTopicAttributesRequest) throws AmazonServiceException, AmazonClientException {
        Request<GetTopicAttributesRequest> request = new GetTopicAttributesRequestMarshaller().marshall(getTopicAttributesRequest);
        return this.invoke(request, new GetTopicAttributesResultStaxUnmarshaller());
    }

    @Override
    public SubscribeResult subscribe(SubscribeRequest subscribeRequest) throws AmazonServiceException, AmazonClientException {
        Request<SubscribeRequest> request = new SubscribeRequestMarshaller().marshall(subscribeRequest);
        return this.invoke(request, new SubscribeResultStaxUnmarshaller());
    }

    @Override
    public void deleteEndpoint(DeleteEndpointRequest deleteEndpointRequest) throws AmazonServiceException, AmazonClientException {
        Request<DeleteEndpointRequest> request = new DeleteEndpointRequestMarshaller().marshall(deleteEndpointRequest);
        this.invoke(request, null);
    }

    @Override
    public void setTopicAttributes(SetTopicAttributesRequest setTopicAttributesRequest) throws AmazonServiceException, AmazonClientException {
        Request<SetTopicAttributesRequest> request = new SetTopicAttributesRequestMarshaller().marshall(setTopicAttributesRequest);
        this.invoke(request, null);
    }

    @Override
    public void removePermission(RemovePermissionRequest removePermissionRequest) throws AmazonServiceException, AmazonClientException {
        Request<RemovePermissionRequest> request = new RemovePermissionRequestMarshaller().marshall(removePermissionRequest);
        this.invoke(request, null);
    }

    @Override
    public GetEndpointAttributesResult getEndpointAttributes(GetEndpointAttributesRequest getEndpointAttributesRequest) throws AmazonServiceException, AmazonClientException {
        Request<GetEndpointAttributesRequest> request = new GetEndpointAttributesRequestMarshaller().marshall(getEndpointAttributesRequest);
        return this.invoke(request, new GetEndpointAttributesResultStaxUnmarshaller());
    }

    @Override
    public ListSubscriptionsResult listSubscriptions(ListSubscriptionsRequest listSubscriptionsRequest) throws AmazonServiceException, AmazonClientException {
        Request<ListSubscriptionsRequest> request = new ListSubscriptionsRequestMarshaller().marshall(listSubscriptionsRequest);
        return this.invoke(request, new ListSubscriptionsResultStaxUnmarshaller());
    }

    @Override
    public CreatePlatformEndpointResult createPlatformEndpoint(CreatePlatformEndpointRequest createPlatformEndpointRequest) throws AmazonServiceException, AmazonClientException {
        Request<CreatePlatformEndpointRequest> request = new CreatePlatformEndpointRequestMarshaller().marshall(createPlatformEndpointRequest);
        return this.invoke(request, new CreatePlatformEndpointResultStaxUnmarshaller());
    }

    @Override
    public void setSubscriptionAttributes(SetSubscriptionAttributesRequest setSubscriptionAttributesRequest) throws AmazonServiceException, AmazonClientException {
        Request<SetSubscriptionAttributesRequest> request = new SetSubscriptionAttributesRequestMarshaller().marshall(setSubscriptionAttributesRequest);
        this.invoke(request, null);
    }

    @Override
    public CreateTopicResult createTopic(CreateTopicRequest createTopicRequest) throws AmazonServiceException, AmazonClientException {
        Request<CreateTopicRequest> request = new CreateTopicRequestMarshaller().marshall(createTopicRequest);
        return this.invoke(request, new CreateTopicResultStaxUnmarshaller());
    }

    @Override
    public GetSubscriptionAttributesResult getSubscriptionAttributes(GetSubscriptionAttributesRequest getSubscriptionAttributesRequest) throws AmazonServiceException, AmazonClientException {
        Request<GetSubscriptionAttributesRequest> request = new GetSubscriptionAttributesRequestMarshaller().marshall(getSubscriptionAttributesRequest);
        return this.invoke(request, new GetSubscriptionAttributesResultStaxUnmarshaller());
    }

    @Override
    public ListTopicsResult listTopics(ListTopicsRequest listTopicsRequest) throws AmazonServiceException, AmazonClientException {
        Request<ListTopicsRequest> request = new ListTopicsRequestMarshaller().marshall(listTopicsRequest);
        return this.invoke(request, new ListTopicsResultStaxUnmarshaller());
    }

    @Override
    public void deletePlatformApplication(DeletePlatformApplicationRequest deletePlatformApplicationRequest) throws AmazonServiceException, AmazonClientException {
        Request<DeletePlatformApplicationRequest> request = new DeletePlatformApplicationRequestMarshaller().marshall(deletePlatformApplicationRequest);
        this.invoke(request, null);
    }

    @Override
    public ListPlatformApplicationsResult listPlatformApplications(ListPlatformApplicationsRequest listPlatformApplicationsRequest) throws AmazonServiceException, AmazonClientException {
        Request<ListPlatformApplicationsRequest> request = new ListPlatformApplicationsRequestMarshaller().marshall(listPlatformApplicationsRequest);
        return this.invoke(request, new ListPlatformApplicationsResultStaxUnmarshaller());
    }

    @Override
    public void setEndpointAttributes(SetEndpointAttributesRequest setEndpointAttributesRequest) throws AmazonServiceException, AmazonClientException {
        Request<SetEndpointAttributesRequest> request = new SetEndpointAttributesRequestMarshaller().marshall(setEndpointAttributesRequest);
        this.invoke(request, null);
    }

    @Override
    public void unsubscribe(UnsubscribeRequest unsubscribeRequest) throws AmazonServiceException, AmazonClientException {
        Request<UnsubscribeRequest> request = new UnsubscribeRequestMarshaller().marshall(unsubscribeRequest);
        this.invoke(request, null);
    }

    @Override
    public void deleteTopic(DeleteTopicRequest deleteTopicRequest) throws AmazonServiceException, AmazonClientException {
        Request<DeleteTopicRequest> request = new DeleteTopicRequestMarshaller().marshall(deleteTopicRequest);
        this.invoke(request, null);
    }

    @Override
    public GetPlatformApplicationAttributesResult getPlatformApplicationAttributes(GetPlatformApplicationAttributesRequest getPlatformApplicationAttributesRequest) throws AmazonServiceException, AmazonClientException {
        Request<GetPlatformApplicationAttributesRequest> request = new GetPlatformApplicationAttributesRequestMarshaller().marshall(getPlatformApplicationAttributesRequest);
        return this.invoke(request, new GetPlatformApplicationAttributesResultStaxUnmarshaller());
    }

    @Override
    public void setPlatformApplicationAttributes(SetPlatformApplicationAttributesRequest setPlatformApplicationAttributesRequest) throws AmazonServiceException, AmazonClientException {
        Request<SetPlatformApplicationAttributesRequest> request = new SetPlatformApplicationAttributesRequestMarshaller().marshall(setPlatformApplicationAttributesRequest);
        this.invoke(request, null);
    }

    @Override
    public void addPermission(AddPermissionRequest addPermissionRequest) throws AmazonServiceException, AmazonClientException {
        Request<AddPermissionRequest> request = new AddPermissionRequestMarshaller().marshall(addPermissionRequest);
        this.invoke(request, null);
    }

    @Override
    public ListEndpointsByPlatformApplicationResult listEndpointsByPlatformApplication(ListEndpointsByPlatformApplicationRequest listEndpointsByPlatformApplicationRequest) throws AmazonServiceException, AmazonClientException {
        Request<ListEndpointsByPlatformApplicationRequest> request = new ListEndpointsByPlatformApplicationRequestMarshaller().marshall(listEndpointsByPlatformApplicationRequest);
        return this.invoke(request, new ListEndpointsByPlatformApplicationResultStaxUnmarshaller());
    }

    @Override
    public ListSubscriptionsByTopicResult listSubscriptionsByTopic(ListSubscriptionsByTopicRequest listSubscriptionsByTopicRequest) throws AmazonServiceException, AmazonClientException {
        Request<ListSubscriptionsByTopicRequest> request = new ListSubscriptionsByTopicRequestMarshaller().marshall(listSubscriptionsByTopicRequest);
        return this.invoke(request, new ListSubscriptionsByTopicResultStaxUnmarshaller());
    }

    @Override
    public PublishResult publish(PublishRequest publishRequest) throws AmazonServiceException, AmazonClientException {
        Request<PublishRequest> request = new PublishRequestMarshaller().marshall(publishRequest);
        return this.invoke(request, new PublishResultStaxUnmarshaller());
    }

    @Override
    public ListSubscriptionsResult listSubscriptions() throws AmazonServiceException, AmazonClientException {
        return this.listSubscriptions(new ListSubscriptionsRequest());
    }

    @Override
    public ListTopicsResult listTopics() throws AmazonServiceException, AmazonClientException {
        return this.listTopics(new ListTopicsRequest());
    }

    @Override
    public ListPlatformApplicationsResult listPlatformApplications() throws AmazonServiceException, AmazonClientException {
        return this.listPlatformApplications(new ListPlatformApplicationsRequest());
    }

    public void setEndpoint(String endpoint, String serviceName, String regionId) throws IllegalArgumentException {
        this.setEndpoint(endpoint);
        this.signer.setServiceName(serviceName);
        this.signer.setRegionName(regionId);
    }

    @Override
    protected String getServiceAbbreviation() {
        return "sns";
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> X invoke(Request<Y> request, Unmarshaller<X, StaxUnmarshallerContext> unmarshaller) {
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        for (Map.Entry<String, String> entry : request.getOriginalRequest().copyPrivateRequestParameters().entrySet()) {
            request.addParameter(entry.getKey(), entry.getValue());
        }
        AWSCredentials credentials = this.awsCredentialsProvider.getCredentials();
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        if (originalRequest != null && originalRequest.getRequestCredentials() != null) {
            credentials = originalRequest.getRequestCredentials();
        }
        ExecutionContext executionContext = this.createExecutionContext();
        executionContext.setSigner(this.signer);
        executionContext.setCredentials(credentials);
        StaxResponseHandler<X> responseHandler = new StaxResponseHandler<X>(unmarshaller);
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (X)this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }
}

