/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.admin.storage.mysqlStorage;

import com.openexchange.admin.rmi.dataobjects.SchemaSelectStrategy;
import com.openexchange.admin.rmi.dataobjects.SchemaSelectStrategy.Strategy;
import com.openexchange.admin.schemacache.SchemaCacheFinalize;
import com.openexchange.admin.schemacache.SchemaCacheResult;

/**
 * {@link SchemaResult} - A simple class to reflect how a context's schema has been determined.
 *
 * @author <a href="mailto:thorben.betten@open-xchange.com">Thorben Betten</a>
 * @since v7.8.0
 */
public class SchemaResult {

    /** The constant for automatic schema creation/detection */
    public static final SchemaResult AUTOMATIC = new SchemaResult(Strategy.AUTOMATIC, null);

    /** The constant for pre-defined schema name */
    public static final SchemaResult SCHEMA_NAME = new SchemaResult(Strategy.SCHEMA, null);

    /**
     * Gets a result for in-memory schema detection with given roll-back.
     *
     * @param cacheResult The cache result
     * @return The result for in-memory schema detection
     */
    public static SchemaResult inMemoryWith(SchemaCacheResult cacheResult) {
        return new SchemaResult(Strategy.IN_MEMORY, cacheResult);
    }

    // -----------------------------------------------------------------------------------------------------------------

    private final SchemaSelectStrategy.Strategy strategy;
    private final SchemaCacheResult cacheResult;

    /**
     * Initializes a new {@link SchemaResult}.
     *
     * @param strategy The utilized strategy
     * @param cacheResult The cache result
     */
    private SchemaResult(Strategy strategy, SchemaCacheResult cacheResult) {
        super();
        this.strategy = strategy;
        this.cacheResult = cacheResult;
    }

    /**
     * Gets the utilized strategy
     *
     * @return The utilized strategy
     */
    public SchemaSelectStrategy.Strategy getStrategy() {
        return strategy;
    }

    /**
     * Gets the optional cache roll-back.
     *
     * @return The cacheRollback or <code>null</code>
     */
    public SchemaCacheFinalize getCacheFinalize() {
        return null == cacheResult ? null : cacheResult.getFinalize();
    }

}
