/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.osgi.worker.handler;

import com.openexchange.build.pdejava.PDEJavaPlugin;
import com.openexchange.osgi.OSGiPlugin;
import com.openexchange.osgi.data.ModuleDatabase;
import com.openexchange.osgi.data.OSGIManifest;
import com.openexchange.osgi.worker.handler.ProjectHandler;
import java.io.File;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/openexchange/osgi/worker/handler/OSGiBundleHandler;", "Lcom/openexchange/osgi/worker/handler/ProjectHandler;", "()V", "handle", "", "project", "Lorg/gradle/api/Project;", "osgi"})
public final class OSGiBundleHandler
implements ProjectHandler {
    @Override
    public void handle(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Logger logger = project.getLogger();
        String string = project.getProjectDir().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"project.projectDir.toString()");
        String path = string;
        logger.debug("{}: Looking for manifest file in path: {}", (Object)"OSGi-Plugin", (Object)path);
        File manifestFile = new File(project.getProjectDir(), "META-INF/MANIFEST.MF");
        if (!manifestFile.isFile() || !manifestFile.canRead()) {
            throw (Throwable)new GradleException("Could not read MANIFEST.MF for subProject: " + project.getName());
        }
        try {
            logger.debug("{}: Found manifest file in path: {}", (Object)"OSGi-Plugin", (Object)path);
            OSGIManifest osgiManifest = new OSGIManifest(manifestFile);
            project.getPlugins().apply(PDEJavaPlugin.class);
            ModuleDatabase moduleDatabase = OSGiPlugin.Companion.getModuleDatabase();
            String string2 = project.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"project.name");
            moduleDatabase.addModule(string2, osgiManifest);
        }
        catch (IOException e) {
            throw (Throwable)new GradleException("Could not read MANIFEST.MF for subProject: " + project.getName() + ", because: " + e.getMessage(), (Throwable)e);
        }
    }
}

