/**
 * 
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) Open-Xchange Inc., 2006-2012
 * Mail: info@open-xchange.com 
 * 
 * @author Suphi Basdemir <suphi.basdemir@open-xchange.com>
 * 
 */

var globalclickdisable2=true;
var activeComboBox = null;

function changePopUpMenuText3(obj, n, noevent) {
    var myValues = [];
    myValues = obj.elements[n];
    
    if (myValues.callback.nodeType || typeof myValues.callback == "function") {
        obj.currentI18nNode.callback = myValues.callback;
    } else {
        obj.currentI18nNode.callback = function() {
            return String(myValues.callback);
        };
    }
    obj.currentI18nNode.update();
    obj.selected = n;
    var key = myValues.key;
     
    if (obj.targetDiv) {
        if (obj.form) {
            obj.targetDiv.value = key;
        } else {
        	removeChildNodes(obj.targetDiv);
        	if (key) {
        		if (obj.valueIsHTML) {
        			obj.targetDiv.appendChild(key);
        		} else {
        			obj.targetDiv.appendChild(newtext(key));
        		}
        	}   
        }        
    }
    if (obj.onChange && !noevent) {
        obj.onChange(key, obj.currentResult);
    }
    obj.currentResult = key;
}

function createComboBoxOverlay(scope) {
    // overlay - combo-box may block - not unusual
    return jQuery("<div/>")
        .addClass("oxStretch")
        .css({
            display: "none",
            opacity: 0.01,
            zIndex: 40000,
            backgroundColor: "white"
        })
        .bind("click", function (e) {
            scope.overlay.hide();
            showHideBox3(scope, e);
        })
        .appendTo(document.body);
}

/**
 * Make ComboBox
 * @param {object} current Window where the combobox is called
 * @param {String} id of rootDiv, to append the combobox
 * @param {String} width from the combobox
 * @param {int} index of selected item from the elements
 * @param {boolean} default Style, should be used ore not
 * @param {String} eventname to trigger an event onChange
 * @param {int} scrollbar should be shown after n items
 * example:
 * new ComboBox3(window, "start_time", "15em", myElements, 0, false, changetime, 6);
 */

function ComboBox3(window, elementid, width, selected, style, eventname, maxscrollbar,eventParam) {
    return new ComboBox3.impl(window, ($ALL(elementid) || newnode("div")), width, selected, style,
        maxscrollbar,
        function(key) { triggerEvent(eventname, key, eventParam); } );
}

ComboBox3.impl = function (window, rootDiv, width, selected, style, maxscrollbar, onchange, onshow, onhide) {
    this.window = window;
    this.selected = selected;
    this.elements = [];
    this.width=width;
    this.maxscrollbar=maxscrollbar;
    this.style = style;
    this.targetDiv = null;
    this.valueIsHTML = false; //the value is a node
    this.form = false;
    this.viewValue = false;
    this.disabled = false;        
    this.rowHeight;    
    this.childOffsetTop;
    var Self = this;
    this.rootDiv = rootDiv;
    this.rootDiv.tabIndex = 0;
    this.rootDiv.style.outline = "none";
    this.keydown_cb = function(e) {
        return Self.key(e);
    };
    addDOMEvent(this.rootDiv, "keydown", this.keydown_cb);
    this.rootDiv.innerHTML = "";
    this.headTable = newnode('table',0,{
                     cellPadding: 0, cellSpacing: 0, border: 0});
    this.headTable.style.tableLayout="fixed";
    this.headTableBody = document.createElement("tbody");
    this.headTableRow = document.createElement("tr");
    this.headTableColumn1 = document.createElement("td");    
    this.headTableColumn1.setAttribute("nowrap","nowrap");
    this.headTableColumn1.style.whiteSpace = "nowrap";
    this.headTableColumn1div = document.createElement("div");    
    this.headTableColumn1.appendChild(this.headTableColumn1div);
    this.headTableColumn1div.style.width = "92%";    
    this.headTableColumn1div.style.paddingRight = "3px";        
    this.headTableColumn1div.style.overflow = "hidden";    
    this.headTableColumn2 = document.createElement("td");
    this.headTableColumn2.setAttribute("width","14");
    this.myboxComboDiv = document.createElement("div");
    jQuery(this.myboxComboDiv).click(function(evt) {
    	// handle click on combo layer
        showHideBox3(Self, evt);
        return false;
    });
    this.keySearch = {};
    
    if(this.style) {
        this.headTable.className="smallpopupborder border-color-design smallpopupnotactive background-color-content font-color-default";
        this.headTableColumn1.className="smallpopupborderright border-color-design comboboxColumn1 cursorPointer";
        this.headTableColumn2.className="comboboxColumn2 borderLeftDefault border-color-design";
    }
    this.rootDiv.style.width=this.width;
    this.rootDiv.className="dropdownbox";
    
    this.currentValues = [];
    
    this.currentResult = "";
    
    this.onChange = onchange;
    this.onShow = onshow;
    this.onHide = onhide;
        
    if(maxscrollbar) {  
        this.scrollbar=maxscrollbar;
    } else { 
        this.scrollbar=null;
    }
        
    this.setFirstDiv();
    
    // overlay
    this.overlay = createComboBoxOverlay(this);
};

ComboBox3.impl.prototype = {
    sort: function () {
        function fn(a,b) {
            if(a.value < b.value) {
                return -1;
            } else {
                return 1;
            }
        }
        this.elements.sort(fn);
    },
    sorti18nValue: function () {
        function fn(a,b) {
            //if(a.i18nNode.node.nodeValue < b.i18nNode.node.nodeValue)
            if(a.key == "" ) {
                return -1;
            } else if(b.key == "" ) { 
                return 1;
            } else {
                return a.i18nNode.node.nodeValue.localeCompare( b.i18nNode.node.nodeValue ) ;
            }
        }
        this.elements.sort(fn);
    },
    sortKeys: function () {
        function fn(a,b) {
            if(a.key < b.key) {
                return -1;
            } else {
                return 1;
            }
        }
        this.elements.sort(fn);
    },
    getValue : function () {
        this.currentValues = this.elements[this.selected];
        this.currentValue = this.currentValues.value;
        return this.currentValue;
    },
    setEnabled : function (value) {
        //TODO DISABLED;
    },
    getKey : function () {
        this.currentValues = this.elements[this.selected];
        this.currentResult = this.currentValues.key;
        return this.currentResult;
    }, 
    getSelectedIndex : function () {
        return this.selected;
    },
    setSelectedIndex : function (n, noevent) {
        changePopUpMenuText3(this, n, noevent);
    },
    disable : function () {
        var Self = this;
        Self.headTable.className = Self.headTable.className.replace(/font-color-default/, "font-color-disabled");
        Self.disabled = true;
        Self.headTableColumn2.style.cursor = "default";
        //Self.window.removeDOMEvent(Self.headTable,"click", Self.clickOnCombobox);
    },
    enable : function () {
        var Self = this;
        Self.disabled = false;            
        Self.headTable.className = Self.headTable.className.replace(/font-color-disabled/, "font-color-default");
        Self.headTableColumn2.style.cursor = "pointer";
        //Self.window.addDOMEvent(Self.headTable,"click", Self.clickOnCombobox);  
    },
    setKey : function (key,noevent) {
        var myElValues = [];
        var newIndex = key;
        var bFound = false;
        for(i=0; i<this.elements.length;i++) {
            myElValues = this.elements[i];
                    if (key == myElValues.key) {
                        key = myElValues.key;
                        newIndex = i;
                        bFound = true;
                        break;
                    }               
        }
        if(!bFound) {
            return false;
        }
        if(this.elements[newIndex]) {
            changePopUpMenuText3(
                    this,
                    newIndex,
                    noevent
            );
        }                    
        return true;        
    },    
    setValue : function (value,noevent) {
        var myElValues = [];
        var newIndex = value;
        var bFound = false;
        for(i=0; i<this.elements.length;i++) {
            myElValues = this.elements[i];
            
            if(myElValues.i18nNode && myElValues.i18nNode.node && myElValues.i18nNode.node.nodeValue) {
                myi18nValue = myElValues.i18nNode.node.nodeValue;
            } else {
                myi18nValue = this.elements[i];
            }
                
             if (value == myElValues.value || value == myi18nValue) {
                 value = myElValues.value;
                 newIndex = i;
                 bFound = true;
                 break;
             }         
        }
        if(!bFound) {
            return false;
        }
        if(this.elements[newIndex]) {
            changePopUpMenuText3(
                    this,
                    newIndex,
                    noevent
            );
        }                    
        return true;        
    },    
    setUnknownKey : function(key) {                    
        this.targetDiv.firstChild.data = key;
    },
    scrollToSelected: function (tmpIndex) {
        if (this.scrollbar) {
            // vars
            var index, node, top;
            // get index
            index = tmpIndex !== undefined ? tmpIndex : this.selected;
            // get position & scroll
            node = jQuery(this.myboxComboDiv);
            top = (node.scrollTop() + node.children().eq(index).position().top) >> 0;
            node.scrollTop(top);
        }
    },
    
    key: function(e) {
        switch (e.keyCode || e.which) {
        case 13: // enter
            break;
        case 32: // spacebar
            break;
        case 38: // arrow up
            break;
        case 40: // arrow down
            break;
        case 65: // A
        case 97: // a        
            if (this.keySearch["a"]) {
                this.scrollToSelected(this.keySearch["a"][0]);
            }
            break;
        case 66: // B
        case 98: // b    
            if (this.keySearch["b"]) {    
                this.scrollToSelected(this.keySearch["b"][0]);
            }
            break;
        case 67: // C
        case 99: // c    
            if (this.keySearch["c"]) { 
                this.scrollToSelected(this.keySearch["c"][0]);
            }
            break;
        case 68: // D
        case 100: // d        
            if (this.keySearch["d"]) {
                this.scrollToSelected(this.keySearch["d"][0]);
            }
            break;
        case 69: // E
        case 101: // e        
            if (this.keySearch["e"]) {
                this.scrollToSelected(this.keySearch["e"][0]);
            }
            break;
        case 70: // F
        case 102: // f        
            if (this.keySearch["f"]) {
                this.scrollToSelected(this.keySearch["f"][0]);
            }
            break;
        case 71: // G
        case 103: // g        
            if (this.keySearch["g"]) {
                this.scrollToSelected(this.keySearch["g"][0]);
            }
            break;
        case 72: // H
        case 104: // h        
            if (this.keySearch["h"]) {
                this.scrollToSelected(this.keySearch["h"][0]);
            }
            break;
        case 73: // I
        case 105: // i        
            if (this.keySearch["i"]) {
                this.scrollToSelected(this.keySearch["i"][0]);
            }
            break;
        case 74: // J
        case 106: // j        
            if (this.keySearch["j"]) {
                this.scrollToSelected(this.keySearch["j"][0]);
            }
            break;
        case 75: // K
        case 107: // k        
            if (this.keySearch["k"]) {
                this.scrollToSelected(this.keySearch["k"][0]);
            }
            break;
        case 76: // L
        case 108: // l        
            if (this.keySearch["l"]) {
                this.scrollToSelected(this.keySearch["l"][0]);
            }
            break;
        case 77: // M
        case 109: // m        
            if (this.keySearch["m"]) {
                this.scrollToSelected(this.keySearch["m"][0]);
            }
            break;
        case 78: // N
        case 110: // n        
            if (this.keySearch["n"]) {
                this.scrollToSelected(this.keySearch["n"][0]);
            }
            break;
        case 79: // O
        case 111: // o    
            if (this.keySearch["o"]) {
                this.scrollToSelected(this.keySearch["o"][0]);
            }
            break;
        case 80: // P
        case 112: // p        
            if (this.keySearch["p"]) {
                this.scrollToSelected(this.keySearch["p"][0]);
            }
            break;
        case 81: // Q
        case 113: // q        
            if (this.keySearch["q"]) {
                this.scrollToSelected(this.keySearch["q"][0]);
            }
            break;
        case 82: // R
        case 114: // r        
            if (this.keySearch["r"]) {
                this.scrollToSelected(this.keySearch["r"][0]);
            }
            break;
        case 83: // S
        case 115: // s        
            if (this.keySearch["s"]) {
                this.scrollToSelected(this.keySearch["s"][0]);
            }
            break;
        case 84: // T
        case 116: // t        
            if (this.keySearch["t"]) {
                this.scrollToSelected(this.keySearch["t"][0]);
            }
            break;
        case 85: // U
        case 117: // u        
            if (this.keySearch["u"]) {
                this.scrollToSelected(this.keySearch["u"][0]);
            }
            break;
        case 86: // V
        case 118: // v        
            if (this.keySearch["v"]) {
                this.scrollToSelected(this.keySearch["v"][0]);
            }
            break;
        case 87: // W
        case 119: // w        
            if (this.keySearch["w"]) {
                this.scrollToSelected(this.keySearch["w"][0]);
            }
            break;
        case 88: // X
        case 120: // x        
            if (this.keySearch["x"]) {
                this.scrollToSelected(this.keySearch["x"][0]);
            }
            break;
        case 89: // Y
        case 121: // y        
            if (this.keySearch["y"]) {
                this.scrollToSelected(this.keySearch["y"][0]);
            }
            break;
        case 90: // Z
        case 122: // z        
            if (this.keySearch["z"]) {
                this.scrollToSelected(this.keySearch["z"][0]);
            }
            break;
        default:
            return;
        }
        stopEvent(e);
        return false;
    },
    
    setFirstDiv: function () {
        var Self = this;
                        
        Self.clickOnCombobox = function (e) { 
            if(!Self.disabled) {
                showHideBox3(Self,e);
                cancelBubbling(e);
            }
            cancelDefault(e);
        };
        
        Self.headTable.style.width=this.width;    
        setTimeout(function () {
            var tmpW = Self.headTable.offsetWidth - 16;
                
            Self.headTableColumn2.style.width="16px";
            Self.headTableColumn2.style.textAlign="center";
        
            Self.image=document.createElement("img");
            Self.image.className="cursorPointer";
            Self.image.setAttribute("src",getFullImgSrc("img/arrows/arrow_white_down.png"));
            Self.headTableColumn2.appendChild(Self.image);
            Self.headTableRow.appendChild(Self.headTableColumn1);    
            Self.headTableRow.appendChild(Self.headTableColumn2);
            Self.headTableBody.appendChild(Self.headTableRow);
            Self.headTable.appendChild(Self.headTableBody);
            
            Self.window.addDOMEvent(Self.headTable,
                "click", Self.clickOnCombobox);  
                
               Self.window.addDOMEvent(Self.headTable,
                "mouseover", function() { globalclickdisable2=true; }); 
                
               Self.window.addDOMEvent(Self.headTable,
                "mouseout", function() { globalclickdisable2=false; });  
        }, 0);        
        
        Self.rootDiv.appendChild(Self.headTable);
        
    },
    
    clickOnCombobox: function (e) { 
        showHideBox3(this,e);
    },
    
    addElement: function (value, key, callback) {
        if (typeof value == "string") {
            if(value.length > 0) {
                var indexKeySearchSingle = value.substr(0,1).toLowerCase();
                if (typeof this.keySearch[indexKeySearchSingle] == "undefined") {
                    this.keySearch[indexKeySearchSingle] = [];
                }
                this.keySearch[indexKeySearchSingle].push(this.elements.length);
            }
            /*
             * for later implemantation
            if(key.length > 1) {
                var indexKeySearchDuo = key.substr(0,2).toLowerCase();
                if(typeof this.keySearch[indexKeySearchDuo] == "undefined") this.keySearch[indexKeySearchDuo] = new Array();
                this.keySearch[indexKeySearchDuo].push(this.elements.length);
            }
            */
        }
        this.elements.push({
            value: value,
            key: key,
            callback: callback || value
        });
    },
    
    getElement: function (key) {
        for (var i in this.elements) {
            if (this.elements[i].key == key)  {
                return this.elements[i];
            }
        }
    },
    
    getDomNode: function (sortedAfterTranslation) {
        
        function fakeI18n(callback) {
            this.callback = callback;
            this.node = newnode("div",0,0,[callback.cloneNode(true)]);
            this.update = function() {
                removeChildNodes(this.node);
                this.node.appendChild(this.callback.cloneNode(true));
            };
        }
        
        while (this.myboxComboDiv.childNodes.length > 0) {
            this.myboxComboDiv.removeChild(this.myboxComboDiv.firstChild);
        }

        this.currentValues = this.elements[this.selected];
        this.currentValue = this.currentValues.value;
        this.currentResult = this.currentValues.key;    
        while (this.headTableColumn1div.childNodes.length > 0) {
            this.headTableColumn1div.removeChild(this.headTableColumn1div.firstChild);
        }
        if (this.currentValues.value.nodeType) {
            this.currentI18nNode = new fakeI18n(this.currentValues.callback);
        } else {
            this.currentI18nNode = new I18nNode(this.currentValues.callback);
        }
        this.headTableColumn1div.appendChild(this.currentI18nNode.node);
        var Self = this;            
        Self.myboxComboDiv.className="smallpopupborder smallpopuplist background-color-content font-weight-default font-color-default border-color-design";
        Self.myboxComboDiv.style.display="none";
        Self.myboxComboDiv.style.textAlign="left";
        Self.myboxComboDiv.style.whiteSpace = "nowrap";
               
        for(var el1 in Self.elements) {
            (function (n) {
                var myValues = [];
                   myValues = Self.elements[n];
                   if (myValues.value.nodeType) {
                       myValues.i18nNode = new fakeI18n(myValues.callback);
                   } else {
                       myValues.i18nNode = new I18nNode(myValues.callback);
                   }
            })(el1);
        }
        
        if (sortedAfterTranslation) {
            this.sorti18nValue();    
               Self.keySearch = {};
               Self.indexForKeySearch = 0;
        }
        
        for(var el in Self.elements)
        {
            (function (n) {
                var childDiv = null;
                var myValues = [];
                childDiv = newnode("div",0,{className:"height16 background-color-content cursorDefault"});
                //childDiv.style.overflow="hidden";
                childDiv.style.padding="3px 0 0 4px";
                Self.window.addDOMEvent(childDiv,
                    "click", function() { 
                             changePopUpMenuText3(Self,n);
                             Self.rootDiv.blur(); 
                         }
                   );
                   
                Self.window.addDOMEvent(childDiv,
                    "mouseover", function() { changePopUpMenuStatus3(childDiv, true, Self); });
                    
                Self.window.addDOMEvent(childDiv,
                    "mouseout", function() { changePopUpMenuStatus3(childDiv, false, Self); });
                                 
                    myValues = Self.elements[n];
                    
                    if (sortedAfterTranslation) {
                        if(typeof myValues.i18nNode.node.nodeValue == "string" && myValues.value != "please select") {
                            if(myValues.i18nNode.node.nodeValue.length > 0) {
                                var indexKeySearchSingle = myValues.i18nNode.node.nodeValue.substr(0,1).toLowerCase();
                                if (typeof Self.keySearch[indexKeySearchSingle] == "undefined") {
                                    Self.keySearch[indexKeySearchSingle] = [];
                                }
                                Self.keySearch[indexKeySearchSingle].push(Self.indexForKeySearch);
                            }
                        }
                        Self.indexForKeySearch++;
                    }
                    
                    if (Self.viewValue) {
                        if (myValues.key != "") {
                            childDiv.className = "height16 font-color-default background-color-content";
                        } else {
                            childDiv.className = "height16 font-color-disabled background-color-content";
                        }
                   }
                   if (!myValues.i18nNode) {
                       if (myValues.value.nodeType) {
                           myValues.i18nNode = new fakeI18n(myValues.callback);
                       } else {                           
                           myValues.i18nNode = new I18nNode(myValues.callback);
                       }
                   }
                   childDiv.appendChild(myValues.i18nNode.node);
                
                if (!Self.rowHeight) {
                    var tmpnode=childDiv.cloneNode(true);
                    tmpnode.style.display="block";
                    tmpnode.style.zIndex=-1;
                    body.appendChild(tmpnode);
                    Self.rowHeight=tmpnode.offsetHeight;
                    body.removeChild(tmpnode);
                }
                    
                Self.myboxComboDiv.appendChild(childDiv);
            })(el);
        }
        if(this.scrollbar && this.scrollbar != "" && typeof this.scrollbar != "undefined"
            && this.scrollbar < this.elements.length) {
            var tempHeight = Math.floor(this.scrollbar*this.rowHeight);
            Self.myboxComboDiv.style.height=tempHeight+"px";
        }
        
        document.body.appendChild(Self.myboxComboDiv);
        
        if (this.maxscrollbar) {
            Self.myboxComboDiv.style.overflowX="hidden";
        } else {
            Self.myboxComboDiv.style.overflow="hidden";
        }
        
        // clean target node
        if (this.targetDiv !== null) {
            removeChildNodes(this.targetDiv);
            // pre-fill with default selected
            if (this.viewValue) {
                this.targetDiv.appendChild(newtext(this.getKey()));
            }
        }
        
        return Self.rootDiv;
    }
};

function ComboBoxSpecial(window, element, width, selected, style, eventname, maxscrollbar,eventParam) {
    var Self = this;
    this.window = window;
    this.selected = selected;
    this.elements = [];
    this.width=width;
    this.style = style;
    this.targetDiv = null;
    this.valueIsHTML = false; //the value is a node
    this.form = false;
    this.viewValue = false;
    this.disabled = false;
    this.optWidth;
    this.show_buttons = false;
    this.special = true;
    this.keySearch = {};
    
    this.rootDiv = element;
    this.rootDiv.innerHTML = "";
    this.headTable = newnode('table',0,{
                     cellPadding: 0, cellSpacing: 0, border: 0});
                     
    this.headTable.style.tableLayout="fixed";
    this.headTableBody = document.createElement("tbody");
    this.headTableRow = document.createElement("tr");
    this.headTableColumn1 = document.createElement("td");    
    this.headTableColumn1.setAttribute("nowrap","nowrap");
    this.headTableColumn1.style.whiteSpace = "nowrap";
    this.headTableColumn1div = newnode("div",{textAlign:"center"});    
    this.headTableColumn1.appendChild(this.headTableColumn1div);
    this.headTableColumn1div.style.overflow = "hidden";    
    this.myboxComboDiv = newnode("div");
    jQuery(this.myboxComboDiv).click(function(evt){
    	// handle click on combo layer
        showHideBox3(Self,evt);
        return false;
    });
    
    if (this.style) {
        this.headTable.className="smallpopupborder smallpopupnotactive background-color-content font-color-default";
        this.headTableColumn1.className="smallpopupborderright border-color-design comboboxColumn1";
    }
    this.rootDiv.style.width=this.width;
    this.rootDiv.className="dropdownbox";
    
    this.currentValues = [];
    
    this.currentResult = "";
    
    if(eventname) {
        this.onChange = function(key, key_before) {
            triggerEvent(eventname, key, eventParam);
        };
    }
    
    if(maxscrollbar) {
        this.scrollbar=maxscrollbar;
    } else { 
        this.scrollbar=null;
    }
        
    this.setFirstDiv();

//extends.. Combobox3
    this.scrollToSelected = ComboBox3.impl.prototype.scrollToSelected;    
    this.setKey = ComboBox3.impl.prototype.setKey;        
    this.addElement = ComboBox3.impl.prototype.addElement;    
    this.sort = ComboBox3.impl.prototype.sort;
    
    // overlay
    this.overlay = createComboBoxOverlay(this);
}
ComboBoxSpecial.prototype = {
    setDynamicKey: function (key,noevent) {
        this.elements = [];
        for(var nIndx=-3;nIndx< 3;nIndx++) {
            this.addElement(noI18n(nIndx+key), nIndx+key);
        }
        this.getDomNode();        

        var myElValues = [];
        var newIndex = key;
        var bFound = false;
        for(i=0; i<this.elements.length;i++) {
            myElValues = this.elements[i];
                    if (key == myElValues.key) {
                        key = myElValues.key;
                        newIndex = i;
                        bFound = true;
                        break;
                    }               
        }
        if(!bFound) {
            return false;
        }
        if(this.elements[newIndex]) {
            changePopUpMenuText3(
                    this,
                    newIndex,
                    noevent
            );
        }                    
        return true;        
    },        
    setFirstDiv:function () {
        var Self = this;
                                
        Self.clickOnCombobox = function (e) { 
                    if (!Self.disabled) {
                        showHideBox3(Self,e);
                    }
                    stopEvent(e);
        };
        Self.headTable.style.width=this.width;    
        setTimeout(function () {
            var tmpW = Self.headTable.offsetWidth - 16;
            Self.headTableRow.appendChild(Self.headTableColumn1);    
            Self.headTableBody.appendChild(Self.headTableRow);
            Self.headTable.appendChild(Self.headTableBody);
             
            Self.window.addDOMEvent(Self.headTable,
             "click", Self.clickOnCombobox);  
             
             Self.window.addDOMEvent(Self.headTable,
             "mouseover", function() { globalclickdisable2=true; }); 
             
             Self.window.addDOMEvent(Self.headTable,
             "mouseout", function() { globalclickdisable2=false; });  
        }, 0);        
        
        Self.rootDiv.appendChild(Self.headTable);        
    },    
    scrollElements : function (sDirection){
        if(sDirection == "up") {
            var nOldVal = this.elements[0].value-6;
            this.elements = [];
            for ( var nIndx = 0; nIndx < 6; nIndx++) {
                this.addElement(noI18n(nOldVal + nIndx), nOldVal + nIndx);
            }
            this.getList();                
        }
        else {
            var nOldVal = this.elements[this.elements.length-1].value;
            this.elements = [];
            for(var nIndx=1;nIndx<= 6;nIndx++) {
                this.addElement(noI18n(nOldVal+nIndx), nOldVal+nIndx);
            }
            this.getList();                            
        }            
    },
    
    getDomNode: function () {
        this.currentValues = this.elements[this.selected];
        this.currentValue = this.currentValues.value;
        this.currentResult = this.currentValues.key;    
        while (this.headTableColumn1div.childNodes.length>0) {
            this.headTableColumn1div.removeChild(this.headTableColumn1div.firstChild);
        }
        this.currentI18nNode = new I18nNode(this.currentValues.callback);
        this.headTableColumn1div.appendChild(this.currentI18nNode.node);

        var Self = this;        
        if (this.optWidth) {
            this.myboxComboDiv.style.width = this.optWidth;
        }
        
        Self.myboxComboDiv.className="smallpopupborder smallpopuplist background-color-content font-color-default";
        Self.myboxComboDiv.style.display="none";
        Self.myboxComboDiv.style.textAlign="left";            
        
        Self.getList();
        document.body.appendChild(Self.myboxComboDiv);
        Self.myboxComboDiv.style.overflowX="hidden";
                        
    },
    getList: function () {
        var Self = this;
        if (Self.show_buttons) {
            var nfactor = 17;
        } else {
            var nfactor = 19.5;
        }
        var tempHeight = Math.floor(Math.min(this.scrollbar || 0,
                                             this.elements.length)*nfactor);
        while (this.myboxComboDiv.childNodes.length > 0) {
            this.myboxComboDiv.removeChild(this.myboxComboDiv.firstChild);
        }
        if(Self.show_buttons) {
            Self.myboxComboDiv.style.overflow = "hidden";
            Self.myboxComboDiv.style.height=(tempHeight + 22)/pxPerEm + "em";        
            var oDomUp = newnode("div",0,{className:"height10 background-color-content"});
            oDomUp.style.paddingBottom ="2px";            
            oDomUp.style.overflow="hidden";
            oDomUp.style.textAlign = "center";    
            oDomUp.style.height = "10px";            
            oDomUp.style.lineHeight = "10px";            
            oDomUp.appendChild(newnode('img',{marginBottom:"2px"},{src : getFullImgSrc("img/arrows/sort_up.gif")}));
            //select on mouse over
            Self.window.addDOMEvent(oDomUp,
                "mouseover", function() { changePopUpMenuStatus3(oDomUp, true, Self); });                        
                
            Self.window.addDOMEvent(oDomUp,
                "mouseout", function() { changePopUpMenuStatus3(oDomUp, false, Self); });             
               
            Self.rowHeight = oDomUp.offsetHeight;
            Self.window.addDOMEvent(oDomUp,"click",function (e){Self.scrollElements("up");stopEvent(e);return false;});
            Self.myboxComboDiv.appendChild(oDomUp);
            
        } else {
            Self.myboxComboDiv.style.height=tempHeight + "px";
        }
        for (var el in Self.elements) {
            (function (n) {
                var childDiv = null;
                var myValues = [];
                childDiv = newnode("div", {overflow : "hidden"});
                childDiv.style.paddingLeft ="2px";        
                childDiv.style.paddingRight ="2px";        
                childDiv.style.width="96%";
                if (Self.show_buttons) {
                    childDiv.className="height14 background-color-content";
                } else {
                    childDiv.className="height16 background-color-content";
                }
                
                Self.rowHeight = childDiv.offsetHeight;
                Self.window.addDOMEvent(childDiv,
                    "click", function() { 
                             changePopUpMenuText3(Self,n);                                                    
                         }
                   );                        
                    
                Self.window.addDOMEvent(childDiv,
                    "mouseover", function() { changePopUpMenuStatus3(childDiv, true, Self); });                        
                    
                Self.window.addDOMEvent(childDiv,
                    "mouseout", function() { changePopUpMenuStatus3(childDiv, false, Self); });      
                                         
                   myValues = Self.elements[n];
                   if(Self.viewValue) {
                        if (myValues.key != "") {
                            childDiv.className = "height16 font-color-default background-color-content";
                        } else {
                            childDiv.className = "height16 font-color-disabled background-color-content";
                        }
                   }
                myValues.i18nNode = new I18nNode(myValues.callback);
                childDiv.appendChild(myValues.i18nNode.node);
                    
                Self.myboxComboDiv.appendChild(childDiv);
                 
            })(el);
        }
        if(Self.show_buttons) {                
            var oDomDown = newnode("div",{textAlign:"center"}, {className : "background-color-content"});
            oDomDown.style.paddingBottom ="2px";        
            oDomDown.style.height = "10px";                                                                    
            oDomDown.style.lineHeight = "10px";                        
            oDomDown.appendChild(newnode('img',{marginBottom:"2px",marginTop:"2px"},{src : getFullImgSrc("img/arrows/arrow-down.gif")}));            
            //select on mouse over
            Self.window.addDOMEvent(oDomDown,
                "mouseover", function() { changePopUpMenuStatus3(oDomDown, true, Self); });                        
                
            Self.window.addDOMEvent(oDomDown,
                "mouseout", function() { changePopUpMenuStatus3(oDomDown, false, Self); });             
                   
            Self.window.addDOMEvent(oDomDown,"click",function (e){Self.scrollElements("down");stopEvent(e);return false;});        
            Self.myboxComboDiv.appendChild(oDomDown);
        }        
    }
    
};

function showHideBox3(Self, e) {
    
    if (activeComboBox) {
        
        // hide
        Self.overlay.hide();
        Self.myboxComboDiv.style.display="none";
        jQuery(activeComboBox.myboxComboDiv).hide();
        if (Self.onHide) {
            Self.onHide();
        }
        activeComboBox = null;
        
    } else {
        
        // show
        Self.overlay.show();
        
        if (jQuery(Self.rootDiv).outerWidth() > jQuery(Self.myboxComboDiv).innerWidth()) {
            jQuery(Self.myboxComboDiv).width(jQuery(Self.rootDiv).outerWidth());
        } else if (!Self.resizedWidth){
            jQuery(Self.myboxComboDiv).width(jQuery(Self.myboxComboDiv).innerWidth() + 25);
        }
        Self.resizedWidth = true;
        
        if (!document.all) {
            Self.myboxComboDiv.style.marginLeft = -1 + "px";
        }
        
        // open properly
        // box
        var box = jQuery(Self.rootDiv),
            // drop-down
            drop  = jQuery(Self.myboxComboDiv),
            // box height
            bh = box.outerHeight(),
            // box position
            pos = box.offset(),
            // height of drop-down
            h = drop.outerHeight(),
            // drop's offset parent
            p = jQuery("body"),
            // offset parent's height
            ph = p.height();
        
        // adjust position
        drop.css({
            zIndex: 40001,
            margin: "0px",
            left: (pos.left) + "px"
        });
        
        // enough space to appear below?
        if (ph > (pos.top + bh + h)) {
            drop.css("top", (pos.top + bh) + "px");
        } else {
            drop.css("top", Math.max(0, pos.top - h) + "px");
        }
        
        drop.show();
        
        // attach current active object to global object
        activeComboBox = Self;
        Self.scrollToSelected();
        
        if (Self.onShow) {
            Self.onShow();
        }
    }
}

function changePopUpMenuStatus3(element,activated, Self) {
    //if(!IE6) return;
    if(activated) {
        element.className = element.className.replace(/background-color-content/,"background-color-PMG-selection-elements");
    } else { 
        element.className = element.className.replace(/background-color-PMG-selection-elements/,"background-color-content");
    }
}

var globalclickdisable=false;

function changePopUpMenuStatus(elementid,activated) {
    var d=document.getElementById(elementid);
    if (activated) {
        d.className="background-color-PMG-selection-elements border-color-PMG-selection-elements font-color-default";
    } else {
        d.className="smallpopupnotactive background-color-content font-color-default";
    }
}
fileloaded();