/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.util.List;
import java.util.Properties;
import javax.xml.transform.Result;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.Controller;
import net.sf.saxon.event.CDATAFilter;
import net.sf.saxon.event.CharacterMapExpander;
import net.sf.saxon.event.ContentHandlerProxy;
import net.sf.saxon.event.Emitter;
import net.sf.saxon.event.HTMLEmitter;
import net.sf.saxon.event.HTMLIndenter;
import net.sf.saxon.event.HTMLURIEscaper;
import net.sf.saxon.event.MetaTagAdjuster;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.TEXTEmitter;
import net.sf.saxon.event.UncommittedSerializer;
import net.sf.saxon.event.UnicodeNormalizer;
import net.sf.saxon.event.XHTMLEmitter;
import net.sf.saxon.event.XHTMLIndenter;
import net.sf.saxon.event.XML10ContentChecker;
import net.sf.saxon.event.XMLEmitter;
import net.sf.saxon.event.XMLIndenter;
import net.sf.saxon.om.ExternalObjectModel;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;

public class SerializerFactory {
    private SerializerFactory() {
    }

    public static Receiver getReceiver(Result result, PipelineConfiguration pipelineConfiguration, Properties properties) throws XPathException {
        if (result instanceof Emitter) {
            ((Emitter)result).setOutputProperties(properties);
            return (Emitter)result;
        }
        if (result instanceof Receiver) {
            Receiver receiver = (Receiver)result;
            receiver.setSystemId(result.getSystemId());
            receiver.setPipelineConfiguration(pipelineConfiguration);
            return receiver;
        }
        if (result instanceof SAXResult) {
            ContentHandlerProxy contentHandlerProxy = new ContentHandlerProxy();
            contentHandlerProxy.setUnderlyingContentHandler(((SAXResult)result).getHandler());
            contentHandlerProxy.setPipelineConfiguration(pipelineConfiguration);
            contentHandlerProxy.setOutputProperties(properties);
            return contentHandlerProxy;
        }
        if (result instanceof StreamResult) {
            Result result2;
            Result result3;
            Emitter emitter;
            String string;
            Object object;
            CharacterMapExpander characterMapExpander = null;
            String string2 = properties.getProperty("use-character-maps");
            if (string2 != null) {
                Object object2 = object = pipelineConfiguration == null ? null : pipelineConfiguration.getController();
                if (object == null) {
                    throw new DynamicError("Cannot use character maps in an environment with no Controller");
                }
                characterMapExpander = ((Controller)object).makeCharacterMapExpander(string2);
                characterMapExpander.setPipelineConfiguration(pipelineConfiguration);
            }
            object = null;
            String string3 = properties.getProperty("normalization-form");
            if (string3 != null && !string3.equals("none")) {
                object = new UnicodeNormalizer(string3);
            }
            if ((string = properties.getProperty("method")) == null) {
                UncommittedSerializer uncommittedSerializer = new UncommittedSerializer(result, properties);
                uncommittedSerializer.setPipelineConfiguration(pipelineConfiguration);
                return uncommittedSerializer;
            }
            if ("html".equals(string)) {
                emitter = new HTMLEmitter();
                emitter.setPipelineConfiguration(pipelineConfiguration);
                result3 = SerializerFactory.createHTMLSerializer(emitter, properties, pipelineConfiguration, characterMapExpander, (UnicodeNormalizer)object);
            } else if ("xml".equals(string)) {
                emitter = new XMLEmitter();
                emitter.setPipelineConfiguration(pipelineConfiguration);
                result3 = SerializerFactory.createXMLSerializer(emitter, properties, pipelineConfiguration, (UnicodeNormalizer)object, characterMapExpander);
            } else if ("xhtml".equals(string)) {
                emitter = new XHTMLEmitter();
                emitter.setPipelineConfiguration(pipelineConfiguration);
                result3 = SerializerFactory.createXHTMLSerializer(emitter, properties, pipelineConfiguration, (UnicodeNormalizer)object, characterMapExpander);
            } else if ("text".equals(string)) {
                emitter = new TEXTEmitter();
                emitter.setPipelineConfiguration(pipelineConfiguration);
                result3 = SerializerFactory.createTextSerializer(emitter, characterMapExpander, (UnicodeNormalizer)object);
            } else {
                if (pipelineConfiguration == null) {
                    throw new DynamicError("Unsupported serialization method " + string);
                }
                result2 = pipelineConfiguration.getConfiguration().getOutputMethod(string);
                if (result2 == null) {
                    int n = string.indexOf(125);
                    String string4 = string.substring(n + 1);
                    int n2 = string4.indexOf(58);
                    string4 = string4.substring(n2 + 1);
                    result2 = Emitter.makeEmitter(string4, pipelineConfiguration.getController());
                }
                result2.setPipelineConfiguration(pipelineConfiguration);
                result3 = result2;
                if (result2 instanceof Emitter) {
                    emitter = (Emitter)result2;
                } else {
                    return result2;
                }
            }
            emitter.setOutputProperties(properties);
            result2 = (StreamResult)result;
            emitter.setStreamResult((StreamResult)result2);
            return result3;
        }
        if (pipelineConfiguration != null) {
            List list = pipelineConfiguration.getConfiguration().getExternalObjectModels();
            for (int i = 0; i < list.size(); ++i) {
                ExternalObjectModel externalObjectModel = (ExternalObjectModel)list.get(i);
                Receiver receiver = externalObjectModel.getDocumentBuilder(result);
                if (receiver == null) continue;
                receiver.setSystemId(result.getSystemId());
                receiver.setPipelineConfiguration(pipelineConfiguration);
                return receiver;
            }
        }
        throw new IllegalArgumentException("Unknown type of result: " + result.getClass());
    }

    private static Receiver createHTMLSerializer(Emitter emitter, Properties properties, PipelineConfiguration pipelineConfiguration, CharacterMapExpander characterMapExpander, UnicodeNormalizer unicodeNormalizer) throws XPathException {
        ProxyReceiver proxyReceiver;
        Receiver receiver = emitter;
        if (!"no".equals(properties.getProperty("indent"))) {
            proxyReceiver = new HTMLIndenter();
            proxyReceiver.setUnderlyingReceiver(receiver);
            proxyReceiver.setPipelineConfiguration(pipelineConfiguration);
            ((HTMLIndenter)proxyReceiver).setOutputProperties(properties);
            receiver = proxyReceiver;
        }
        if (!"no".equals(properties.getProperty("include-content-type"))) {
            proxyReceiver = new MetaTagAdjuster();
            proxyReceiver.setUnderlyingReceiver(receiver);
            proxyReceiver.setPipelineConfiguration(pipelineConfiguration);
            ((MetaTagAdjuster)proxyReceiver).setIsXHTML(false);
            ((MetaTagAdjuster)proxyReceiver).setOutputProperties(properties);
            receiver = proxyReceiver;
        }
        if (unicodeNormalizer != null) {
            unicodeNormalizer.setUnderlyingReceiver(receiver);
            receiver = unicodeNormalizer;
            receiver.setPipelineConfiguration(pipelineConfiguration);
        }
        if (characterMapExpander != null) {
            characterMapExpander.setUnderlyingReceiver(receiver);
            receiver = characterMapExpander;
            receiver.setPipelineConfiguration(pipelineConfiguration);
        }
        if (!"no".equals(properties.getProperty("escape-uri-attibutes"))) {
            proxyReceiver = new HTMLURIEscaper();
            proxyReceiver.setUnderlyingReceiver(receiver);
            receiver = proxyReceiver;
            receiver.setPipelineConfiguration(pipelineConfiguration);
        }
        return receiver;
    }

    private static Receiver createTextSerializer(Emitter emitter, CharacterMapExpander characterMapExpander, UnicodeNormalizer unicodeNormalizer) {
        Receiver receiver = emitter;
        if (characterMapExpander != null) {
            characterMapExpander.setUnderlyingReceiver(receiver);
            characterMapExpander.setUseNullMarkers(false);
            receiver = characterMapExpander;
        }
        if (unicodeNormalizer != null) {
            unicodeNormalizer.setUnderlyingReceiver(receiver);
            receiver = unicodeNormalizer;
        }
        return receiver;
    }

    private static Receiver createXHTMLSerializer(Emitter emitter, Properties properties, PipelineConfiguration pipelineConfiguration, UnicodeNormalizer unicodeNormalizer, CharacterMapExpander characterMapExpander) throws XPathException {
        ProxyReceiver proxyReceiver;
        Object object;
        Object object2 = emitter;
        if (!"no".equals(properties.getProperty("indent"))) {
            object = new XHTMLIndenter();
            ((ProxyReceiver)object).setUnderlyingReceiver((Receiver)object2);
            ((ProxyReceiver)object).setPipelineConfiguration(pipelineConfiguration);
            ((HTMLIndenter)object).setOutputProperties(properties);
            object2 = object;
        }
        if (!"no".equals(properties.getProperty("include-content-type"))) {
            object = new MetaTagAdjuster();
            ((ProxyReceiver)object).setUnderlyingReceiver((Receiver)object2);
            ((ProxyReceiver)object).setPipelineConfiguration(pipelineConfiguration);
            ((MetaTagAdjuster)object).setIsXHTML(true);
            ((MetaTagAdjuster)object).setOutputProperties(properties);
            object2 = object;
        }
        if ((object = properties.getProperty("cdata-section-elements")) != null && ((String)object).length() > 0) {
            proxyReceiver = new CDATAFilter();
            proxyReceiver.setUnderlyingReceiver((Receiver)object2);
            proxyReceiver.setPipelineConfiguration(pipelineConfiguration);
            ((CDATAFilter)proxyReceiver).setOutputProperties(properties);
            object2 = proxyReceiver;
        }
        if (unicodeNormalizer != null) {
            unicodeNormalizer.setUnderlyingReceiver((Receiver)object2);
            unicodeNormalizer.setPipelineConfiguration(pipelineConfiguration);
            object2 = unicodeNormalizer;
        }
        if (characterMapExpander != null) {
            characterMapExpander.setUnderlyingReceiver((Receiver)object2);
            characterMapExpander.setPipelineConfiguration(pipelineConfiguration);
            object2 = characterMapExpander;
        }
        if (!"no".equals(properties.getProperty("escape-uri-attibutes"))) {
            proxyReceiver = new HTMLURIEscaper();
            proxyReceiver.setUnderlyingReceiver((Receiver)object2);
            proxyReceiver.setPipelineConfiguration(pipelineConfiguration);
            object2 = proxyReceiver;
        }
        return object2;
    }

    private static Receiver createXMLSerializer(Emitter emitter, Properties properties, PipelineConfiguration pipelineConfiguration, UnicodeNormalizer unicodeNormalizer, CharacterMapExpander characterMapExpander) throws XPathException {
        Object object;
        Object object2 = emitter;
        if ("1.0".equals(properties.getProperty("version")) && pipelineConfiguration.getConfiguration().getXMLVersion() == 11) {
            object = new XML10ContentChecker();
            ((ProxyReceiver)object).setUnderlyingReceiver((Receiver)object2);
            ((XML10ContentChecker)object).setPipelineConfiguration(pipelineConfiguration);
            object2 = object;
        }
        if ("yes".equals(properties.getProperty("indent"))) {
            object = new XMLIndenter();
            ((ProxyReceiver)object).setUnderlyingReceiver((Receiver)object2);
            ((ProxyReceiver)object).setPipelineConfiguration(pipelineConfiguration);
            ((XMLIndenter)object).setOutputProperties(properties);
            object2 = object;
        }
        if ((object = properties.getProperty("cdata-section-elements")) != null && ((String)object).length() > 0) {
            CDATAFilter cDATAFilter = new CDATAFilter();
            cDATAFilter.setUnderlyingReceiver((Receiver)object2);
            cDATAFilter.setPipelineConfiguration(pipelineConfiguration);
            cDATAFilter.setOutputProperties(properties);
            object2 = cDATAFilter;
        }
        if (unicodeNormalizer != null) {
            unicodeNormalizer.setUnderlyingReceiver((Receiver)object2);
            object2 = unicodeNormalizer;
        }
        if (characterMapExpander != null) {
            characterMapExpander.setUnderlyingReceiver((Receiver)object2);
            object2 = characterMapExpander;
        }
        return object2;
    }
}

