/**
 * 
 */
package com.openexchange.obs.api;

import static com.openexchange.obs.api.Architecture.i586;
import static com.openexchange.obs.api.Architecture.x86_64;
import static java.util.Arrays.sort;
import static org.junit.Assert.assertArrayEquals;

import org.junit.Test;

/**
 * @author marcus
 *
 */
public class ArchitectureTest {

	/**
	 * Test method for {@link com.openexchange.obs.api.Architecture#parseArchitecture(java.lang.String)}.
	 * @throws BuildServiceException 
	 */
	@Test
	public final void testParseArchitecture() throws BuildServiceException {
		Architecture[] toTest = Architecture.parseArchitecture("i586");
		assertArrayEquals(new Architecture[] { i586 }, toTest);
		toTest = Architecture.parseArchitecture("x86_64");
		assertArrayEquals(new Architecture[] { x86_64 }, toTest);
		toTest = Architecture.parseArchitecture("i586,x86_64");
		sort(toTest);
		assertArrayEquals(new Architecture[] { i586, x86_64 }, toTest);
	}
}
