/**
 * OPEN-XCHANGE legal information
 *
 * All intellectual property rights in the Software are protected by
 * international copyright laws.
 *
 *
 * In some countries OX, OX Open-Xchange, open xchange and OXtender
 * as well as the corresponding Logos OX Open-Xchange and OX are registered
 * trademarks of the Open-Xchange, Inc. group of companies.
 * The use of the Logos is not covered by the GNU General Public License.
 * Instead, you are allowed to use these Logos according to the terms and
 * conditions of the Creative Commons License, Version 2.5, Attribution,
 * Non-commercial, ShareAlike, and the interpretation of the term
 * Non-commercial applicable to the aforementioned license is published
 * on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 * Please make sure that third-party modules and libraries are used
 * according to their respective licenses.
 *
 * Any modifications to this package must retain all copyright notices
 * of the original copyright holder(s) for the original code used.
 *
 * After any such modifications, the original and derivative code shall remain
 * under the copyright of the copyright holder(s) and/or original author(s)per
 * the Attribution and Assignment Agreement that can be located at
 * http://www.open-xchange.com/EN/developer/. The contributing author shall be
 * given Attribution for the derivative code and a license granting use.
 *
 *  Copyright (C) 2004-2014 Open-Xchange, Inc.
 *  Mail: info@open-xchange.com
 *
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License, Version 2 as published
 *  by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *  or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc., 59
 *  Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
package com.openxchange.office_communication.tools.exec.impl;

import java.util.HashSet;
import java.util.Set;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.jezhumble.javasysmon.JavaSysMon;
import com.jezhumble.javasysmon.OsProcess;
import com.jezhumble.javasysmon.ProcessInfo;
import com.jezhumble.javasysmon.ProcessVisitor;

//==============================================================================
/** visit the child process tree of a given process and return a list of all PIDs
 */
public class ProcessChildVisitor implements ProcessVisitor
{
	//--------------------------------------------------------------------------
	private static final Logger LOG = LoggerFactory.getLogger(ProcessChildVisitor.class);
	
	//--------------------------------------------------------------------------
	/// see using of it and you will (hopefully) understand ;-)
	private static final boolean DO_NOT_KILL_PROCESS = false;
	
	//--------------------------------------------------------------------------
    public ProcessChildVisitor ()
    	throws Exception
    {}
    
	//--------------------------------------------------------------------------
    /** set the pid of the root process where  we start search for child processes.
     * 
     *  @param	nPid [IN]
     *  		the pid of the root process.
     */
    public void setRootPid (final int nPid)
    	throws Exception
    {
    	m_nRootPid = nPid;
	}

    //--------------------------------------------------------------------------
    /** ATTENTION : NEVER EVER RETURN TRUE WITHIN THAT METHOD !
     *  Read the documentation of {@link ProcessVisitor.visit} carefully.
     *  Return TRUE means : kill the process you are visiting ...
     *  Do you want that here real ?
     */
    @Override
    public boolean visit(final OsProcess aProcess   ,
    					 final int       nChildLevel)
    {
    	try
    	{
	    	final ProcessInfo aInfo = aProcess.processInfo ();
	    	final int         nPid  = aInfo   .getPid      ();
	
	    	impl_traceProcessInfo (aInfo);
	    	
	    	// ignore root of process tree (we are interested on childs only)
	    	if (nPid != m_nRootPid)
	    		mem_Pids ().add(nPid);
    	}
    	catch (Throwable ex)
    	{
    		// this is by intention !
    	}

    	return DO_NOT_KILL_PROCESS;
    }

    //--------------------------------------------------------------------------
    /** @return the list of child pids we found so far.
     *  Will be never null ... but can be empty.
     */
    public Set< Integer > getPids ()
    	throws Exception
    {
        return mem_Pids ();
    }

    //--------------------------------------------------------------------------
    private void impl_traceProcessInfo (final ProcessInfo aInfo)
    	throws Exception
    {
    	if ( ! LOG.isTraceEnabled())
    		return;
    	
    	final StringBuffer sDump = new StringBuffer (256);

    	sDump.append ("##### DUMP : ------------------------------------------------------\n");
    	sDump.append ("##### DUMP : this   pid  : "+new JavaSysMon ().currentPid()+"\n");
    	sDump.append ("##### DUMP : root   pid  : "+m_nRootPid+"\n");
    	sDump.append ("##### DUMP : proc   name : "+aInfo.getName      ()+"\n");
    	sDump.append ("##### DUMP : proc   cmd  : "+aInfo.getCommand   ()+"\n");
    	sDump.append ("##### DUMP : proc   pid  : "+aInfo.getPid       ()+"\n");
    	sDump.append ("##### DUMP : parent pid  : "+aInfo.getParentPid ()+"\n");
    	
    	LOG.trace(sDump.toString ());
    }
    
    //--------------------------------------------------------------------------
    private Set< Integer > mem_Pids ()
    	throws Exception
    {
    	if (m_lPids == null)
    		m_lPids = new HashSet< Integer >();
    	return m_lPids;
    }

    //--------------------------------------------------------------------------
    /// pid of the root process where we start our search for child processes
    private int m_nRootPid = GlobalPidProcessHandler.INVALID_PID;
    
    //--------------------------------------------------------------------------
    /// the set of child pids we found
    private Set< Integer > m_lPids = new HashSet< Integer >();
}