/**
 * OPEN-XCHANGE legal information
 *
 * All intellectual property rights in the Software are protected by
 * international copyright laws.
 *
 *
 * In some countries OX, OX Open-Xchange, open xchange and OXtender
 * as well as the corresponding Logos OX Open-Xchange and OX are registered
 * trademarks of the Open-Xchange, Inc. group of companies.
 * The use of the Logos is not covered by the GNU General Public License.
 * Instead, you are allowed to use these Logos according to the terms and
 * conditions of the Creative Commons License, Version 2.5, Attribution,
 * Non-commercial, ShareAlike, and the interpretation of the term
 * Non-commercial applicable to the aforementioned license is published
 * on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 * Please make sure that third-party modules and libraries are used
 * according to their respective licenses.
 *
 * Any modifications to this package must retain all copyright notices
 * of the original copyright holder(s) for the original code used.
 *
 * After any such modifications, the original and derivative code shall remain
 * under the copyright of the copyright holder(s) and/or original author(s)per
 * the Attribution and Assignment Agreement that can be located at
 * http://www.open-xchange.com/EN/developer/. The contributing author shall be
 * given Attribution for the derivative code and a license granting use.
 *
 *  Copyright (C) 2004-2014 Open-Xchange, Inc.
 *  Mail: info@open-xchange.com
 *
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License, Version 2 as published
 *  by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *  or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc., 59
 *  Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
package com.openxchange.office_communication.office.jms.messages;

import com.openxchange.office_communication.jms.core.plain.beans.JMSHeader;
import com.openxchange.office_communication.jms.core.plain.beans.JMSMessageBean;
import com.openxchange.office_communication.jms.core.plain.beans.JMSProperty;

//=============================================================================
public class CalcEngineMessageBean extends JMSMessageBean
{
	//-------------------------------------------------------------------------
	public static final String HEADER_NAMESPACE = JMSMessageBean.HEADER_NAMESPACE+JMSHeader.SEPARATOR+"calcengine";
	
	//-------------------------------------------------------------------------
	public static final String PROP_DOCHANDLE = CalcEngineMessageBean.HEADER_NAMESPACE+JMSProperty.SEPARATOR+"doc"+JMSProperty.SEPARATOR+"handle";
	public static final String PROP_METHOD    = CalcEngineMessageBean.HEADER_NAMESPACE+JMSProperty.SEPARATOR+"method"                            ;

    //-------------------------------------------------------------------------
	public CalcEngineMessageBean ()
		throws Exception
	{
		setType (CalcEngineMessageBean.class);
	}
	
	//-------------------------------------------------------------------------
	public void setDocHandle (final String sHandle)
	    throws Exception
	{
		m_sDocHandle = sHandle;
	}
	
	//-------------------------------------------------------------------------
	public String getDocHandle ()
	    throws Exception
	{
		return m_sDocHandle;
	}

	//-------------------------------------------------------------------------
	public void setMethod (final ECalcEngineMethod eMethod)
	    throws Exception
	{
		m_eMethod = eMethod;
	}

	//-------------------------------------------------------------------------
	public ECalcEngineMethod getMethod ()
	    throws Exception
	{
		return m_eMethod;
	}

	//-------------------------------------------------------------------------
	@JMSProperty(name=CalcEngineMessageBean.PROP_DOCHANDLE)
	private String m_sDocHandle = null;

	//-------------------------------------------------------------------------
	@JMSProperty(name=CalcEngineMessageBean.PROP_METHOD)
	private ECalcEngineMethod m_eMethod = null;
}
