/**
 * OPEN-XCHANGE legal information
 *
 * All intellectual property rights in the Software are protected by
 * international copyright laws.
 *
 *
 * In some countries OX, OX Open-Xchange, open xchange and OXtender
 * as well as the corresponding Logos OX Open-Xchange and OX are registered
 * trademarks of the Open-Xchange, Inc. group of companies.
 * The use of the Logos is not covered by the GNU General Public License.
 * Instead, you are allowed to use these Logos according to the terms and
 * conditions of the Creative Commons License, Version 2.5, Attribution,
 * Non-commercial, ShareAlike, and the interpretation of the term
 * Non-commercial applicable to the aforementioned license is published
 * on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 * Please make sure that third-party modules and libraries are used
 * according to their respective licenses.
 *
 * Any modifications to this package must retain all copyright notices
 * of the original copyright holder(s) for the original code used.
 *
 * After any such modifications, the original and derivative code shall remain
 * under the copyright of the copyright holder(s) and/or original author(s)per
 * the Attribution and Assignment Agreement that can be located at
 * http://www.open-xchange.com/EN/developer/. The contributing author shall be
 * given Attribution for the derivative code and a license granting use.
 *
 *  Copyright (C) 2004-2014 Open-Xchange, Inc.
 *  Mail: info@open-xchange.com
 *
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License, Version 2 as published
 *  by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *  or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc., 59
 *  Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
package com.openxchange.office_communication.jms.core.plain.impl;

import java.net.URI;
import java.util.Properties;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Session;
import javax.naming.Context;
import javax.naming.InitialContext;

import com.openxchange.office_communication.jms.core.plain.JMSEnv;

public class AMQContext
{
	//-------------------------------------------------------------------------
	public static final String JNDI_CONTEXT_FACTORY = "org.apache.activemq.jndi.ActiveMQInitialContextFactory";

	//-------------------------------------------------------------------------
	public static final String JNDI_CONNECTION_FACTORY = "ConnectionFactory";

	//-------------------------------------------------------------------------
	private AMQContext ()
	{}
	
	//-------------------------------------------------------------------------
	public static synchronized AMQContext get ()
		throws Exception
	{
		return new AMQContext ();
	}
	
	//-------------------------------------------------------------------------
	public synchronized Session newSession ()
		throws Exception
	{
		final Connection aConnection = impl_openConnection ();
    	final Session    aSession    = aConnection.createSession(false, Session.AUTO_ACKNOWLEDGE);
    	return aSession;
	}

	//-------------------------------------------------------------------------
	private Connection impl_openConnection ()
	    throws Exception
	{
		if (m_aConnection != null)
			return m_aConnection;

		// Lookup a connection factory in the context
		final Context           aContext           = mem_Context ();
    	final ConnectionFactory aConnectionFactory = (ConnectionFactory)aContext.lookup(JNDI_CONNECTION_FACTORY);

    	// Obtain a JMS connection from the factory
    	final Connection aConnection = aConnectionFactory.createConnection();
    	aConnection.start();
		m_aConnection = aConnection;

		return m_aConnection;
	}
	
	//-------------------------------------------------------------------------
	private void impl_closeConnection ()
	    throws Exception
	{
		if (m_aConnection == null)
			return;

		throw new UnsupportedOperationException ("not implemented yet.");
	}

	//-------------------------------------------------------------------------
	// Create and initialize a JNDI context
	private Context mem_Context ()
	    throws Exception
	{
		if (m_aContext != null)
			return m_aContext;

		final JMSEnv     aEnv            = JMSEnv.get ();
		final String     sContextFactory = aEnv.getContextFactoryName ();
		final String     sProviderURL    = aEnv.getServerURI ().toASCIIString();
    	final Properties aCfg            = new Properties ();

    	aCfg.setProperty(Context.INITIAL_CONTEXT_FACTORY, sContextFactory);
    	aCfg.setProperty(Context.PROVIDER_URL           , sProviderURL   );

    	m_aContext = new InitialContext(aCfg);
		return m_aContext;
	}
	
	//-------------------------------------------------------------------------
	private Context m_aContext = null;

	//-------------------------------------------------------------------------
	private Connection m_aConnection = null;
}
