/**
 * OPEN-XCHANGE legal information
 *
 * All intellectual property rights in the Software are protected by
 * international copyright laws.
 *
 *
 * In some countries OX, OX Open-Xchange, open xchange and OXtender
 * as well as the corresponding Logos OX Open-Xchange and OX are registered
 * trademarks of the Open-Xchange, Inc. group of companies.
 * The use of the Logos is not covered by the GNU General Public License.
 * Instead, you are allowed to use these Logos according to the terms and
 * conditions of the Creative Commons License, Version 2.5, Attribution,
 * Non-commercial, ShareAlike, and the interpretation of the term
 * Non-commercial applicable to the aforementioned license is published
 * on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 * Please make sure that third-party modules and libraries are used
 * according to their respective licenses.
 *
 * Any modifications to this package must retain all copyright notices
 * of the original copyright holder(s) for the original code used.
 *
 * After any such modifications, the original and derivative code shall remain
 * under the copyright of the copyright holder(s) and/or original author(s)per
 * the Attribution and Assignment Agreement that can be located at
 * http://www.open-xchange.com/EN/developer/. The contributing author shall be
 * given Attribution for the derivative code and a license granting use.
 *
 *  Copyright (C) 2004-2014 Open-Xchange, Inc.
 *  Mail: info@open-xchange.com
 *
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License, Version 2 as published
 *  by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *  or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc., 59
 *  Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
package com.openxchange.office_communication.jms.core.plain.beans;

import org.apache.commons.lang3.Validate;

//=============================================================================
public class JMSMessageUtils
{
	//-------------------------------------------------------------------------
	private JMSMessageUtils ()
	{}

	//-------------------------------------------------------------------------
	@SuppressWarnings("unchecked")
	public static < T extends JMSMessageBean > T emptyBeanFitsToMessage (final javax.jms.Message aMessage)
		throws Exception
	{
		final String sType = aMessage.getStringProperty(JMSMessageBean.HEADER_MSGTYPE);
		Validate.notEmpty(sType, "No 'type' header defined in message. Cant create suitable message ...");
		return (T) JMSMessageUtils.newBeanForType (sType);
	}

	//-------------------------------------------------------------------------
	@SuppressWarnings("unchecked")
	public static < T extends JMSMessageBean > T emptyBeanFitsToMessage (final org.apache.camel.Message aMessage)
		throws Exception
	{
		final String sType = (String)aMessage.getHeader(JMSMessageBean.HEADER_MSGTYPE);
		Validate.notEmpty(sType, "No 'type' header defined in message. Cant create suitable message ...");
		return (T) JMSMessageUtils.newBeanForType (sType);
	}

	//-------------------------------------------------------------------------
	@SuppressWarnings("unchecked")
	public static < T extends JMSMessageBean > T newBeanForType (final String sType)
		throws Exception
	{
		final Class< T > aType = (Class< T >) Class.forName(sType);
		final Object     aBean = aType.newInstance();
		return (T) aBean;
	}

	//-------------------------------------------------------------------------
	@SuppressWarnings("unchecked")
	public static < T extends JMSMessageBean > T constructResponse4Request (final T aRequest)
		throws Exception
	{
		final String sType     = aRequest.getType();
		final T      aResponse = (T) newBeanForType (sType);
		
		aResponse.setJMSCorrelationID(aRequest.getJMSID());
		return aResponse;
	}

	//-------------------------------------------------------------------------
	@SuppressWarnings("unchecked")
	public static <T extends JMSMessageBean> T mapMessageToBean (final javax.jms.Message aMessage)
	    throws Exception
	{
		final JMSMessageBean aBean = emptyBeanFitsToMessage(aMessage);
		mapMessageToBean (aMessage, aBean);
		return (T) aBean;
	}

	//-------------------------------------------------------------------------
	@SuppressWarnings("unchecked")
	public static <T extends JMSMessageBean> T mapMessageToBean (final org.apache.camel.Message aMessage)
	    throws Exception
	{
		final JMSMessageBean aBean = emptyBeanFitsToMessage(aMessage);
		mapMessageToBean (aMessage, aBean);
		return (T) aBean;
	}

	//-------------------------------------------------------------------------
	public static <T extends JMSMessageBean> void mapMessageToBean (final javax.jms.Message aMessage,
																	final T                 aBean   )
	    throws Exception
	{
		final JMSBeanMapper aMapper = JMSBeanMapper.get();
		aMapper.mapMessageToBean(aMessage, aBean);
	}

	//-------------------------------------------------------------------------
	public static <T extends JMSMessageBean> void mapMessageToBean (final org.apache.camel.Message aMessage,
																	final T                        aBean   )
	    throws Exception
	{
		final JMSBeanMapper aMapper = JMSBeanMapper.get();
		aMapper.mapMessageToBean(aMessage, aBean);
	}

	//-------------------------------------------------------------------------
	public static <T extends JMSMessageBean> void mapBeanToMessage (final T                 aBean   ,
																    final javax.jms.Message aMessage)
	    throws Exception
	{
		final JMSBeanMapper aMapper = JMSBeanMapper.get();
		aMapper.mapBeanToMessage(aBean, aMessage);
	}

	//-------------------------------------------------------------------------
	public static <T extends JMSMessageBean> void mapBeanToMessage (final T                        aBean   ,
																    final org.apache.camel.Message aMessage)
	    throws Exception
	{
		final JMSBeanMapper aMapper = JMSBeanMapper.get();
		aMapper.mapBeanToMessage(aBean, aMessage);
	}
}
