/**
 * OPEN-XCHANGE legal information
 *
 * All intellectual property rights in the Software are protected by
 * international copyright laws.
 *
 *
 * In some countries OX, OX Open-Xchange, open xchange and OXtender
 * as well as the corresponding Logos OX Open-Xchange and OX are registered
 * trademarks of the Open-Xchange, Inc. group of companies.
 * The use of the Logos is not covered by the GNU General Public License.
 * Instead, you are allowed to use these Logos according to the terms and
 * conditions of the Creative Commons License, Version 2.5, Attribution,
 * Non-commercial, ShareAlike, and the interpretation of the term
 * Non-commercial applicable to the aforementioned license is published
 * on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 * Please make sure that third-party modules and libraries are used
 * according to their respective licenses.
 *
 * Any modifications to this package must retain all copyright notices
 * of the original copyright holder(s) for the original code used.
 *
 * After any such modifications, the original and derivative code shall remain
 * under the copyright of the copyright holder(s) and/or original author(s)per
 * the Attribution and Assignment Agreement that can be located at
 * http://www.open-xchange.com/EN/developer/. The contributing author shall be
 * given Attribution for the derivative code and a license granting use.
 *
 *  Copyright (C) 2004-2014 Open-Xchange, Inc.
 *  Mail: info@open-xchange.com
 *
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License, Version 2 as published
 *  by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *  or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc., 59
 *  Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
package com.openxchange.office_communication.configuration.configitems;

import com.openxchange.office_communication.configuration.ConfigAccess;
import com.openxchange.office_communication.tools.config.IComplexConfiguration;

//=============================================================================
public class CalcEngineConfig
{
	//-------------------------------------------------------------------------
	public static final String CONFIG_PACKAGE = "/calcengine";

	//-------------------------------------------------------------------------
	public static final String CFGKEY_PREFIX = "calcengine";
	
	//-------------------------------------------------------------------------
	public static final String CFGKEY_QUEUE_CALCENGINE_IN      = CFGKEY_PREFIX+".queue.in" ;
	public static final String CFGKEY_QUEUE_CALCENGINE_OUT     = CFGKEY_PREFIX+".queue.out";
	public static final String CFGKEY_ENABLE_RESTORE_DOCUMENTS = CFGKEY_PREFIX+".enable.restore-documents";

	public static final String CFGKEY_RETRY_COUNT              = CFGKEY_PREFIX+".retry.count";
	public static final String CFGKEY_RETRY_WAIT               = CFGKEY_PREFIX+".retry.wait" ;

	public static final String CFGKEY_REQUEST_TIMEOUT          = CFGKEY_PREFIX+".request.timeout";
	
	//-------------------------------------------------------------------------
	public static final int DEFAULT_REUQEST_TIMEOUT_IN_MS = 55000;

	//-------------------------------------------------------------------------
	public static final int DEFAULT_RETRY_COUNT           = 5;
	public static final int DEFAULT_RETRY_WAIT_IN_MS      = 5000;
	
	//-------------------------------------------------------------------------
	private CalcEngineConfig ()
	    throws Exception
	{}

	//-------------------------------------------------------------------------
	public static CalcEngineConfig access ()
		throws Exception
	{
		final CalcEngineConfig aConfig = new CalcEngineConfig ();
		return aConfig;
	}

	//-------------------------------------------------------------------------
	public String getInQueue ()
	    throws Exception
	{
		return mem_Config ().get(CFGKEY_QUEUE_CALCENGINE_IN, String.class);
	}
	
	//-------------------------------------------------------------------------
	public String getOutQueue ()
	    throws Exception
	{
		return mem_Config ().get(CFGKEY_QUEUE_CALCENGINE_OUT, String.class);
	}

	//-------------------------------------------------------------------------
	public boolean isRestoreDocumentsEnabled ()
	    throws Exception
	{
		return mem_Config ().get(CFGKEY_ENABLE_RESTORE_DOCUMENTS, Boolean.class);
	}

	//-------------------------------------------------------------------------
	public int getRequestTimneoutInMS ()
	    throws Exception
	{
		return mem_Config ().get(CFGKEY_REQUEST_TIMEOUT, Integer.class, DEFAULT_REUQEST_TIMEOUT_IN_MS);
	}

	//-------------------------------------------------------------------------
	public int getRetryCount ()
	    throws Exception
	{
		return mem_Config ().get(CFGKEY_RETRY_COUNT, Integer.class, DEFAULT_RETRY_COUNT);
	}

	//-------------------------------------------------------------------------
	public int getRetryWaitInMS ()
	    throws Exception
	{
		return mem_Config ().get(CFGKEY_RETRY_WAIT, Integer.class, DEFAULT_RETRY_WAIT_IN_MS);
	}

	//-------------------------------------------------------------------------
	public int getRetryWaitInS ()
	    throws Exception
	{
		final int nWaitInMS = getRetryWaitInMS ();
		return (int) (nWaitInMS / 1000);
	}

	//-------------------------------------------------------------------------
	final IComplexConfiguration mem_Config ()
	    throws Exception
	{
		if (m_iConfig == null)
			m_iConfig = ConfigAccess.accessConfig(CONFIG_PACKAGE);
		return m_iConfig;
	}

	//-------------------------------------------------------------------------
	private IComplexConfiguration m_iConfig = null;
}
