/**
 * OPEN-XCHANGE legal information
 *
 * All intellectual property rights in the Software are protected by
 * international copyright laws.
 *
 *
 * In some countries OX, OX Open-Xchange, open xchange and OXtender
 * as well as the corresponding Logos OX Open-Xchange and OX are registered
 * trademarks of the Open-Xchange, Inc. group of companies.
 * The use of the Logos is not covered by the GNU General Public License.
 * Instead, you are allowed to use these Logos according to the terms and
 * conditions of the Creative Commons License, Version 2.5, Attribution,
 * Non-commercial, ShareAlike, and the interpretation of the term
 * Non-commercial applicable to the aforementioned license is published
 * on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 * Please make sure that third-party modules and libraries are used
 * according to their respective licenses.
 *
 * Any modifications to this package must retain all copyright notices
 * of the original copyright holder(s) for the original code used.
 *
 * After any such modifications, the original and derivative code shall remain
 * under the copyright of the copyright holder(s) and/or original author(s)per
 * the Attribution and Assignment Agreement that can be located at
 * http://www.open-xchange.com/EN/developer/. The contributing author shall be
 * given Attribution for the derivative code and a license granting use.
 *
 *  Copyright (C) 2004-2014 Open-Xchange, Inc.
 *  Mail: info@open-xchange.com
 *
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License, Version 2 as published
 *  by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *  or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc., 59
 *  Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
package com.openxchange.office_communication.cluster_management.core.impl;

import javax.management.JMX;
import javax.management.MBeanServerConnection;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmxClient
{
	//-------------------------------------------------------------------------
	private static final Logger LOG = LoggerFactory.getLogger(JmxClient.class);
	
	//-------------------------------------------------------------------------
	public JmxClient ()
		throws Exception
	{}

	//-------------------------------------------------------------------------
	public void setJmxHost (final String sHost)
		throws Exception
	{
		m_sJmxHost = sHost;
	}

	//-------------------------------------------------------------------------
	public void setJmxPort (final int nPort)
		throws Exception
	{
		m_nJmxPort = nPort;
	}

	//-------------------------------------------------------------------------
	public void connect ()
		throws Exception
	{
		if (m_aJmx != null)
			return;
		
//		final String        sUri = impl_getJmxUri ();
//		LOG.info ("##### DBG : jmx uri   = '"+sUri+"'");
//		final JMXServiceURL aUri = new JMXServiceURL(sUri);
//		
//		final JMXConnector  aJmx = JMXConnectorFactory.connect(aUri, null);
//		LOG.info ("##### DBG : jmx ctx   = '"+aJmx+"'");
//
//		final MBeanServerConnection aMBeanServer = aJmx.getMBeanServerConnection();
//		LOG.info ("##### DBG : mbean srv = '"+aMBeanServer+"'");
//		
//		m_aJmx         = aJmx        ;
//		m_aMBeanServer = aMBeanServer;
//		
//		final String     sObject = IAppMonitorMBean.JMX_ID;//"org.apache.activemq:type=Broker,brokerName=localhost,destinationType=Queue,destinationName=calcengine_in";
//		final ObjectName aObject = new ObjectName(sObject);
//		
////		org.apache.activemq.broker.jmx.QueueViewMBean aQueueMonitor = JMX.newMBeanProxy(aMBeanServer, aObject, org.apache.activemq.broker.jmx.QueueViewMBean.class, true);
////		LOG.info ("##### DBG : mbean = '"+aQueueMonitor+"'");
//
//		LOG.info ("##### DBG : register listener ...");
//		aMBeanServer.addNotificationListener(aObject, new MyListener (), null, null);
//		LOG.info ("##### DBG : register listener = OK.");
	}
	
	//-------------------------------------------------------------------------
	private static class MyListener implements NotificationListener
	{
		@Override
		public void handleNotification(final Notification aNotification,
									   final Object       aHandback    )
	    {
			LOG.info("##### JMX-NOTIFY : "+aNotification);
	    }
	}
	
	//-------------------------------------------------------------------------
	private String impl_getJmxUri ()
		throws Exception
	{
		final StringBuffer sUri = new StringBuffer (256);
		
		sUri.append ("service:jmx:rmi:///jndi/rmi://");
		if ( ! StringUtils.isEmpty(m_sJmxHost))
			sUri.append (m_sJmxHost);
		sUri.append (":");
		sUri.append (m_nJmxPort);
		sUri.append ("/jmxrmi");
		
		return sUri.toString ();
	}
	
	//-------------------------------------------------------------------------
	private String m_sJmxHost = "localhost";

	//-------------------------------------------------------------------------
	private int m_nJmxPort = 0;

	//-------------------------------------------------------------------------
	private JMXConnector m_aJmx = null;

	//-------------------------------------------------------------------------
	private MBeanServerConnection m_aMBeanServer = null;
}
