/**
 * OPEN-XCHANGE legal information
 *
 * All intellectual property rights in the Software are protected by
 * international copyright laws.
 *
 *
 * In some countries OX, OX Open-Xchange, open xchange and OXtender
 * as well as the corresponding Logos OX Open-Xchange and OX are registered
 * trademarks of the Open-Xchange, Inc. group of companies.
 * The use of the Logos is not covered by the GNU General Public License.
 * Instead, you are allowed to use these Logos according to the terms and
 * conditions of the Creative Commons License, Version 2.5, Attribution,
 * Non-commercial, ShareAlike, and the interpretation of the term
 * Non-commercial applicable to the aforementioned license is published
 * on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 * Please make sure that third-party modules and libraries are used
 * according to their respective licenses.
 *
 * Any modifications to this package must retain all copyright notices
 * of the original copyright holder(s) for the original code used.
 *
 * After any such modifications, the original and derivative code shall remain
 * under the copyright of the copyright holder(s) and/or original author(s)per
 * the Attribution and Assignment Agreement that can be located at
 * http://www.open-xchange.com/EN/developer/. The contributing author shall be
 * given Attribution for the derivative code and a license granting use.
 *
 *  Copyright (C) 2004-2014 Open-Xchange, Inc.
 *  Mail: info@open-xchange.com
 *
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License, Version 2 as published
 *  by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *  or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc., 59
 *  Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
package com.openxchange.office_communication.cluster_management.core.impl;

import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.impl.DefaultMessage;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import com.openxchange.office_communication.cluster_management.core.ClusterState;
import com.openxchange.office_communication.cluster_management.core.IClusterManagerRemoteControl;
import com.openxchange.office_communication.cluster_management.core.PersistentClusterState;
import com.openxchange.office_communication.jms.core.plain.beans.JMSMessageBean;
import com.openxchange.office_communication.jms.core.plain.beans.JMSMessageUtils;

//=============================================================================
public class ClusterManagerRemoteControl4Camel extends ClusterManagerRemoteControlBase
{
	//-------------------------------------------------------------------------
	private static final Logger LOG = LoggerFactory.getLogger(ClusterManagerRemoteControl4Camel.class);

	//-------------------------------------------------------------------------
	public ClusterManagerRemoteControl4Camel ()
		throws Exception
	{
	}

	//-------------------------------------------------------------------------
	protected void send (final JMSMessageBean aBean)
		throws Exception
	{
		Validate.notNull(m_aControlChannel, "Missing member 'controlChannel'.");

		final Message  aCamelMessage = new DefaultMessage ();
		final Exchange aExchange     = new DefaultExchange(m_aCamelContext);
		
		JMSMessageUtils  .mapBeanToMessage(aBean, aCamelMessage);
		aExchange        .setIn           (aCamelMessage       );
		m_aControlChannel.send            (aExchange           );
	}

	//-------------------------------------------------------------------------
	public void setControlChannel (final ProducerTemplate aChannel)
		throws Exception
	{
		Validate.notNull(aChannel, "Invalid argument 'controlChannel'.");
		m_aControlChannel = aChannel;
	}
	
	//-------------------------------------------------------------------------
	@Autowired
	private CamelContext m_aCamelContext = null;
	
	//-------------------------------------------------------------------------
	private ProducerTemplate m_aControlChannel = null;
}
