/**
 * OPEN-XCHANGE legal information
 *
 * All intellectual property rights in the Software are protected by
 * international copyright laws.
 *
 *
 * In some countries OX, OX Open-Xchange, open xchange and OXtender
 * as well as the corresponding Logos OX Open-Xchange and OX are registered
 * trademarks of the Open-Xchange, Inc. group of companies.
 * The use of the Logos is not covered by the GNU General Public License.
 * Instead, you are allowed to use these Logos according to the terms and
 * conditions of the Creative Commons License, Version 2.5, Attribution,
 * Non-commercial, ShareAlike, and the interpretation of the term
 * Non-commercial applicable to the aforementioned license is published
 * on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 * Please make sure that third-party modules and libraries are used
 * according to their respective licenses.
 *
 * Any modifications to this package must retain all copyright notices
 * of the original copyright holder(s) for the original code used.
 *
 * After any such modifications, the original and derivative code shall remain
 * under the copyright of the copyright holder(s) and/or original author(s)per
 * the Attribution and Assignment Agreement that can be located at
 * http://www.open-xchange.com/EN/developer/. The contributing author shall be
 * given Attribution for the derivative code and a license granting use.
 *
 *  Copyright (C) 2004-2014 Open-Xchange, Inc.
 *  Mail: info@open-xchange.com
 *
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License, Version 2 as published
 *  by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *  or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc., 59
 *  Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
package com.openxchange.office_communication.cluster_management.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

//=============================================================================
public class ClusterState implements Serializable
{
	//-------------------------------------------------------------------------
	private static final long serialVersionUID = 1L;

	//-------------------------------------------------------------------------
	public ClusterState ()
		throws Exception
	{}

	//-------------------------------------------------------------------------
	public void setClusterState (final EClusterState eState)
		throws Exception
	{
		m_eState = eState;
	}	
	
	//-------------------------------------------------------------------------
	public EClusterState getClusterState ()
		throws Exception
	{
		return m_eState;
	}	

	//-------------------------------------------------------------------------
	public void setAppState (final String sApp  ,
							 final String sState)
	    throws Exception
	{
		mem_AppStates ().put(sApp, sState);
	}

	//-------------------------------------------------------------------------
	public void countAppStart (final String sApp)
	    throws Exception
	{
		final Map< String, Integer > lRegistry = mem_AppRestarts ();
		final Integer                nOld      = lRegistry.get(sApp);
		      Integer                nNew      = null;
		
		if (nOld == null)
			nNew = 1;
		else
			nNew = nOld + 1;
		
		lRegistry.put(sApp, nNew);
	}

	//-------------------------------------------------------------------------
	public int getAppStartCount (final String sApp)
		throws Exception
	{
		final Map< String, Integer > lRegistry = mem_AppRestarts ();
		final Integer                nRestarts = lRegistry.get(sApp);
		
		if (nRestarts == null)
			return 0;
		
		return nRestarts.intValue();
	}
	
	//-------------------------------------------------------------------------
	public List< String > listApps ()
		throws Exception
	{
		final List< String > lApps = new ArrayList< String > (mem_AppStates ().keySet());
		return lApps;
	}
	
	//-------------------------------------------------------------------------
	public String getAppState (final String sAppId)
		throws Exception
	{
		return mem_AppStates ().get(sAppId);
	}

	//-------------------------------------------------------------------------
	private Map< String, String > mem_AppStates ()
	    throws Exception
	{
		if (m_lAppStates == null)
			m_lAppStates = new HashMap< String, String > ();
		return m_lAppStates;
	}

	//-------------------------------------------------------------------------
	private Map< String, Integer > mem_AppRestarts ()
	    throws Exception
	{
		if (m_lAppRestarts == null)
			m_lAppRestarts = new HashMap< String, Integer > ();
		return m_lAppRestarts;
	}

	//-------------------------------------------------------------------------
	private EClusterState m_eState = null; 

	//-------------------------------------------------------------------------
	private Map< String, String > m_lAppStates = null;

	//-------------------------------------------------------------------------
	private Map< String, Integer > m_lAppRestarts = null;
}
