/**
 * OPEN-XCHANGE legal information
 *
 * All intellectual property rights in the Software are protected by
 * international copyright laws.
 *
 *
 * In some countries OX, OX Open-Xchange, open xchange and OXtender
 * as well as the corresponding Logos OX Open-Xchange and OX are registered
 * trademarks of the Open-Xchange, Inc. group of companies.
 * The use of the Logos is not covered by the GNU General Public License.
 * Instead, you are allowed to use these Logos according to the terms and
 * conditions of the Creative Commons License, Version 2.5, Attribution,
 * Non-commercial, ShareAlike, and the interpretation of the term
 * Non-commercial applicable to the aforementioned license is published
 * on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 * Please make sure that third-party modules and libraries are used
 * according to their respective licenses.
 *
 * Any modifications to this package must retain all copyright notices
 * of the original copyright holder(s) for the original code used.
 *
 * After any such modifications, the original and derivative code shall remain
 * under the copyright of the copyright holder(s) and/or original author(s)per
 * the Attribution and Assignment Agreement that can be located at
 * http://www.open-xchange.com/EN/developer/. The contributing author shall be
 * given Attribution for the derivative code and a license granting use.
 *
 *  Copyright (C) 2004-2014 Open-Xchange, Inc.
 *  Mail: info@open-xchange.com
 *
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License, Version 2 as published
 *  by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *  or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc., 59
 *  Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
package com.openxchange.office_communication.cluster_management.core;

import com.openxchange.office_communication.tools.cmdline.CommandLineBase;


//=============================================================================
public class ClusterAppCmdLineBase extends CommandLineBase
{
	//-------------------------------------------------------------------------
	public static final String OPT_SHORT_UNIQUE_CLUSTER_RESID = "ucrid";
	public static final String OPT_SHORT_CONFIGPATH           = "cp";
	public static final String OPT_SHORT_DEBUG                = "d" ;
	public static final String OPT_SHORT_MANAGEMENT_PORT      = "mp";
	
	//-------------------------------------------------------------------------
	public static final String OPT_LONG_UNIQUE_CLUSTER_RESID  = "unique-cluster-resid";
	public static final String OPT_LONG_CONFIGPATH            = "config-path";
	public static final String OPT_LONG_DEBUG                 = "debug";
	public static final String OPT_LONG_MANAGEMENT_PORT       = "management-port";

	//-------------------------------------------------------------------------
	public ClusterAppCmdLineBase (final String sCommandName)
		throws Exception
	{
		super(sCommandName);
		impl_init ();
	}

	//-------------------------------------------------------------------------
	private void impl_init ()
	    throws Exception
	{
		addOption (OPT_SHORT_UNIQUE_CLUSTER_RESID      ,
				   OPT_LONG_UNIQUE_CLUSTER_RESID       ,
				   CommandLineBase.HAS_VALUE           ,
				   CommandLineBase.NOT_REQUIRED        ,
				   "define the unique ID of this app\n"+
				   "within the current cluster context");

		addOption (OPT_SHORT_CONFIGPATH          ,
				   OPT_LONG_CONFIGPATH           ,
				   CommandLineBase.HAS_VALUE     ,
				   CommandLineBase.NOT_REQUIRED  ,
				   "define the path root where\n"+
				   "configuration files exists." );
		
		addOption (OPT_SHORT_DEBUG             ,
				   OPT_LONG_DEBUG              ,
				   CommandLineBase.HAS_NO_VALUE,
				   CommandLineBase.NOT_REQUIRED,
				   "enable debug logging"      );

		addOption (OPT_SHORT_MANAGEMENT_PORT   ,
				   OPT_LONG_MANAGEMENT_PORT    ,
				   CommandLineBase.HAS_VALUE   ,
				   CommandLineBase.NOT_REQUIRED,
				   "port for remote management");
	}

	//-------------------------------------------------------------------------
	public String getUCRID ()
	    throws Exception
	{
		return getOptionValue(OPT_SHORT_UNIQUE_CLUSTER_RESID);
	}

	//-------------------------------------------------------------------------
	public String getConfigPath ()
	    throws Exception
	{
		return getOptionValue(OPT_SHORT_CONFIGPATH);
	}

	//-------------------------------------------------------------------------
	public boolean isDebug ()
	    throws Exception
	{
		return hasOption(OPT_SHORT_DEBUG);
	}

	//-------------------------------------------------------------------------
	public boolean hasManagementPort ()
	    throws Exception
	{
		return hasOption(OPT_SHORT_MANAGEMENT_PORT);
	}

	//-------------------------------------------------------------------------
	public int getManagementPort ()
	    throws Exception
	{
		final String sPort = getOptionValue(OPT_SHORT_MANAGEMENT_PORT);
		final int    nPort = Integer.parseInt(sPort);
		return nPort;
	}
}
