/**
 * Copyright (C) 2012 - 2013 Alessandro Vurro.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.googlecode.jmapper.enums;

/**
 * Enumeration that containts all conversion between primitive types.
 * @author Alessandro Vurro
 *
 */
public enum ConversionType {

	// ... TO STRING
	FromByteToString,
	FrombyteToString,
	FromShortToString,
	FromshortToString,
	FromintToString,
	FromIntegerToString,
	FromlongToString,
	FromLongToString,
	FromfloatToString,
	FromFloatToString,
	FromdoubleToString,
	FromDoubleToString,
	FromcharToString,
	FromCharacterToString,
	FrombooleanToString,
	FromBooleanToString,
	
	// FROM STRING TO OTHERS...
	FromStringTobyte,
	FromStringToByte,
	FromStringToshort,
	FromStringToShort,
	FromStringToint,
	FromStringToInteger,
	FromStringTolong,
	FromStringToLong,
	FromStringTofloat,
	FromStringToFloat,
	FromStringTodouble,
	FromStringToDouble,
	FromStringTochar,
	FromStringToCharacter,
	FromStringToboolean,
	FromStringToBoolean,
	
	// FROM BYTE TO OTHERS...
	FromByteToshort,
	FromByteToShort,
	FromByteToint,
	FromByteToInteger,
	FromByteTolong,
	FromByteToLong,
	FromByteTofloat,
	FromByteToFloat,
	FromByteTodouble,
	FromByteToDouble,
	FromByteTochar,
	FromByteToCharacter,
	FromByteToboolean,
	FromByteToBoolean,
	
	FrombyteToshort,
	FrombyteToShort,
	FrombyteToint,
	FrombyteToInteger,
	FrombyteTolong,
	FrombyteToLong,
	FrombyteTofloat,
	FrombyteToFloat,
	FrombyteTodouble,
	FrombyteToDouble,
	FrombyteTochar,
	FrombyteToCharacter,
	FrombyteToboolean,
	FrombyteToBoolean,
	
	// FROM SHORT TO OTHERS...
	FromShortTobyte,
	FromShortToByte,
	FromShortToint,
	FromShortToInteger,
	FromShortTolong,
	FromShortToLong,
	FromShortTofloat,
	FromShortToFloat,
	FromShortTodouble,
	FromShortToDouble,
	FromShortTochar,
	FromShortToCharacter,
	FromShortToboolean,
	FromShortToBoolean,
		
	FromshortTobyte,
	FromshortToByte,
	FromshortToint,
	FromshortToInteger,
	FromshortTolong,
	FromshortToLong,
	FromshortTofloat,
	FromshortToFloat,
	FromshortTodouble,
	FromshortToDouble,
	FromshortTochar,
	FromshortToCharacter,
	FromshortToboolean,
	FromshortToBoolean,
		
	// FROM INTEGER/INT TO OTHERS...
	FromIntegerTobyte,
	FromIntegerToByte,
	FromIntegerToshort,
	FromIntegerToShort,
	FromIntegerTolong,
	FromIntegerToLong,
	FromIntegerTofloat,
	FromIntegerToFloat,
	FromIntegerTodouble,
	FromIntegerToDouble,
	FromIntegerTochar,
	FromIntegerToCharacter,
	FromIntegerToboolean,
	FromIntegerToBoolean,

	FromintTobyte,
	FromintToByte,
	FromintToshort,
	FromintToShort,
	FromintTolong,
	FromintToLong,
	FromintTofloat,
	FromintToFloat,
	FromintTodouble,
	FromintToDouble,
	FromintTochar,
	FromintToCharacter,
	FromintToboolean,
	FromintToBoolean,
	// FROM LONG TO OTHERS...
	FromLongTobyte,
	FromLongToByte,
	FromLongToshort,
	FromLongToShort,
	FromLongToint,
	FromLongToInteger,
	FromLongTofloat,
	FromLongToFloat,
	FromLongTodouble,
	FromLongToDouble,
	FromLongTochar,
	FromLongToCharacter,
	FromLongToboolean,
	FromLongToBoolean,

	FromlongTobyte,
	FromlongToByte,
	FromlongToshort,
	FromlongToShort,
	FromlongToint,
	FromlongToInteger,
	FromlongTofloat,
	FromlongToFloat,
	FromlongTodouble,
	FromlongToDouble,
	FromlongTochar,
	FromlongToCharacter,
	FromlongToboolean,
	FromlongToBoolean,
	
	// FROM FLOAT TO OTHERS...
	FromFloatTobyte,
	FromFloatToByte,
	FromFloatToshort,
	FromFloatToShort,
	FromFloatToint,
	FromFloatToInteger,
	FromFloatTolong,
	FromFloatToLong,
	FromFloatTodouble,
	FromFloatToDouble,
	FromFloatTochar,
	FromFloatToCharacter,
	FromFloatToboolean,
	FromFloatToBoolean,

	FromfloatTobyte,
	FromfloatToByte,
	FromfloatToshort,
	FromfloatToShort,
	FromfloatToint,
	FromfloatToInteger,
	FromfloatTolong,
	FromfloatToLong,
	FromfloatTodouble,
	FromfloatToDouble,
	FromfloatTochar,
	FromfloatToCharacter,
	FromfloatToboolean,
	FromfloatToBoolean,
	
	// FROM DOUBLE TO OTHERS...
	FromDoubleTobyte,
	FromDoubleToByte,
	FromDoubleToshort,
	FromDoubleToShort,
	FromDoubleToint,
	FromDoubleToInteger,
	FromDoubleTolong,
	FromDoubleToLong,
	FromDoubleTofloat,
	FromDoubleToFloat,
	FromDoubleTochar,
	FromDoubleToCharacter,
	FromDoubleToboolean,
	FromDoubleToBoolean,
	
	FromdoubleTobyte,
	FromdoubleToByte,
	FromdoubleToshort,
	FromdoubleToShort,
	FromdoubleToint,
	FromdoubleToInteger,
	FromdoubleTolong,
	FromdoubleToLong,
	FromdoubleTofloat,
	FromdoubleToFloat,
	FromdoubleTochar,
	FromdoubleToCharacter,
	FromdoubleToboolean,
	FromdoubleToBoolean,
	
	
	// FROM CHARACTER/CHAR TO OTHERS...
	FromCharacterTobyte,
	FromCharacterToByte,
	FromCharacterToshort,
	FromCharacterToShort,
	FromCharacterToint,
	FromCharacterToInteger,
	FromCharacterTolong,
	FromCharacterToLong,
	FromCharacterTofloat,
	FromCharacterToFloat,
	FromCharacterTodouble,
	FromCharacterToDouble,
	FromCharacterToboolean,
	FromCharacterToBoolean,
		
	FromcharTobyte,
	FromcharToByte,
	FromcharToshort,
	FromcharToShort,
	FromcharToint,
	FromcharToInteger,
	FromcharTolong,
	FromcharToLong,
	FromcharTofloat,
	FromcharToFloat,
	FromcharTodouble,
	FromcharToDouble,
	FromcharToboolean,
	FromcharToBoolean,
	
	// FROM BOOLEAN TO OTHERS...
	FromBooleanTobyte,
	FromBooleanToByte,
	FromBooleanToshort,
	FromBooleanToShort,
	FromBooleanToint,
	FromBooleanToInteger,
	FromBooleanTolong,
	FromBooleanToLong,
	FromBooleanTofloat,
	FromBooleanToFloat,
	FromBooleanTodouble,
	FromBooleanToDouble,
	FromBooleanTochar,
	FromBooleanToCharacter,
		
	FrombooleanTobyte,
	FrombooleanToByte,
	FrombooleanToshort,
	FrombooleanToShort,
	FrombooleanToint,
	FrombooleanToInteger,
	FrombooleanTolong,
	FrombooleanToLong,
	FrombooleanTofloat,
	FrombooleanToFloat,
	FrombooleanTodouble,
	FrombooleanToDouble,
	FrombooleanTochar,
	FrombooleanToCharacter,
	
	DEFINED,
	UNDEFINED,
	ABSENT;
	
	public boolean isDefined(){return this == DEFINED;}
	public boolean isUndefined(){return this == UNDEFINED;}
	public boolean isAbsent(){return this == ABSENT;}
}
