/**
 * OPEN-XCHANGE legal information
 *
 * All intellectual property rights in the Software are protected by
 * international copyright laws.
 *
 *
 * In some countries OX, OX Open-Xchange, open xchange and OXtender
 * as well as the corresponding Logos OX Open-Xchange and OX are registered
 * trademarks of the Open-Xchange, Inc. group of companies.
 * The use of the Logos is not covered by the GNU General Public License.
 * Instead, you are allowed to use these Logos according to the terms and
 * conditions of the Creative Commons License, Version 2.5, Attribution,
 * Non-commercial, ShareAlike, and the interpretation of the term
 * Non-commercial applicable to the aforementioned license is published
 * on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 * Please make sure that third-party modules and libraries are used
 * according to their respective licenses.
 *
 * Any modifications to this package must retain all copyright notices
 * of the original copyright holder(s) for the original code used.
 *
 * After any such modifications, the original and derivative code shall remain
 * under the copyright of the copyright holder(s) and/or original author(s)per
 * the Attribution and Assignment Agreement that can be located at
 * http://www.open-xchange.com/EN/developer/. The contributing author shall be
 * given Attribution for the derivative code and a license granting use.
 *
 *  Copyright (C) 2004-2014 Open-Xchange, Inc.
 *  Mail: info@open-xchange.com
 *
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License, Version 2 as published
 *  by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *  or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc., 59
 *  Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
package com.openxchange.office_communication.jms.core.plain.beans;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

//=============================================================================
public class JMSBeanMapping< T extends JMSMessageBean >
{
	//-------------------------------------------------------------------------
	private JMSBeanMapping ()
		throws Exception
	{}

	//-------------------------------------------------------------------------
	public static < T extends JMSMessageBean > JMSBeanMapping< T > create (final Class< T > aBeanClass)
	    throws Exception
	{
		JMSBeanMapping< T > aMapping = new JMSBeanMapping< T > ();
		aMapping.m_aBeanClass = aBeanClass;
		aMapping.impl_describe (aBeanClass);
		return aMapping;
	}
	
	//-------------------------------------------------------------------------
	public Field accessBody ()
		throws Exception
	{
		return m_aBodyField;
	}

	//-------------------------------------------------------------------------
	public Set< String > listHeader ()
	    throws Exception
	{
		final Set< String > lHeader = new HashSet< String > ();
		lHeader.addAll(mem_HeaderFields ().keySet());
		return lHeader;
	}

	//-------------------------------------------------------------------------
	public Set< String > listProperties ()
	    throws Exception
	{
		final Set< String > lProps = new HashSet< String > ();
		lProps.addAll(mem_PropertyFields ().keySet());
		return lProps;
	}
	
	//-------------------------------------------------------------------------
	public Field accessHeader (final String sName)
		throws Exception
	{
		final Map< String, Field > lHeader = mem_HeaderFields ();
		return lHeader.get(sName);
	}

	//-------------------------------------------------------------------------
	public Field accessProperty (final String sName)
		throws Exception
	{
		final Map< String, Field > lHeader = mem_HeaderFields ();
		return lHeader.get(sName);
	}

	//-------------------------------------------------------------------------
	private void impl_describe (final Class< ? > aBeanClass)
		throws Exception
	{
		if (aBeanClass == null)
			return;
		
		final Map< String, Field > lHeader = mem_HeaderFields ();
		final Map< String, Field > lProps  = mem_PropertyFields ();
		final Field[]              lFields = aBeanClass.getDeclaredFields ();

		for (final Field aField : lFields)
		{
			final JMSBody     aJMSBody     = aField.getAnnotation(JMSBody    .class);
			final JMSHeader   aJMSHeader   = aField.getAnnotation(JMSHeader  .class);
			final JMSProperty aJMSProperty = aField.getAnnotation(JMSProperty.class);

			if (aJMSProperty != null)
			{
				final String sName = aJMSProperty.name();
				
				Validate.isTrue( ! lHeader.containsKey(sName)             , "Found double registration of JMSProperty field '"+sName+"' in bean '"+m_aBeanClass+"' ! Thats not supported.");
				Validate.isTrue( StringUtils.containsNone(sName, '.', '-'), "Illegal character in JMSProperty '"+sName+"' detected.");
				
				lHeader.put (sName, aField);
				aField.setAccessible(true);
			}
			else
			if (aJMSHeader != null)
			{
				final String sName = aJMSHeader.name();
				
				Validate.isTrue( ! lHeader.containsKey(sName)             , "Found double registration of JMSHeader field '"+sName+"' in bean '"+m_aBeanClass+"' ! Thats not supported.");
				Validate.isTrue( StringUtils.containsNone(sName, '.', '-'), "Illegal character in JMSHeader '"+sName+"' detected.");
				
				lHeader.put (sName, aField);
				aField.setAccessible(true);
			}
			else
			if (aJMSBody != null)
			{
				Validate.isTrue(m_aBodyField==null, "Found more then one body field in bean '"+m_aBeanClass+"' ! Thats not supported.");
				
				m_aBodyField = aField;
				aField.setAccessible(true);
			}
		}
		
		impl_describe (aBeanClass.getSuperclass());
	}
	
	//-------------------------------------------------------------------------
	private Map< String, Field > mem_HeaderFields ()
		throws Exception
	{
		if (m_lHeaderFields == null)
			m_lHeaderFields = new HashMap< String, Field > ();
		return m_lHeaderFields;
	}

	//-------------------------------------------------------------------------
	private Map< String, Field > mem_PropertyFields ()
		throws Exception
	{
		if (m_lPropertyFields == null)
			m_lPropertyFields = new HashMap< String, Field > ();
		return m_lPropertyFields;
	}

	//-------------------------------------------------------------------------
	private Class< T > m_aBeanClass;

	//-------------------------------------------------------------------------
	private Field m_aBodyField = null;
	
	//-------------------------------------------------------------------------
	private Map< String, Field > m_lHeaderFields = null;

	//-------------------------------------------------------------------------
	private Map< String, Field > m_lPropertyFields = null;
}
