/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.spellchecker.json.actions;

import org.json.JSONException;
import org.json.JSONObject;
import com.openexchange.ajax.requesthandler.AJAXActionService;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.exception.OXException;
import com.openexchange.server.ServiceLookup;
import com.openexchange.spellchecker.ISpellChecker;
import com.openexchange.tools.session.ServerSession;

/**
 * {@link SpellWordAction}
 *
 * @author <a href="mailto:oliver.specht@open-xchange.com">Oliver Specht</a>
 */
/*
 * @Action(method = RequestMethod.GET, name = "exportdocument", description =
 * "Save the requested document after merging in the given operations.", parameters = {
 * @Parameter(name = "session", description = "A session ID previously obtained from the login module."),
 * @Parameter(name = "id", description = "Object ID of the requested infoitem."),
 * @Parameter(name = "folder_id", description = "Folder ID of the requested infoitem."),
 * @Parameter(name = "uid", description = "The unique id of the client application."),
 * @Parameter(name = "version", optional = true, description =
 * "If present, the infoitem data describes the given version. Otherwise the current version is used."), }, responseDescription = "None.")
 */
public class SpellWordAction implements AJAXActionService {

    protected ServiceLookup services = null;

    /**
     * Initializes a new {@link SpellWordAction}.
     *
     * @param services
     */
    public SpellWordAction(ServiceLookup services) {
        this.services = services;
    }

    @Override
    public AJAXRequestResult perform(AJAXRequestData request, ServerSession session) throws OXException {

        AJAXRequestResult requestResult = new AJAXRequestResult();
        final JSONObject spellResult = new JSONObject();

        String wordToCheck = request.getParameter("word");
        String locale = request.getParameter("locale");
        final ISpellChecker iSpellChecker = services.getService(ISpellChecker.class);
        if (iSpellChecker != null && wordToCheck != null && locale != null && wordToCheck.length() > 0) {
            try {
                spellResult.put("SpellResult", iSpellChecker.checkSpelling(wordToCheck, locale, 0));
            } catch (JSONException e) {
                ;
            }
        }
        requestResult.setResultObject(spellResult);
        return requestResult;
    }
}
