package com.openexchange.office.tools;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;

import org.apache.commons.logging.Log;

import com.openexchange.exception.OXException;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.composition.IDBasedFileAccess;

/**
 * Provides data associated with the input stream retrieved from the document.
 *
 * {@link StreamInfo}
 *
 * @author <a href="mailto:carsten.driesner@open-xchange.com">Carsten Driesner</a>
 * @since v7.6.2
 */
public class StreamInfo implements Closeable {
    private static final Log LOG = com.openexchange.log.Log.loggerFor(StreamInfo.class);

    private ErrorCode errorCode = ErrorCode.NO_ERROR;
    private InputStream documentStream = null;
    private File metaData = null;
    private boolean writeProtected = false;
    private String lockedByUser = "";
    private DocumentFormat documentFormat = DocumentFormat.NONE;
    private IDBasedFileAccess fileAccess = null;

    public StreamInfo() {
    }

    /**
     * Initializes the stream info members with the provided values.
     *
     * Initializes a new {@link StreamInfo}.
     * @param errorCode
     * @param documentStream
     * @param metaData
     */
    public StreamInfo(IDBasedFileAccess fileAccess, ErrorCode errorCode, InputStream documentStream, File metaData, boolean writeProtected) {
        this.fileAccess = fileAccess;
        this.metaData = metaData;
        this.errorCode = errorCode;
        this.documentStream = documentStream;
        this.writeProtected = writeProtected;
    }

    public ErrorCode getErrorCode() {
        return errorCode;
    }

    public InputStream getDocumentStream() {
        return documentStream;
    }

    public File getMetaData() {
        return metaData;
    }

    public boolean isWriteProtected() {
        return writeProtected;
    }

    public String getLockedByUser() {
        return this.lockedByUser;
    }

    public DocumentFormat getDocumentFormat() {
        return this.documentFormat;
    }

    public void setErrorCode(final ErrorCode errorCode) {
        this.errorCode = errorCode;
    }

    public void setWriteProtected(boolean writeProtected) {
        this.writeProtected = writeProtected;
    }

    public void setMetaData(final File metaData) {
        this.metaData = metaData;
    }

    public void setDocumentStream(final InputStream documentStream) {
        this.documentStream = documentStream;
    }

    public void setLockedByUser(final String lockedByUser) {
        this.lockedByUser = lockedByUser;
    }

    public void setDocumentFormat(final DocumentFormat documentFormat) {
        this.documentFormat = documentFormat;
    }

    public void setFileAccess(final IDBasedFileAccess fileAccess) {
        this.fileAccess = fileAccess;
    }

    @Override
    public void close() throws IOException
    {
        if (null != this.fileAccess) {
            try {
                this.fileAccess.finish();
            } catch (OXException e) {
                LOG.warn("Exception catched while trying to close IDBasedFileAccess instance.", e);
                throw new IOException(e);
            }
        }
    }
}
