package com.openexchange.office.tools;

import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;


public class OperationFilter {

    static public JSONArray filterOperations(final JSONArray source, Set<String> filterOutOps) throws Exception {
        JSONArray result = null;

        if (source != null) {
            if (filterOutOps != null) {
                result = new JSONArray();

                for (int i = 0; i < source.length(); i++) {
                    boolean filterOut = false;
                    final JSONObject operation = source.getJSONObject(i);
                    if (operation != null) {
                        filterOut = filterOutOps.contains(operation.getString("name"));
                    }

                    if (!filterOut) {
                        result.put(operation);
                    }
                }
            } else {
                result = source;
            }
        }

        return result;
    }
}
