/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.ooxml.operations;

import org.docx4j.dml.CTColorScheme;
import org.docx4j.dml.Theme;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import com.openexchange.office.FilterException;
import com.openexchange.office.ooxml.OperationDocument;
import com.openexchange.office.ooxml.tools.Commons;
import com.openexchange.office.ooxml.tools.ThemeFonts;

abstract public class CreateOperationHelper {

    protected final OperationDocument operationDocument;
    protected final ThemeFonts themeFonts;
    protected JSONArray operationsArray;
    protected int jsonLogSize;

    protected CreateOperationHelper(OperationDocument _operationDocument, JSONArray _operationsArray)
    	throws FilterException {

    	operationDocument = _operationDocument;
        operationsArray = _operationsArray;
        themeFonts = new ThemeFonts(operationDocument.getTheme());
        jsonLogSize = 0;
    }

    abstract public OperationDocument getOperationDocument();

    abstract public void createDocumentDefaults(String userLanguage)
        throws Exception;

    public void CreateThemeOperations()
        throws FilterException, JSONException {

    	final Theme theme = getOperationDocument().getTheme();

    	String themeName = theme.getName();
        CTColorScheme colorScheme = theme.getThemeElements().getClrScheme();
        final JSONObject themeObject = new JSONObject();
        final JSONObject colorSchemes = new JSONObject();
        colorSchemes.put("dark1", Commons.ctColorToString( colorScheme.getDk1() ));
        colorSchemes.put("dark2", Commons.ctColorToString( colorScheme.getDk2() ));
        colorSchemes.put("light1", Commons.ctColorToString( colorScheme.getLt1() ));
        colorSchemes.put("light2", Commons.ctColorToString( colorScheme.getLt2() ));
        colorSchemes.put("text1", Commons.ctColorToString( colorScheme.getDk1() ));
        colorSchemes.put("text2", Commons.ctColorToString( colorScheme.getDk2() ));
        colorSchemes.put("background1", Commons.ctColorToString( colorScheme.getLt1() ));
        colorSchemes.put("background2", Commons.ctColorToString( colorScheme.getLt2() ));
        colorSchemes.put("accent1", Commons.ctColorToString( colorScheme.getAccent1() ));
        colorSchemes.put("accent2", Commons.ctColorToString( colorScheme.getAccent2() ));
        colorSchemes.put("accent3", Commons.ctColorToString( colorScheme.getAccent3() ));
        colorSchemes.put("accent4", Commons.ctColorToString( colorScheme.getAccent4() ));
        colorSchemes.put("accent5", Commons.ctColorToString( colorScheme.getAccent5() ));
        colorSchemes.put("accent6", Commons.ctColorToString( colorScheme.getAccent6() ));
        colorSchemes.put("hyperlink", Commons.ctColorToString( colorScheme.getHlink() ));
        colorSchemes.put("followedHyperlink", Commons.ctColorToString( colorScheme.getFolHlink() ));

        themeObject.put("colorScheme", colorSchemes);
        addInsertThemeOperation(themeName, themeObject);
    }

    public JSONArray getOperationsArray() {
    	return operationsArray;
    }

    public void setOperationsArray(JSONArray _operationsArray) {
    	operationsArray = _operationsArray;
    }

    public ThemeFonts getThemeFonts() {
    	return themeFonts;
    }

    public void addSetDocumentAttributesOperation(JSONObject attrs)
        throws JSONException {

        if(attrs!=null&&attrs.length()>0) {
            final JSONObject setDocumentAttributesObject = new JSONObject();
            setDocumentAttributesObject.put("name", "setDocumentAttributes");
            setDocumentAttributesObject.put("attrs", attrs);
            operationsArray.put(0, setDocumentAttributesObject);
        }
    }

    public void addInsertThemeOperation(String themeName, JSONObject attrs)
        throws JSONException {

        final JSONObject insertThemeObject = new JSONObject();
        insertThemeObject.put("name", "insertTheme");
        insertThemeObject.put("themeName", themeName);
        if(attrs!=null)
            insertThemeObject.put("attrs", attrs);
        operationsArray.put(insertThemeObject);
    }

    public JSONObject createInsertStyleSheetOperation(String type, String styleId, String styleName, JSONObject attrs, String parentId, Boolean hidden, Integer uipriority, Boolean isDefault, boolean auto)
        throws JSONException {

        final JSONObject insertStylesheetObject = new JSONObject();
        insertStylesheetObject.put("name", "insertStyleSheet");
        insertStylesheetObject.put("type", type);
        insertStylesheetObject.put("styleId", styleId);
        insertStylesheetObject.put("styleName", styleName);
        if(attrs!=null)
            insertStylesheetObject.put("attrs", attrs);
        if(parentId!=null&&parentId.length()>0)
            insertStylesheetObject.put("parent", parentId);
        if(hidden!=null)
            insertStylesheetObject.put("hidden", hidden);
        if(uipriority!=null)
            insertStylesheetObject.put("uiPriority", uipriority);
        if(isDefault!=null&&isDefault)
            insertStylesheetObject.put("default", true);
        if(auto==true) {
            insertStylesheetObject.put("auto", auto);
        }
        return insertStylesheetObject;
    }
}
