/**
 * **********************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008, 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ***********************************************************************
 */

/*
 * This file is automatically generated.
 * Don't edit manually.
 */
package org.odftoolkit.odfdom.dom.element.text;

import org.odftoolkit.odfdom.component.TextContainingElement;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.attribute.text.TextClassNamesAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextCondStyleNameAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextIdAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextStyleNameAttribute;
import org.odftoolkit.odfdom.dom.attribute.xhtml.XhtmlAboutAttribute;
import org.odftoolkit.odfdom.dom.attribute.xhtml.XhtmlContentAttribute;
import org.odftoolkit.odfdom.dom.attribute.xhtml.XhtmlDatatypeAttribute;
import org.odftoolkit.odfdom.dom.attribute.xhtml.XhtmlPropertyAttribute;
import org.odftoolkit.odfdom.dom.attribute.xml.XmlIdAttribute;
import org.odftoolkit.odfdom.dom.element.OdfStylePropertiesBase;
import org.odftoolkit.odfdom.dom.element.style.StyleStyleElement;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.odftoolkit.odfdom.dom.style.props.OdfStylePropertiesSet;
import org.odftoolkit.odfdom.incubator.doc.style.OdfStyle;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;

/**
 * DOM implementation of OpenDocument base element
 *
 */
public abstract class TextParagraphElementBase extends TextContainingElement {

    /**
     * Create the instance of <code>TextParagraphElementBase</code>
     *
     * @param ownerDoc The type is <code>OdfFileDom</code>
     */
    public TextParagraphElementBase(OdfFileDom ownerDoc, OdfName elementName, OdfStyleFamily styleFamily, OdfName styleAttrName) {
        super(ownerDoc, elementName, styleFamily, styleAttrName);
    }

    /**
     * Receives the value of the ODFDOM attribute representation
     * <code>TextClassNamesAttribute</code> , See {
     *
     * @odf.attribute text:class-names}
     *
     * @return - the <code>String</code> , the value or <code>null</code>, if
     * the attribute is not set and no default value defined.
     */
    public String getTextClassNamesAttribute() {
        TextClassNamesAttribute attr = (TextClassNamesAttribute) getOdfAttribute(OdfDocumentNamespace.TEXT, "class-names");
        if (attr != null) {
            return String.valueOf(attr.getValue());
        }
        return null;
    }

    /**
     * Sets the value of ODFDOM attribute representation
     * <code>TextClassNamesAttribute</code> , See {
     *
     * @odf.attribute text:class-names}
     *
     * @param textClassNamesValue The type is <code>String</code>
     */
    public void setTextClassNamesAttribute(String textClassNamesValue) {
        TextClassNamesAttribute attr = new TextClassNamesAttribute((OdfFileDom) this.ownerDocument);
        setOdfAttribute(attr);
        attr.setValue(textClassNamesValue);
    }

    /**
     * Receives the value of the ODFDOM attribute representation
     * <code>TextCondStyleNameAttribute</code> , See {
     *
     * @odf.attribute text:cond-style-name}
     *
     * @return - the <code>String</code> , the value or <code>null</code>, if
     * the attribute is not set and no default value defined.
     */
    public String getTextCondStyleNameAttribute() {
        TextCondStyleNameAttribute attr = (TextCondStyleNameAttribute) getOdfAttribute(OdfDocumentNamespace.TEXT, "cond-style-name");
        if (attr != null) {
            return String.valueOf(attr.getValue());
        }
        return null;
    }

    /**
     * Sets the value of ODFDOM attribute representation
     * <code>TextCondStyleNameAttribute</code> , See {
     *
     * @odf.attribute text:cond-style-name}
     *
     * @param textCondStyleNameValue The type is <code>String</code>
     */
    public void setTextCondStyleNameAttribute(String textCondStyleNameValue) {
        TextCondStyleNameAttribute attr = new TextCondStyleNameAttribute((OdfFileDom) this.ownerDocument);
        setOdfAttribute(attr);
        attr.setValue(textCondStyleNameValue);
    }

    /**
     * Receives the value of the ODFDOM attribute representation
     * <code>TextIdAttribute</code> , See {
     *
     * @odf.attribute text:id}
     *
     * @return - the <code>String</code> , the value or <code>null</code>, if
     * the attribute is not set and no default value defined.
     */
    public String getTextIdAttribute() {
        TextIdAttribute attr = (TextIdAttribute) getOdfAttribute(OdfDocumentNamespace.TEXT, "id");
        if (attr != null) {
            return String.valueOf(attr.getValue());
        }
        return null;
    }

    /**
     * Sets the value of ODFDOM attribute representation
     * <code>TextIdAttribute</code> , See {
     *
     * @odf.attribute text:id}
     *
     * @param textIdValue The type is <code>String</code>
     */
    public void setTextIdAttribute(String textIdValue) {
        TextIdAttribute attr = new TextIdAttribute((OdfFileDom) this.ownerDocument);
        setOdfAttribute(attr);
        attr.setValue(textIdValue);
    }

    /**
     * Receives the value of the ODFDOM attribute representation
     * <code>TextStyleNameAttribute</code> , See {
     *
     * @odf.attribute text:style-name}
     *
     * @return - the <code>String</code> , the value or <code>null</code>, if
     * the attribute is not set and no default value defined.
     */
    public String getTextStyleNameAttribute() {
        TextStyleNameAttribute attr = (TextStyleNameAttribute) getOdfAttribute(OdfDocumentNamespace.TEXT, "style-name");
        if (attr != null) {
            return String.valueOf(attr.getValue());
        }
        return null;
    }

    /**
     * Sets the value of ODFDOM attribute representation
     * <code>TextStyleNameAttribute</code> , See {
     *
     * @odf.attribute text:style-name}
     *
     * @param textStyleNameValue The type is <code>String</code>
     */
    public void setTextStyleNameAttribute(String textStyleNameValue) {
        TextStyleNameAttribute attr = new TextStyleNameAttribute((OdfFileDom) this.ownerDocument);
        setOdfAttribute(attr);
        attr.setValue(textStyleNameValue);
    }

    /**
     * Receives the value of the ODFDOM attribute representation
     * <code>XhtmlAboutAttribute</code> , See {
     *
     * @odf.attribute xhtml:about}
     *
     * @return - the <code>String</code> , the value or <code>null</code>, if
     * the attribute is not set and no default value defined.
     */
    public String getXhtmlAboutAttribute() {
        XhtmlAboutAttribute attr = (XhtmlAboutAttribute) getOdfAttribute(OdfDocumentNamespace.XHTML, "about");
        if (attr != null) {
            return String.valueOf(attr.getValue());
        }
        return null;
    }

    /**
     * Sets the value of ODFDOM attribute representation
     * <code>XhtmlAboutAttribute</code> , See {
     *
     * @odf.attribute xhtml:about}
     *
     * @param xhtmlAboutValue The type is <code>String</code>
     */
    public void setXhtmlAboutAttribute(String xhtmlAboutValue) {
        XhtmlAboutAttribute attr = new XhtmlAboutAttribute((OdfFileDom) this.ownerDocument);
        setOdfAttribute(attr);
        attr.setValue(xhtmlAboutValue);
    }

    /**
     * Receives the value of the ODFDOM attribute representation
     * <code>XhtmlContentAttribute</code> , See {
     *
     * @odf.attribute xhtml:content}
     *
     * @return - the <code>String</code> , the value or <code>null</code>, if
     * the attribute is not set and no default value defined.
     */
    public String getXhtmlContentAttribute() {
        XhtmlContentAttribute attr = (XhtmlContentAttribute) getOdfAttribute(OdfDocumentNamespace.XHTML, "content");
        if (attr != null) {
            return String.valueOf(attr.getValue());
        }
        return null;
    }

    /**
     * Sets the value of ODFDOM attribute representation
     * <code>XhtmlContentAttribute</code> , See {
     *
     * @odf.attribute xhtml:content}
     *
     * @param xhtmlContentValue The type is <code>String</code>
     */
    public void setXhtmlContentAttribute(String xhtmlContentValue) {
        XhtmlContentAttribute attr = new XhtmlContentAttribute((OdfFileDom) this.ownerDocument);
        setOdfAttribute(attr);
        attr.setValue(xhtmlContentValue);
    }

    /**
     * Receives the value of the ODFDOM attribute representation
     * <code>XhtmlDatatypeAttribute</code> , See {
     *
     * @odf.attribute xhtml:datatype}
     *
     * @return - the <code>String</code> , the value or <code>null</code>, if
     * the attribute is not set and no default value defined.
     */
    public String getXhtmlDatatypeAttribute() {
        XhtmlDatatypeAttribute attr = (XhtmlDatatypeAttribute) getOdfAttribute(OdfDocumentNamespace.XHTML, "datatype");
        if (attr != null) {
            return String.valueOf(attr.getValue());
        }
        return null;
    }

    /**
     * Sets the value of ODFDOM attribute representation
     * <code>XhtmlDatatypeAttribute</code> , See {
     *
     * @odf.attribute xhtml:datatype}
     *
     * @param xhtmlDatatypeValue The type is <code>String</code>
     */
    public void setXhtmlDatatypeAttribute(String xhtmlDatatypeValue) {
        XhtmlDatatypeAttribute attr = new XhtmlDatatypeAttribute((OdfFileDom) this.ownerDocument);
        setOdfAttribute(attr);
        attr.setValue(xhtmlDatatypeValue);
    }

    /**
     * Receives the value of the ODFDOM attribute representation
     * <code>XhtmlPropertyAttribute</code> , See {
     *
     * @odf.attribute xhtml:property}
     *
     * @return - the <code>String</code> , the value or <code>null</code>, if
     * the attribute is not set and no default value defined.
     */
    public String getXhtmlPropertyAttribute() {
        XhtmlPropertyAttribute attr = (XhtmlPropertyAttribute) getOdfAttribute(OdfDocumentNamespace.XHTML, "property");
        if (attr != null) {
            return String.valueOf(attr.getValue());
        }
        return null;
    }

    /**
     * Sets the value of ODFDOM attribute representation
     * <code>XhtmlPropertyAttribute</code> , See {
     *
     * @odf.attribute xhtml:property}
     *
     * @param xhtmlPropertyValue The type is <code>String</code>
     */
    public void setXhtmlPropertyAttribute(String xhtmlPropertyValue) {
        XhtmlPropertyAttribute attr = new XhtmlPropertyAttribute((OdfFileDom) this.ownerDocument);
        setOdfAttribute(attr);
        attr.setValue(xhtmlPropertyValue);
    }

    /**
     * Receives the value of the ODFDOM attribute representation
     * <code>XmlIdAttribute</code> , See {
     *
     * @odf.attribute xml:id}
     *
     * @return - the <code>String</code> , the value or <code>null</code>, if
     * the attribute is not set and no default value defined.
     */
    public String getXmlIdAttribute() {
        XmlIdAttribute attr = (XmlIdAttribute) getOdfAttribute(OdfDocumentNamespace.XML, "id");
        if (attr != null) {
            return String.valueOf(attr.getValue());
        }
        return null;
    }

    /**
     * Sets the value of ODFDOM attribute representation
     * <code>XmlIdAttribute</code> , See {
     *
     * @odf.attribute xml:id}
     *
     * @param xmlIdValue The type is <code>String</code>
     */
    public void setXmlIdAttribute(String xmlIdValue) {
        XmlIdAttribute attr = new XmlIdAttribute((OdfFileDom) this.ownerDocument);
        setOdfAttribute(attr);
        attr.setValue(xmlIdValue);
    }

    /**
     * Splitting the element at the given position into two halves
     *
     * If the paragraph does have an automatic style with a master-page, which
     * results into a page break before the paragraph, this page break will be
     * removed for the new second half. For paragraph containing template styles
     * the follow-up style should be chosen.
     *
     * @param posStart The logical position of the first character (or other
     * paragraph child component) that will be moved to the beginning of the new
     * paragraph.
     *
     * @return the new created second text container
     */
    @Override
    public OdfElement split(int posStart) {
        TextParagraphElementBase newSecondElement = (TextParagraphElementBase) super.split(posStart);
        OdfStyle autoStyle = newSecondElement.getAutomaticStyle();

        if (autoStyle != null) {
            OdfStylePropertiesBase paragraphProps = autoStyle.getPropertiesElement(OdfStylePropertiesSet.ParagraphProperties);
            if (autoStyle.getStyleMasterPageNameAttribute() != null || paragraphProps != null) {
                StyleStyleElement newStyle = newSecondElement.getOrCreateUnqiueAutomaticStyle();
                if (autoStyle.getStyleMasterPageNameAttribute() != null) {
                    newStyle.removeAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "master-page-name");
                }
                // overwrite the paragraph properties from the source one, with the cloned element's
                paragraphProps = newStyle.getPropertiesElement(OdfStylePropertiesSet.ParagraphProperties);                
                // no paragraph page break should be inherited
                if (paragraphProps != null) {
                    paragraphProps.removeAttributeNS(OdfDocumentNamespace.FO.getUri(), "break-before");
                    paragraphProps.removeAttributeNS(OdfDocumentNamespace.FO.getUri(), "break-after");
                }
            }
        }
        return newSecondElement;
    }

    @Override
    /**
     * If this element is the first - perhaps only - element of a logical group
     * of XML elements. For instance: table, paragraph
     */
    public boolean isComponentRoot() {
        return true;
    }
}
