/**
 * **********************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008, 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ***********************************************************************
 */
package org.odftoolkit.odfdom.component;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;


    class CachedOperation {
        String mComponentType;
        List<Integer> mStart;
        Map<String, Object> mHardFormattingProperties;
        Object[] mComponentProperties;
        CachedOperation(String componentType, List<Integer> start, Map<String, Object> styleFormatting, Object... componentProperties) {
            mComponentType = componentType;
            mStart = start;
            mHardFormattingProperties = styleFormatting;
            mComponentProperties = componentProperties;
        }
        @Override
        public CachedOperation clone() {
            CachedOperation ret = new CachedOperation(mComponentType, new ArrayList<Integer>(mStart), mHardFormattingProperties, mComponentProperties);
            return ret;
        }
    }
    class CachedInnerTableOperation extends CachedOperation{

        // required to track repeatedColumns rows for spreadsheets..
        int mCurrentRowNo = 0;
        int mCurrentRowRepetition = 0;
        //** Cell Op Props
        String mCellContentString = null;
        int mCellNo;

        CachedInnerTableOperation(String componentType, List<Integer> start, Map<String, Object> styleFormatting, Object... componentProperties) {
            super(componentType, start, styleFormatting, componentProperties );
        }
        @Override
        public CachedOperation clone() {
            CachedOperation ret = new CachedInnerTableOperation(mComponentType, new ArrayList<Integer>(mStart), mHardFormattingProperties, mComponentProperties);
            return ret;
        }
    }

        class CachedComponent extends ArrayList<CachedOperation> {
            private static final long serialVersionUID = 1L;
        }
