/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.office.json.tools;

import java.util.HashMap;
import java.util.logging.Logger;

import org.json.JSONArray;
import org.json.JSONException;

public class EmptyDocumentCache {
    
    private final static Logger LOG = Logger.getLogger(EmptyDocumentCache.class.getName());

	public class EmptyDocData {
		public final String htmlDoc;
		public final JSONArray operations;
		public final byte[] documentData;

		public EmptyDocData(final String htmlDoc, final JSONArray operations, final byte[] documentData) {
			this.htmlDoc = htmlDoc;
			this.operations = operations;
			this.documentData = documentData;
		}
	}

    private final HashMap<String, EmptyDocData> emptyDocCache;

    public EmptyDocumentCache() {
        emptyDocCache = new HashMap<String, EmptyDocData>();
    }

    public EmptyDocData getDocData(String key, String lang) {
        
        if (null != lang) {
            EmptyDocData result = emptyDocCache.get(key + '-' + lang);

            if (null == result) {
                long current = System.currentTimeMillis();
                result = emptyDocCache.get(key);

                if (null == result) {
                    LOG.info("DocumentCache no cached file found");
                    return null;
                }

                JSONArray ops = new JSONArray(result.operations);

                try {
                    ops.getJSONObject(0).getJSONObject("attrs").getJSONObject("character").put("language", lang);
                } catch (JSONException e) {
                    throw new RuntimeException("error while trying to change language of operations", e);
                }

                result = new EmptyDocData(result.htmlDoc, ops, result.documentData);

                emptyDocCache.put(key + '-' + lang, result);

                long time = System.currentTimeMillis() - current;

                LOG.info("DocumentCache changing language via copy operations takes " + time + "ms!");
            }
            return result;
        } else {
            return emptyDocCache.get(key);
        }
    }

    public void setDocData(String key, EmptyDocData docData) {
        emptyDocCache.put(key, docData);
    }
}
