package com.openexchange.office.json.tools;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.file.storage.FileStorageFileAccess;
import com.openexchange.file.storage.composition.IDBasedFileAccess;
import com.openexchange.file.storage.composition.IDBasedFileAccessFactory;
import com.openexchange.office.DocumentProperties;
import com.openexchange.office.IExporter;
import com.openexchange.office.IImporter;
import com.openexchange.office.json.actions.DocumentFilterHelper;
import com.openexchange.office.tools.DocFileHelper;
import com.openexchange.office.tools.DocumentFormat;
import com.openexchange.office.tools.LocalFileMappingManager;
import com.openexchange.server.ServiceLookup;
import com.openexchange.tools.session.ServerSession;

public class DynamicFields
{
    private static final Log LOG = com.openexchange.log.Log.loggerFor(DynamicFields.class);

    public static InputStream insertOptionalFields(
        InputStream inputStm,
        String extensionType,
        AJAXRequestData request,
        JSONObject result,
        ServerSession session,
        ServiceLookup services,
        LocalFileMappingManager localFileMapper)
        throws Exception
    {
        final String fs = request.getParameter("fields");
        final String sfs = request.getParameter("sourcefields");
        final Map<String, Object> values;
        if (StringUtils.isNotBlank(fs))
        {
            values = getFieldsFromParam(fs);
        }
        else if (StringUtils.isNotBlank(sfs))
        {
            values = getFieldsFromFile(sfs, session, services, localFileMapper);
        }
        else
        {
            return inputStm;
        }

        DocumentFormat format = DocFileHelper.getDocumentFormat("." + extensionType);
        final IImporter importer = DocumentFilterHelper.getImporter(services, format);
        final IExporter exporter = DocumentFilterHelper.getExporter(services, format);

        final DocumentProperties documentProperties = new DocumentProperties();
        documentProperties.put(DocumentProperties.PROP_SAVE_TEMPLATE_DOCUMENT, false);

        List<InputStream> inputStreams = copyStream(inputStm);
        inputStm = inputStreams.get(0);
        InputStream newInputStm = inputStreams.get(1);

        JSONObject doc = importer.createOperations(session, newInputStm, documentProperties);
        JSONArray ops = doc.getJSONArray("operations");
        JSONArray newOps = new JSONArray();

        for (int i = 0; i < ops.length(); i++)
        {
            JSONObject op = ops.getJSONObject(i);
            String name = op.getString("name");
            if (name.equals("insertField"))
            {
                String type = op.optString("type", "");
                String dbColumn = null;
                try
                {
                    if (type.equals("database-display") && (dbColumn = op.getJSONObject("attrs").getJSONObject("field").getString("dbColumn")) != null)
                    {
                        Object value = values.get(dbColumn);
                        if (value != null)
                        {
                            op.put("name", "changeField");
                            op.put("representation", value.toString());
                            newOps.put(op);
                        }
                    }
                }
                catch (JSONException e)
                {
                    LOG.warn("JSON-Error while parsing operations for putting fields", e);
                }
            }

        }

        if (newOps.length() > 0)
        {
            final String mergeOperations = newOps.toString();

            inputStm = exporter.createDocument(session, inputStm, mergeOperations, null, documentProperties, true);

            result.put("fieldChanges", newOps.length());
        }
        else
        {
            result.put("fieldChanges", "none");
        }

        return inputStm;
    }

    private static Map<String, Object> getFieldsFromFile(
        String fileId,
        ServerSession session,
        ServiceLookup services,
        LocalFileMappingManager localFileMapper)
        throws Exception
    {

        final IDBasedFileAccessFactory fileFactory = services.getService(IDBasedFileAccessFactory.class);
        final IDBasedFileAccess fileAccess = (null != fileFactory) ? fileFactory.createAccess(session) : null;

        BufferedReader reader = new BufferedReader(new InputStreamReader(fileAccess.getDocument(fileId, FileStorageFileAccess.CURRENT_VERSION), "UTF-8"));

        List<String> header = CSVEntryParser.getCSVContentFromLine(reader.readLine());
        List<String> first = CSVEntryParser.getCSVContentFromLine(reader.readLine());

        Map<String, Object> fields = new HashMap<String, Object>();

        for (int i = 0; i < header.size(); i++)
        {
            fields.put(header.get(i), first.get(i));
        }
        return fields;
    }

    private static Map<String, Object> getFieldsFromParam(
        String fs)
    {
        Map<String, Object> values;
        try
        {
            JSONObject fields = new JSONObject(fs);
            values = fields.asMap();
        }
        catch (JSONException e)
        {
            String[] fields = fs.split(";");
            values = new HashMap<String, Object>();
            for (int i = 0; i < fields.length; i += 2)
            {
                values.put(fields[i], fields[i + 1]);
            }
        }
        return values;
    }

    private static List<InputStream> copyStream(
        InputStream input)
        throws Exception
    {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();

        // Fake code simulating the copy
        // You can generally do better with nio if you need...
        // And please, unlike me, do something about the Exceptions :D
        byte[] buffer = new byte[1024];
        int len;
        while ((len = input.read(buffer)) > -1)
        {
            baos.write(buffer, 0, len);
        }
        baos.flush();

        List<InputStream> res = new ArrayList<InputStream>();

        // Open new InputStreams using the recorded bytes
        // Can be repeated as many times as you wish
        res.add((new ByteArrayInputStream(baos.toByteArray())));
        res.add((new ByteArrayInputStream(baos.toByteArray())));

        return res;
    }

}
