/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.office.calcengine.worker;

import org.apache.commons.lang.StringUtils;
import org.eclipse.jetty.util.log.Logger;

import com.openexchange.office.tools.logging.LogFactory;

//==============================================================================
public class JettyToApacheLoggingBridge extends org.eclipse.jetty.util.log.AbstractLogger
{
	//-------------------------------------------------------------------------
	public JettyToApacheLoggingBridge ()
	{}
	
	//-------------------------------------------------------------------------
	public static void register ()
	{
		System.setProperty ("org.eclipse.jetty.util.log.class", JettyToApacheLoggingBridge.class.getName ());
	}

	//-------------------------------------------------------------------------
	public static void enableDebug (final boolean bEnabled)
	{
		System.setProperty("org.eclipse.jetty.util.log.DEBUG", Boolean.toString(bEnabled));
	}
	
	//-------------------------------------------------------------------------
	@Override
	public void debug(Throwable aEx)
	{
		if ( ! isDebugEnabled())
			return;
		m_aLogImpl.debug(aEx);
	}

	//-------------------------------------------------------------------------
	@Override
	public void debug(String    sMsg ,
					  Object... lArgs)
	{
		if ( ! isDebugEnabled())
			return;
		m_aLogImpl.debug(impl_formatMsgWithArgs(sMsg, lArgs));
	}

	//-------------------------------------------------------------------------
	@Override
	public void debug(String    sMsg,
					  Throwable aEx )
	{
		if ( ! isDebugEnabled())
			return;
		m_aLogImpl.debug(sMsg, aEx);
	}

	//-------------------------------------------------------------------------
	@Override
	public void info(Throwable aEx)
	{
		m_aLogImpl.info(aEx);
	}

	//-------------------------------------------------------------------------
	@Override
	public void info(String    sMsg ,
					 Object... lArgs)
	{
		m_aLogImpl.info(impl_formatMsgWithArgs(sMsg, lArgs));
	}

	//-------------------------------------------------------------------------
	@Override
	public void info(String    sMsg,
					 Throwable aEx )
	{
		m_aLogImpl.info(sMsg, aEx);
	}

	//-------------------------------------------------------------------------
	@Override
	public void warn(Throwable aEx)
	{
		m_aLogImpl.warn(aEx);
	}

	//-------------------------------------------------------------------------
	@Override
	public void warn(String    sMsg ,
					 Object... lArgs)
	{
		m_aLogImpl.warn(impl_formatMsgWithArgs(sMsg, lArgs));
	}

	//-------------------------------------------------------------------------
	@Override
	public void warn(String    aMsg,
					 Throwable aEx )
	{
		m_aLogImpl.warn(aMsg, aEx);
	}

	//-------------------------------------------------------------------------
	@Override
	public String getName()
	{
		return m_sName;
	}

	//-------------------------------------------------------------------------
	@Override
	public void ignore(Throwable arg0)
	{
		// ???
	}

	//-------------------------------------------------------------------------
	@Override
	public boolean isDebugEnabled()
	{
		final String  sEnabled = System.getProperty("org.eclipse.jetty.util.log.DEBUG", "false");
		final boolean bEnabled = Boolean.parseBoolean(sEnabled);
		return bEnabled;
	}

	//-------------------------------------------------------------------------
	@Override
	public void setDebugEnabled(boolean bEnabled)
	{
	}

	//-------------------------------------------------------------------------
	@Override
	protected Logger newLogger(String sClass)
	{
		JettyToApacheLoggingBridge aBridge = new JettyToApacheLoggingBridge ();
		aBridge.m_sName    = sClass;
		aBridge.m_aLogImpl = LogFactory.getJclLog(sClass);
		return aBridge;
	}

	//-------------------------------------------------------------------------
	private static String impl_formatMsgWithArgs (final String    sMsg ,
										          final Object... lArgs)
	{
		final StringBuffer sString = new StringBuffer (256);

		sString.append (sMsg);

		if (lArgs != null)
		{
			for (Object aArg : lArgs)
			{
				String sArg = "null";
				if (aArg != null)
					sArg = aArg.toString();
	
				sString.append (" : ");
				sString.append (sArg );
			}
		}

		return sString.toString ();
	}
	
	//-------------------------------------------------------------------------
	private String m_sName = null;
	
	//-------------------------------------------------------------------------
	private org.apache.commons.logging.Log m_aLogImpl = null;
}
