/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.calcengine.osgi;

import java.util.Hashtable;
import java.util.Set;

import javax.ws.rs.core.Application;

import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.osgi.framework.BundleContext;
import org.osgi.service.http.HttpService;
import org.osgi.service.url.URLConstants;
import org.osgi.service.url.URLStreamHandlerService;

import sun.net.www.protocol.classpath.ClasspathConnection;

import com.hazelcast.core.HazelcastInstance;
import com.openexchange.config.ConfigurationService;
import com.openexchange.office.calcengine.CalcEngineConst;
import com.openexchange.office.calcengine.client.CalcEngineClientFactory;
import com.openexchange.office.calcengine.client.CalcEngineConfig;
import com.openexchange.office.calcengine.client.CalcEngineContext;
import com.openexchange.office.calcengine.client.CalcEngineHttpEntityReader;
import com.openexchange.office.calcengine.client.CalcEngineHttpEntityWriter;
import com.openexchange.office.calcengine.client.ECalcEngineMode;
import com.openexchange.office.calcengine.servlets.CalcEngineServlet;
import com.openexchange.office.tools.OSGIClasspathProtocolHandler;
import com.openexchange.office.tools.logging.LogFactory;
import com.openexchange.osgi.HousekeepingActivator;
import com.openxchange.office_communication.configuration.configitems.JmsServerConfig;
import com.openxchange.office_communication.jms.core.plain.JMSEnv;
import com.sun.jersey.api.core.DefaultResourceConfig;
import com.sun.jersey.spi.container.servlet.ServletContainer;

//-------------------
//- class Activator -
//-------------------

/**
 * {@link HousekeepingActivator}
 */
public class CalcEngineEnvActivator extends HousekeepingActivator
{
    // -----------------------------------------------------------------------------------
    private static final Log LOG = LogFactory.getJclLog(CalcEngineEnvActivator.class);

    // -----------------------------------------------------------------------------------
    private static final String LOGPREFIX = "Calc Engine Env : com.openexchange.office.calcengine : ";
    
    // -----------------------------------------------------------------------------------
    private static final Class< ? >[] SERVICELIST_MANDATORY = new Class< ? >[] {ConfigurationService.class, HttpService.class, HazelcastInstance.class};
    
//    // -----------------------------------------------------------------------------------
//    private static final Class< ? >[] SERVICELIST_OPTIONAL = new Class< ? >[] {HttpService.class};

    // -----------------------------------------------------------------------------------
    public CalcEngineEnvActivator ()
    {
        super ();
    }

    // -----------------------------------------------------------------------------------
    @Override
    protected Class<?>[] getNeededServices()
    {
        return SERVICELIST_MANDATORY;
    }

//	// -----------------------------------------------------------------------------------
//    @Override
//	protected Class<?>[] getOptionalServices()
//	{
//		return SERVICELIST_OPTIONAL;
//	}

	// -----------------------------------------------------------------------------------
    @Override
    protected void startBundle()
        throws Exception
    {
        try
        {
            LOG.info (LOGPREFIX+"initialize calc engine environment ...");                        

            impl_initCalcEngineContext  ();
            impl_initCalcEngineConfig   ();
            impl_initCalcEngineFactory  ();
            impl_registerClasspathProtocolHandler (super.context);

            // analyze configuration ...
            // and setup a HTTP/JMS server environment if needed. 
            
            final ECalcEngineMode eMode = m_aCEConfig.getDetailMode();
            
            if (eMode == ECalcEngineMode.E_HTTP_SERVER)
            	impl_initHTTPServerMode ();

            if (
            	(eMode == ECalcEngineMode.E_JMS_CLIENT) ||
            	(eMode == ECalcEngineMode.E_JMS_SERVER) ||
            	(eMode == ECalcEngineMode.E_JMS       )
               )
            	impl_initJMSEnv ();
            
            LOG.info (LOGPREFIX+"OK.");
            
            //impl_test ();
        }
        catch (Throwable ex)
        {
            LOG.error (ex);
            throw new RuntimeException(ex);
        }
    }
    
    // -----------------------------------------------------------------------------------
    @Override
    public void stopBundle()
        throws Exception
    {
        LOG.info(LOGPREFIX+"deinitialize calc engine environment ...");
        
        impl_deinitHTTPServerMode ();
        
        LOG.info(LOGPREFIX+"OK.");                        
    }

    // -----------------------------------------------------------------------------------
    private void impl_initCalcEngineContext ()
    	throws Exception
    {
        LOG.info (LOGPREFIX+"initialize calc engine context ...");                        

        CalcEngineContext.get().bind2ServiceLookup(this);
        
        LOG.info (LOGPREFIX+"OK.");
    }
    
    // -----------------------------------------------------------------------------------
    private void impl_initCalcEngineConfig ()
    	throws Exception
    {
        if (m_aCEConfig != null)
        	return;
        
        LOG.info (LOGPREFIX+"initialize calc engine configuration ...");                        

        final CalcEngineConfig aCEConfig = CalcEngineConfig.get();
        registerService(CalcEngineConfig.class, aCEConfig);
        m_aCEConfig = aCEConfig;
        
        LOG.info (LOGPREFIX+"OK.");
    }
    
    // -----------------------------------------------------------------------------------
    private void impl_initCalcEngineFactory ()
    	throws Exception
    {
        if (m_aCEClientFactory != null)
        	return;

        LOG.info (LOGPREFIX+"initialize calc engine factory ...");                        

        final CalcEngineClientFactory aCEClientFactory = CalcEngineClientFactory.getFactory ();
        registerService(CalcEngineClientFactory.class, aCEClientFactory);
        m_aCEClientFactory = aCEClientFactory;
        
        LOG.info (LOGPREFIX+"OK."); 
    }

    // -----------------------------------------------------------------------------------
    private void impl_initHTTPServerMode ()
    	throws Exception
    {
        LOG.info (LOGPREFIX+"initialize calc engine HTTP server env ...");                        

        final HttpService aHttpServer = getService (HttpService.class);
        Validate.notNull(aHttpServer, "No HTTP service available within current context. Launcher config broken ?");
        
      //final int                     nTHISServerID     = m_aCEConfig.getServerNumberForTHISHost();
      //final int                     nPort             = m_aCEConfig.getServerPort(nTHISServerID);
        final CalcEngineServlet       aServlet          = new CalcEngineServlet     ();
        final DefaultResourceConfig   aConfig           = new DefaultResourceConfig ();
        final Application             aApp              = aConfig;
        final ServletContainer        aServletContainer = new ServletContainer (aApp);

        // ensure our own set of message body reader/writer is on start .-)
        Set< Class< ? > > lClasses = aApp.getClasses();
        lClasses.add(CalcEngineHttpEntityWriter.class);
        lClasses.add(CalcEngineHttpEntityReader.class);
        
        // define the calc engine mode used by the servlet
        CalcEngineServlet.MODE = ECalcEngineMode.E_HTTP_SERVER;
        
        // TODO pass OWN port to HttpService impl .-)
        
        aApp.getSingletons().add(aServlet);
        
        aHttpServer.registerServlet(CalcEngineConst.CALCENGINE_CONTEXTPATH,
        							aServletContainer                     ,
        							null                                  ,
        						    null                                  );
        
        LOG.info (LOGPREFIX+"OK."); 
    }

    // -----------------------------------------------------------------------------------
    private void impl_deinitHTTPServerMode ()
    	throws Exception
    {
    	// nothing todo .. at least deregistration of servlet makes no sense ...
    	// and there is nothing we can stop here
    	// Even might running local worker will be stopped automatically ...
    	// They are called from it's own shutdown-hook handler ...
    }

    // -----------------------------------------------------------------------------------
    private void impl_initJMSEnv ()
    	throws Exception
    {
    	final JmsServerConfig aJMSConfig = JmsServerConfig.access();
    	final JMSEnv          aEnv       = JMSEnv.create ();
    	final String          sServer    = aJMSConfig.getHost();
    	final int             nPort      = aJMSConfig.getPort();
    	
    	LOG.info("init JMS Env : [server='"+sServer+"', port="+nPort+"] ...");
    	
    	aEnv.setServerIP  (sServer);
    	aEnv.setServerPort(nPort  );
    }
    
    // -----------------------------------------------------------------------------------
    private void impl_registerClasspathProtocolHandler (final BundleContext aContext)
    	throws Exception
    {
    	final Hashtable< String, String[] > lProps = new Hashtable< String, String[]> ();
    	lProps.put (URLConstants.URL_HANDLER_PROTOCOL          ,
    				new String[] {ClasspathConnection.PROTOCOL});

    	aContext.registerService (URLStreamHandlerService.class.getName (),
    			                  new OSGIClasspathProtocolHandler()      ,
    			                  lProps                                  );
    }
   
//    // -----------------------------------------------------------------------------------
//    private void impl_test ()
//        throws Exception
//    {
//    	ICalcEngineClient iClient = CalcEngineClientFactory.getFactory().get();
//    	String            sDoc    = iClient.createDocument();
//    	
//    	StringBuffer sResultJSON = new StringBuffer (256);
//    	iClient.executeOperation(sDoc, "{foo:'1'}", sResultJSON);
//    	System.out.println ("test result = '"+sResultJSON+"'");
//    	
//    	iClient.destroyDocument(sDoc);
//    }
    
    // -----------------------------------------------------------------------------------
    private CalcEngineConfig m_aCEConfig = null;

    // -----------------------------------------------------------------------------------
    private CalcEngineClientFactory m_aCEClientFactory = null;

//    // -----------------------------------------------------------------------------------
//    private ClusterNodeManager m_aClusterManager = null;

//    // -----------------------------------------------------------------------------------
//    private CalcEngineJMSServer m_aCEJMSServer = null;
}
