/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.office.calcengine.client;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;

import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;

import org.apache.commons.logging.Log;

import com.openexchange.office.calcengine.CalcEngineConst;
import com.openexchange.office.tools.logging.LogFactory;

//=============================================================================
@Produces(MediaType.APPLICATION_JSON)
@Provider
public class CalcEngineHttpEntityWriter implements MessageBodyWriter< CalcEngineHttpEntity >
{
	//-------------------------------------------------------------------------
	private static final Log LOG = LogFactory.getJclLog(CalcEngineHttpEntityWriter.class);

	//-------------------------------------------------------------------------
	public CalcEngineHttpEntityWriter ()
	{}

	//-------------------------------------------------------------------------
	@Override
	public boolean isWriteable(final Class< ? >   aSpecificType,
							   final Type         aGenericType ,
							   final Annotation[] lAnnotations ,
							   final MediaType    aMediaType   )
	{
		if (LOG.isTraceEnabled())
		{
			LOG.trace ("isWriteable ()");
			LOG.trace ("      specific type = '"+aSpecificType+"'");
			LOG.trace ("      generic  type = '"+aGenericType +"'");
			LOG.trace ("      annotations   = '"+lAnnotations +"'");
			LOG.trace ("      media    type = '"+aMediaType   +"'");
		}

		if ( ! aSpecificType.equals(CalcEngineHttpEntity.class))
		{
			LOG.trace ("      return FALSE (non compatible class type)");
			return false;
		}
		
		if ( ! aMediaType.isCompatible(MediaType.APPLICATION_JSON_TYPE))
		{
			LOG.trace ("      return FALSE (non compatible media type)");
			return false;
		}
		
		LOG.trace ("      return TRUE");
		return true;
	}

	//-------------------------------------------------------------------------
	@Override
	public long getSize(final CalcEngineHttpEntity aEntity      ,
						final Class< ? >           aSpecificType,
						final Type                 aGenericType ,
						final Annotation[]         lAnnotations ,
						final MediaType            aMediaType   )
    {
		if (LOG.isTraceEnabled())
		{
			LOG.trace ("getSize ()");
			LOG.trace ("      specific type = '"+aSpecificType+"'");
			LOG.trace ("      generic  type = '"+aGenericType +"'");
			LOG.trace ("      annotations   = '"+lAnnotations +"'");
			LOG.trace ("      media    type = '"+aMediaType   +"'");
		}

		if (aEntity == null)
		{
			LOG.trace ("      return 0 (no data available)");
			return 0;
		}

		try
		{
			final byte[] lByteHaufen = impl_toByteHaufen (aEntity);
			final int    nLength     = lByteHaufen.length;

			if (LOG.isTraceEnabled())
			{
				LOG.trace ("      raw data      = '"+new String(lByteHaufen, CalcEngineConst.ENCODING_4_STREAMING)+"'");
				LOG.trace ("      return "+nLength);
			}
			
			return nLength;
		}
		catch (Exception ex)
		{
			LOG.error (ex.getMessage (), ex);
		}
		
		LOG.trace ("      return 0 (exception ?!)");
		return 0;
	}

	//-------------------------------------------------------------------------
	@Override
	public void writeTo(final CalcEngineHttpEntity             aEntity      ,
						final Class< ? >                       aSpecificType,
						final Type                             aGenericType ,
						final Annotation[]                     lAnnotations ,
						final MediaType                        aMediaType   ,
						final MultivaluedMap< String, Object > lHttpHeaders ,
						final OutputStream                     aEntityStream)
		throws IOException
		     , WebApplicationException
	{
		if (LOG.isTraceEnabled())
		{
	 		LOG.trace ("writeTo ()");
			LOG.trace ("      specific type = '"+aSpecificType+"'");
			LOG.trace ("      generic  type = '"+aGenericType +"'");
			LOG.trace ("      annotations   = '"+lAnnotations +"'");
			LOG.trace ("      media    type = '"+aMediaType   +"'");
		}

		try
		{
			final byte[] lByteHaufen = impl_toByteHaufen (aEntity);
			if (LOG.isTraceEnabled())
			{
				LOG.trace ("      raw data      = '"+new String(lByteHaufen, CalcEngineConst.ENCODING_4_STREAMING)+"'");
				LOG.trace ("      length        = "+lByteHaufen.length);
			}
			aEntityStream.write(lByteHaufen);
			aEntityStream.flush();
		}
		catch (Exception ex)
		{
			LOG.error (ex.getMessage (), ex);
		}
	}

	//-------------------------------------------------------------------------
	private byte[] impl_toByteHaufen (final CalcEngineHttpEntity aEntity)
	    throws Exception
	{
		final String sWritten    = CalcEngineHttpEntity.toJSON(aEntity);
		final byte[] lByteHaufen = sWritten.getBytes (CalcEngineConst.ENCODING_4_STREAMING);
		return lByteHaufen;
	}
}
