/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.kaha.impl.index;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.activemq.kaha.IndexMBean;
import org.apache.activemq.kaha.Marshaller;
import org.apache.activemq.kaha.StoreEntry;
import org.apache.activemq.kaha.impl.index.Index;
import org.apache.activemq.kaha.impl.index.IndexItem;
import org.apache.activemq.kaha.impl.index.IndexManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VMIndex
implements Index,
IndexMBean {
    private static final Logger LOG = LoggerFactory.getLogger(VMIndex.class);
    private IndexManager indexManager;
    private Map<Object, StoreEntry> map = new HashMap<Object, StoreEntry>();

    public VMIndex(IndexManager manager) {
        this.indexManager = manager;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public StoreEntry remove(Object key) {
        StoreEntry result = this.map.remove(key);
        if (result != null) {
            try {
                result = this.indexManager.refreshIndex((IndexItem)result);
            }
            catch (IOException e) {
                LOG.error("Failed to refresh entry", e);
                throw new RuntimeException("Failed to refresh entry");
            }
        }
        return result;
    }

    @Override
    public void store(Object key, StoreEntry entry) {
        this.map.put(key, entry);
    }

    @Override
    public StoreEntry get(Object key) {
        StoreEntry result = this.map.get(key);
        if (result != null) {
            try {
                result = this.indexManager.refreshIndex((IndexItem)result);
            }
            catch (IOException e) {
                LOG.error("Failed to refresh entry", e);
                throw new RuntimeException("Failed to refresh entry");
            }
        }
        return result;
    }

    @Override
    public boolean isTransient() {
        return true;
    }

    @Override
    public void load() {
    }

    @Override
    public void unload() {
        this.map.clear();
    }

    @Override
    public void delete() throws IOException {
        this.unload();
    }

    @Override
    public void setKeyMarshaller(Marshaller marshaller) {
    }

    @Override
    public int getSize() {
        return this.map.size();
    }
}

