
package org.docx4j.openpackaging.parts.DrawingML;

import org.docx4j.dml.chart.chartStyle.CTChartColor;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.relationships.Namespaces;

public class ChartColor extends JaxbDmlPart<CTChartColor> {

    public ChartColor(PartName partName) throws InvalidFormatException {
        super(partName);
        init();
    }

    public ChartColor() throws InvalidFormatException {
        super(new PartName("/xl/charts/color1.xml")); // In a .xlsx could be "/xl/charts/chart1.xml"?
        init();
    }

    public void init() {
        // Used if this Part is added to [Content_Types].xml
        setContentType(new org.docx4j.openpackaging.contenttype.ContentType(
            org.docx4j.openpackaging.contenttype.ContentTypes.DRAWINGML_CHART_COLOR));

        // Used when this Part is added to a rels
        setRelationshipType(Namespaces.SPREADSHEETML_CHART_COLOR);

    }

}
