/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.jms.impl;

import java.net.URI;

import javax.jms.Session;

import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.log4j.BasicConfigurator;

import com.openexchange.jms.IJMSServer;
import com.openexchange.jms.JMSEnv;

public class AMQServer implements IJMSServer
{
	//-------------------------------------------------------------------------
	private AMQServer ()
	{}

	//-------------------------------------------------------------------------
	public static AMQServer get ()
	    throws Exception
	{
		BasicConfigurator.configure ();
		return new AMQServer ();
	}

	//-------------------------------------------------------------------------
	@Override
	public void start ()
		throws Exception
	{
		if (m_aServer != null)
			return;
		
		final JMSEnv             aEnv         = JMSEnv.get ();
		final URI                aProviderURL = aEnv.getServerURI     ();
		final String             sDataPath    = aEnv.getLocalDataPath ();
		final BrokerService      aServer      = new BrokerService     ();
		final TransportConnector aConnector   = new TransportConnector();

		aConnector.setUri                     (aProviderURL);

		aServer.setUseShutdownHook            (false       );
		aServer.setUseLoggingForShutdownErrors(true        );
		aServer.addConnector                  (aConnector  );
		aServer.setDataDirectory              (sDataPath   );

		aServer.start           ();
		aServer.waitUntilStarted();
		
		m_aServer    = aServer;
		m_aConnector = aConnector;
	}
	
	//-------------------------------------------------------------------------
	@Override
	public void stop ()
		throws Exception
	{
		if (m_aConnector != null)
		{
			m_aConnector.stop ();
			m_aConnector = null;
		}
		
		if (m_aServer != null)
		{
			m_aServer.stop();
			m_aServer.waitUntilStopped();
			m_aServer = null;
		}
	}

	//-------------------------------------------------------------------------
	@Override
	public Session newSession ()
		throws Exception
    {
		final Session aSession = mem_Context ().newSession();
		return aSession;
    }

	//-------------------------------------------------------------------------
	private AMQContext mem_Context ()
	    throws Exception
	{
		if (m_aContext == null)
			m_aContext = AMQContext.get();
		return m_aContext;
	}
	
	//-------------------------------------------------------------------------
	private BrokerService m_aServer = null;

	//-------------------------------------------------------------------------
	private TransportConnector m_aConnector = null;

	//-------------------------------------------------------------------------
	private AMQContext m_aContext = null;
}
