/**
 * OPEN-XCHANGE legal information
 *
 * All intellectual property rights in the Software are protected by
 * international copyright laws.
 *
 *
 * In some countries OX, OX Open-Xchange, open xchange and OXtender
 * as well as the corresponding Logos OX Open-Xchange and OX are registered
 * trademarks of the Open-Xchange, Inc. group of companies.
 * The use of the Logos is not covered by the GNU General Public License.
 * Instead, you are allowed to use these Logos according to the terms and
 * conditions of the Creative Commons License, Version 2.5, Attribution,
 * Non-commercial, ShareAlike, and the interpretation of the term
 * Non-commercial applicable to the aforementioned license is published
 * on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 * Please make sure that third-party modules and libraries are used
 * according to their respective licenses.
 *
 * Any modifications to this package must retain all copyright notices
 * of the original copyright holder(s) for the original code used.
 *
 * After any such modifications, the original and derivative code shall remain
 * under the copyright of the copyright holder(s) and/or original author(s)per
 * the Attribution and Assignment Agreement that can be located at
 * http://www.open-xchange.com/EN/developer/. The contributing author shall be
 * given Attribution for the derivative code and a license granting use.
 *
 *  Copyright (C) 2004-2014 Open-Xchange, Inc.
 *  Mail: info@open-xchange.com
 *
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License, Version 2 as published
 *  by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *  or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc., 59
 *  Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
package com.openxchange.office_communication.tools.logging;

import java.io.Serializable;

import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.net.SocketAppender;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.net.AbstractSocketAppender;
import ch.qos.logback.core.spi.PreSerializationTransformer;

//=============================================================================
/** extends the original {@link SocketAppender} of logback ...
 *  and support layouting the log messages before sending them to remote.
 *  
 *  <code>
 *  	<appender name ="remote"
 *				  class="com.openxchange.office_communication.tools.logging.SocketLayoutAppender">
 *			<remoteHost>localhost</remoteHost>
 *			<port>4711</port>
 *          <!-- The original SocketAppender do not support custom layout ... -->
 *			<layout>
 *	            <pattern>%date{ISO8601}, thread=%thread, class=%logger{0}, method=%method, line=%line, level=%level, msg="%msg", exception=%exception{full}</pattern>
 *			</layout>
 *		</appender>
 *  </code>
 * 
 *  For more information on the original appender, please refer to the online manual
 *  at http://logback.qos.ch/manual/appenders.html#SocketAppender
 */
public class SocketLayoutAppender extends    AbstractSocketAppender     < ILoggingEvent >
								  implements PreSerializationTransformer< ILoggingEvent >
{
	//-------------------------------------------------------------------------
	public SocketLayoutAppender()
		throws Exception
	{
		Runtime.getRuntime().addShutdownHook(new Thread ()
		{
			@Override
			public void run ()
			{
				impl_shutdown ();
			}
		});
	}

	//-------------------------------------------------------------------------
	@Override
	protected void postProcessEvent(final ILoggingEvent aEvent)
	{
		if (m_bIncludeCallerData)
			aEvent.getCallerData();
	}

	//-------------------------------------------------------------------------
	@Override
	public Serializable transform(final ILoggingEvent aEvent)
	{
		if (aEvent == null)
			return null;
		
		try
		{
			final Layout< ILoggingEvent > aLayout = mem_Layout ();
			final StringBuffer            sEvent  = new StringBuffer (256);
			
			sEvent.append (aLayout.doLayout(aEvent));
			sEvent.append ("\n");
			
			return sEvent.toString ();
		}
		catch (final Throwable ex)
		{
			// logging exception inside logging framework ?!
			throw new RuntimeException (ex);
		}
	}

	//-------------------------------------------------------------------------
	public void setIncludeCallerData(final boolean bIncludeCallerData)
		throws Exception
	{
		m_bIncludeCallerData = bIncludeCallerData;
	}

	//-------------------------------------------------------------------------
	public void setLayout(final Layout< ILoggingEvent> aLayout)
		throws Exception
	{
		m_aLayout = aLayout;
	}

	//-------------------------------------------------------------------------
	protected PreSerializationTransformer< ILoggingEvent > getPST()
	{
		return this;
	}

	//-------------------------------------------------------------------------
	private void impl_shutdown ()
	{
		stop ();
	}

	//-------------------------------------------------------------------------
	private Layout< ILoggingEvent > mem_Layout ()
	    throws Exception
	{
		if (m_aLayout == null)
			m_aLayout = new PatternLayout ();
		return m_aLayout;
	}
	
	//-------------------------------------------------------------------------
	private boolean m_bIncludeCallerData = false;

	//-------------------------------------------------------------------------
	private Layout< ILoggingEvent > m_aLayout = null;
}