/**
 * OPEN-XCHANGE legal information
 *
 * All intellectual property rights in the Software are protected by
 * international copyright laws.
 *
 *
 * In some countries OX, OX Open-Xchange, open xchange and OXtender
 * as well as the corresponding Logos OX Open-Xchange and OX are registered
 * trademarks of the Open-Xchange, Inc. group of companies.
 * The use of the Logos is not covered by the GNU General Public License.
 * Instead, you are allowed to use these Logos according to the terms and
 * conditions of the Creative Commons License, Version 2.5, Attribution,
 * Non-commercial, ShareAlike, and the interpretation of the term
 * Non-commercial applicable to the aforementioned license is published
 * on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 * Please make sure that third-party modules and libraries are used
 * according to their respective licenses.
 *
 * Any modifications to this package must retain all copyright notices
 * of the original copyright holder(s) for the original code used.
 *
 * After any such modifications, the original and derivative code shall remain
 * under the copyright of the copyright holder(s) and/or original author(s)per
 * the Attribution and Assignment Agreement that can be located at
 * http://www.open-xchange.com/EN/developer/. The contributing author shall be
 * given Attribution for the derivative code and a license granting use.
 *
 *  Copyright (C) 2004-2014 Open-Xchange, Inc.
 *  Mail: info@open-xchange.com
 *
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License, Version 2 as published
 *  by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *  or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc., 59
 *  Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
package com.openxchange.office_communication.tools.exec.impl;

import java.io.InputStream;
import java.io.PrintStream;
import java.lang.ref.WeakReference;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.apache.commons.io.IOUtils;

//==============================================================================
public class ExecutableStreamReader implements Runnable
{
    //--------------------------------------------------------------------------
    private static final int BUFFSIZE = 4096;
    
    //--------------------------------------------------------------------------
    public ExecutableStreamReader ()
    {
    }
    
    //--------------------------------------------------------------------------
    public synchronized void bind2Input (final InputStream aIn)
        throws Exception
    {
        if (m_aIn != null)
            m_aIn.close();
        m_aIn = aIn;
    }
    
    //--------------------------------------------------------------------------
    public synchronized void bind2Output (final PrintStream aOut)
    	throws Exception
    {
    	m_aOut = aOut;
    }
    
    //--------------------------------------------------------------------------
    public synchronized void bind2Watch (final ExecutableWatch aWatch)
    	throws Exception
    {
    	m_rWatch = new WeakReference< ExecutableWatch >(aWatch);
    }

    //--------------------------------------------------------------------------
    @Override
    public void run ()
    {
        InputStream aIn  = null;
        try
        {
            PrintStream aOut = null;
            synchronized(this)
            {
                aIn  = m_aIn ;
                aOut = m_aOut;
            }
            
            byte[] lBuffer = new byte[ExecutableStreamReader.BUFFSIZE];
            int    nRead   = 0;
            while ((nRead = aIn.read(lBuffer)) > 0)
            {
                String sOut = new String (lBuffer, 0, nRead);

                if (aOut != null)
                {
                	aOut.print(sOut);
                	aOut.flush();
                }
                
                final ExecutableWatch aWatch = m_rWatch.get ();
                if (aWatch != null)
                {
                	aWatch.scanForWatches(sOut);
                	
                	if (aWatch.allWatchPointsDetected())
                		m_rWatch.clear();
                }
            }
        }
        catch (Throwable ex)
        {
            Logger.getLogger(Logger.GLOBAL_LOGGER_NAME).log(Level.SEVERE, ex.getMessage(), ex);
        }
        finally
        {
            IOUtils.closeQuietly(aIn);
        }
    }
    
    //--------------------------------------------------------------------------
    private InputStream m_aIn = null;
    
    //--------------------------------------------------------------------------
    private PrintStream m_aOut = null;

    //--------------------------------------------------------------------------
    private WeakReference< ExecutableWatch > m_rWatch = new WeakReference< ExecutableWatch >(null);
}