/**
 * OPEN-XCHANGE legal information
 *
 * All intellectual property rights in the Software are protected by
 * international copyright laws.
 *
 *
 * In some countries OX, OX Open-Xchange, open xchange and OXtender
 * as well as the corresponding Logos OX Open-Xchange and OX are registered
 * trademarks of the Open-Xchange, Inc. group of companies.
 * The use of the Logos is not covered by the GNU General Public License.
 * Instead, you are allowed to use these Logos according to the terms and
 * conditions of the Creative Commons License, Version 2.5, Attribution,
 * Non-commercial, ShareAlike, and the interpretation of the term
 * Non-commercial applicable to the aforementioned license is published
 * on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 * Please make sure that third-party modules and libraries are used
 * according to their respective licenses.
 *
 * Any modifications to this package must retain all copyright notices
 * of the original copyright holder(s) for the original code used.
 *
 * After any such modifications, the original and derivative code shall remain
 * under the copyright of the copyright holder(s) and/or original author(s)per
 * the Attribution and Assignment Agreement that can be located at
 * http://www.open-xchange.com/EN/developer/. The contributing author shall be
 * given Attribution for the derivative code and a license granting use.
 *
 *  Copyright (C) 2004-2014 Open-Xchange, Inc.
 *  Mail: info@open-xchange.com
 *
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License, Version 2 as published
 *  by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *  or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc., 59
 *  Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
package com.openxchange.office_communication.tools.cmdline;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;

//=============================================================================
public class CommandLineBase
{
    //--------------------------------------------------------------------------
    public static final String OPT_HELP = "h";

    //--------------------------------------------------------------------------
    public static final boolean REQUIRED = true;

    //--------------------------------------------------------------------------
    public static final boolean NOT_REQUIRED = false;

    //--------------------------------------------------------------------------
    public static final boolean HAS_VALUE = true;

    //--------------------------------------------------------------------------
    public static final boolean HAS_NO_VALUE = false;

    //--------------------------------------------------------------------------
    public CommandLineBase (String sCommandName)
    	throws Exception
    {
        m_sCommandName = sCommandName;
        
        addOption (CommandLineBase.OPT_HELP    ,
                   "help"                      ,
                   CommandLineBase.HAS_NO_VALUE,
                   CommandLineBase.NOT_REQUIRED,
                   "show this help."           );
    }

    //--------------------------------------------------------------------------
    public void parse (String... lArgs)
        throws Exception
    {
        try
        {
            CommandLineParser aParser = new PosixParser ();
            m_aCmdLine = aParser.parse(mem_Options (), lArgs);
            verifyInt ();
        }
        catch(Throwable ex)
        {
            System.out.println(ex.getMessage ());
            m_bWasError = true;
        }
    }

    //--------------------------------------------------------------------------
    public boolean needsHelp ()
        throws Exception
    {
        return (
                (m_bWasError                                    ) ||
                (m_aCmdLine.hasOption (CommandLineBase.OPT_HELP))
               );
    }

    //--------------------------------------------------------------------------
    public void printHelp ()
        throws Exception
    {
        HelpFormatter aCmdLineHelp = new HelpFormatter ();
        aCmdLineHelp.printHelp (m_sCommandName+" [options]", mem_Options ());
    }

    //--------------------------------------------------------------------------
    public boolean isEmpty ()
    	throws Exception
    {
        if (m_aCmdLine == null)
            return true;

        String[] lArgs = m_aCmdLine.getArgs    ();
        Option[] lOpts = m_aCmdLine.getOptions ();
        return (
                (lArgs == null || lArgs.length < 1) &&
                (lOpts == null || lOpts.length < 1)
               );
    }

    //--------------------------------------------------------------------------
    protected String getOptionValue (String sShort)
        throws Exception
    {
        return m_aCmdLine.getOptionValue (sShort);
    }

    //--------------------------------------------------------------------------
    protected boolean hasOption (String sShort)
        throws Exception
    {
        return m_aCmdLine.hasOption (sShort);
    }

    //--------------------------------------------------------------------------
    protected void addOption (String  sShort      ,
                              String  sLong       ,
                              boolean bHasValue   ,
                              boolean bRequired   ,
                              String  sDescription)
        throws Exception
    {
        Option aOption = new Option (sShort, sLong, bHasValue, sDescription);
        aOption.setRequired (bRequired);
        mem_Options ().addOption (aOption);
    }

    //--------------------------------------------------------------------------
    protected void verifyInt ()
    	throws Exception
    {}

    //--------------------------------------------------------------------------
    private Options mem_Options ()
        throws Exception
    {
        if (m_lOptions == null)
            m_lOptions = new Options ();
        return m_lOptions;
    }

    //--------------------------------------------------------------------------
    private String m_sCommandName = null;

    //--------------------------------------------------------------------------
    private Options m_lOptions = null;

    //--------------------------------------------------------------------------
    private CommandLine m_aCmdLine = null;

    //--------------------------------------------------------------------------
    private boolean m_bWasError = false;
}
