/**
 * Copyright (C) 2012 - 2013 Alessandro Vurro.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.googlecode.jmapper.config;

/**
 * This Class containts all constants used in JMapper Framework.
 * 
 * @author Alessandro Vurro
 *
 */
public final class Constants {
	
	public static final String THE_FIELD_IS_NOT_CONFIGURED = "THE_FIELD_IS_NOT_CONFIGURED";
	public static final String DESTINATION_DEFAULT_NAME = "destination";
	public static final String SOURCE_DEFAULT_NAME = "source";
	public static final String DEFAULT_FIELD_VALUE = "";
	public static final String CONTENT_ALREADY_DEFINED = "not needed";
	public static final String MSG_FILE = "com/googlecode/jmapper/config/jmapper.msg.properties";
	
	public static final String nullPointer = "nullPointer";
	public static final String nullPointerPath = "nullPointerPath";
	public static final String illegalCode = "illegalCode";
	public static final String illegalCodePath = "illegalCodePath";
	public static final String dynamicConversionBodyException = "dynamicConversionBodyException";
	public static final String dynamicConversionMethodException = "dynamicConversionMethodException";
	public static final String dynamicConversionParameterException = "dynamicConversionParameterException";
	public static final String conversionParameterException = "conversionParameterException";
	public static final String conversionBodyIllegalCode = "conversionBodyIllegalCode";
	public static final String noRelationshipException = "noRelationshipException";
	public static final String xmlMappingGlobalExistException = "xmlMappingGlobalExistException";
	public static final String xmlMappingGlobalDoesNotExistException = "xmlMappingGlobalDoesNotExistException"; 
	public static final String xmlMappingClassDoesNotExistException2 = "xmlMappingClassDoesNotExistException2";
	public static final String undefinedMappingException = "undefinedMappingException";
	public static final String mappingNotFoundException2 = "mappingNotFoundException2";
	public static final String mappingNotFoundException2path = "mappingNotFoundException2path";
	public static final String mappingNotFoundException1 = "mappingNotFoundException1";
	public static final String mappingNotFoundException1path = "mappingNotFoundException1path";
	public static final String nullMappedClassException1 = "nullMappedClassException1";
	public static final String mappingErrorException4 = "mappingErrorException4";
	public static final String mappingErrorException3 = "mappingErrorException3";
	public static final String mappingErrorException2 = "mappingErrorException2";
	public static final String mappingErrorException2length = "mappingErrorException2length";
	public static final String mappingErrorRelationalException2 = "mappingErrorRelationalException2";
	public static final String mappingErrorRelationalException3 = "mappingErrorRelationalException3";
	public static final String mappingNotFoundException0 = "mappingNotFoundException0";
	public static final String malformedBeanException3 = "malformedBeanException3";
	public static final String malformedBeanException2 = "malformedBeanException2";
	public static final String malformedBeanException1 = "malformedBeanException1";
	public static final String classNotMappedException1 = "classNotMappedException1";
	public static final String classNotMappedException2 = "classNotMappedException2";
	public static final String xmlMappingClassDoesNotExistException1 = "xmlMappingClassDoesNotExistException1";
	public static final String xmlMappingAttributeDoesNotExistException2 = "xmlMappingAttributeDoesNotExistException2";
	public static final String xmlMappingAttributeExistException2 = "xmlMappingAttributeExistException2";
	public static final String xmlMappingClassExistException1 = "xmlMappingClassExistException1";
	public static final String xmlConversionNameException = "xmlConversionNameException";
	public static final String xmlConversionTypeException = "xmlConversionTypeException";
	public static final String xmlConversionParameterException = "xmlConversionParameterException";
	public static final String wrongMethodException1 = "wrongMethodException1";
	public static final String illegalArgumentException1 = "illegalArgumentException1";
	public static final String FileNotFoundException1 = "FileNotFoundException1";
	public static final String FileNotFoundException2 = "FileNotFoundException2";
	public static final String loadingFileException2 = "loadingFileException2";
}
