/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2016 OX Software GmbH
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/text/view/control/paragraphstylepicker', [
    'io.ox/office/tk/utils',
    'io.ox/office/tk/forms',
    'io.ox/office/editframework/view/control/stylesheetpicker',
    'gettext!io.ox/office/text'
], function (Utils, Forms, StyleSheetPicker, gt) {

    'use strict';

    // class ParagraphStylePicker =============================================

    /**
     * A drop-down menu control for paragraph style sheets.
     *
     * @constructor
     *
     * @extends StyleSheetPicker
     */
    function ParagraphStylePicker(app) {

        var // self reference
            self = this,

            // paragraph style sheets
            paragraphStyles = null;

        // base constructor ---------------------------------------------------

        StyleSheetPicker.call(this, app, 'paragraph', {
            width: 175,
            icon: 'docs-pilcrow',
            tooltip: /*#. tool tip: predefined styles for paragraphs */ gt('Paragraph style'),
            gridColumns: 4,
            i18nModulePath: 'io.ox/office/text/resource/paragraphstylenames',
            smallerVersion: { css: { width: 50 }, hideLabel: true }
        });

        // private methods ----------------------------------------------------

        /**
         * Formats the passed DOM element according to the specified paragraph
         * style sheet.
         */
        function setParagraphFormatting(buttonNode, styleId) {
            var captionNode = Forms.getCaptionNode(buttonNode);
            paragraphStyles.setElementAttributes(captionNode, { styleId: styleId }, { preview: true });
        }

        /**
         * Initializes a new list item according to the paragraph style sheet.
         */
        function createItemHandler(event, buttonNode, styleId) {
            setParagraphFormatting(buttonNode, styleId);
        }

        /**
         * Updates the drop-down menu button.
         */
        function updateHandler(styleId) {
            setParagraphFormatting(self.getMenuButton(), styleId);
        }

        // initialization -----------------------------------------------------

        // initialize class members
        app.onInit(function () {
            paragraphStyles = app.getModel().getStyleCollection('paragraph');
        });

        this.getMenu().on('create:item', createItemHandler);
        this.registerUpdateHandler(updateHandler);

        // destroy all class members on destruction
        this.registerDestructor(function () {
            app = self = paragraphStyles = null;
        });

    } // class ParagraphStylePicker

    // exports ================================================================

    // derive this class from class StyleSheetPicker
    return StyleSheetPicker.extend({ constructor: ParagraphStylePicker });

});
