/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2016 OX Software GmbH
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define(['io.ox/office/spreadsheet/utils/paneutils'], function (PaneUtils) {
    'use strict';

    describe('OX Spreadsheet', function () {
        describe('PaneUtils module', function () {

            it('should exist', function () {
                expect(PaneUtils).to.be.an('object');
            });

            // constants ======================================================

            describe('constant "MIN_PANE_SIZE"', function () {
                it('should exist', function () {
                    expect(PaneUtils.MIN_PANE_SIZE).to.be.a('number');
                    expect(PaneUtils.MIN_PANE_SIZE).to.be.above(0);
                });
            });

            // methods ========================================================

            describe('method "isColumnSide"', function () {
                it('should exist', function () {
                    expect(PaneUtils).itself.to.respondTo('isColumnSide');
                });
                it('should return true for left/right', function () {
                    expect(PaneUtils.isColumnSide('left')).to.be['true'];
                    expect(PaneUtils.isColumnSide('right')).to.be['true'];
                });
                it('should return false for top/botttom', function () {
                    expect(PaneUtils.isColumnSide('top')).to.be['false'];
                    expect(PaneUtils.isColumnSide('bottom')).to.be['false'];
                });
            });

            // ----------------------------------------------------------------

            describe('method "getScrollAnchorName"', function () {
                it('should exist', function () {
                    expect(PaneUtils).itself.to.respondTo('getScrollAnchorName');
                });
                it('should return the correct anchor name', function () {
                    expect(PaneUtils.getScrollAnchorName('left')).to.be.equal('anchorLeft');
                    expect(PaneUtils.getScrollAnchorName('right')).to.be.equal('anchorRight');
                    expect(PaneUtils.getScrollAnchorName('top')).to.be.equal('anchorTop');
                    expect(PaneUtils.getScrollAnchorName('bottom')).to.be.equal('anchorBottom');
                });
            });

            // ----------------------------------------------------------------

            describe('method "getColPaneSide"', function () {
                it('should exist', function () {
                    expect(PaneUtils).itself.to.respondTo('getColPaneSide');
                });
                it('should return the correct pane side', function () {
                    expect(PaneUtils.getColPaneSide('topLeft')).to.be.equal('left');
                    expect(PaneUtils.getColPaneSide('topRight')).to.be.equal('right');
                    expect(PaneUtils.getColPaneSide('bottomLeft')).to.be.equal('left');
                    expect(PaneUtils.getColPaneSide('bottomRight')).to.be.equal('right');
                });
            });

            // ----------------------------------------------------------------

            describe('method "getRowPaneSide"', function () {
                it('should exist', function () {
                    expect(PaneUtils).itself.to.respondTo('getRowPaneSide');
                });
                it('should return the correct pane side', function () {
                    expect(PaneUtils.getRowPaneSide('topLeft')).to.be.equal('top');
                    expect(PaneUtils.getRowPaneSide('topRight')).to.be.equal('top');
                    expect(PaneUtils.getRowPaneSide('bottomLeft')).to.be.equal('bottom');
                    expect(PaneUtils.getRowPaneSide('bottomRight')).to.be.equal('bottom');
                });
            });

            // ----------------------------------------------------------------

            describe('method "getNextColPanePos"', function () {
                it('should exist', function () {
                    expect(PaneUtils).itself.to.respondTo('getNextColPanePos');
                });
                it('should return the correct pane position', function () {
                    expect(PaneUtils.getNextColPanePos('topLeft')).to.be.equal('topRight');
                    expect(PaneUtils.getNextColPanePos('topRight')).to.be.equal('topLeft');
                    expect(PaneUtils.getNextColPanePos('bottomLeft')).to.be.equal('bottomRight');
                    expect(PaneUtils.getNextColPanePos('bottomRight')).to.be.equal('bottomLeft');
                });
            });

            // ----------------------------------------------------------------

            describe('method "getNextRowPanePos"', function () {
                it('should exist', function () {
                    expect(PaneUtils).itself.to.respondTo('getNextRowPanePos');
                });
                it('should return the correct pane position', function () {
                    expect(PaneUtils.getNextRowPanePos('topLeft')).to.be.equal('bottomLeft');
                    expect(PaneUtils.getNextRowPanePos('topRight')).to.be.equal('bottomRight');
                    expect(PaneUtils.getNextRowPanePos('bottomLeft')).to.be.equal('topLeft');
                    expect(PaneUtils.getNextRowPanePos('bottomRight')).to.be.equal('topRight');
                });
            });

            // ----------------------------------------------------------------

            describe('method "getNextPanePos"', function () {
                it('should exist', function () {
                    expect(PaneUtils).itself.to.respondTo('getNextPanePos');
                });
                it('should return the correct pane position', function () {
                    expect(PaneUtils.getNextPanePos('topLeft', 'top')).to.be.equal('topLeft');
                    expect(PaneUtils.getNextPanePos('topLeft', 'bottom')).to.be.equal('bottomLeft');
                    expect(PaneUtils.getNextPanePos('topLeft', 'left')).to.be.equal('topLeft');
                    expect(PaneUtils.getNextPanePos('topLeft', 'right')).to.be.equal('topRight');
                    expect(PaneUtils.getNextPanePos('topRight', 'top')).to.be.equal('topRight');
                    expect(PaneUtils.getNextPanePos('topRight', 'bottom')).to.be.equal('bottomRight');
                    expect(PaneUtils.getNextPanePos('topRight', 'left')).to.be.equal('topLeft');
                    expect(PaneUtils.getNextPanePos('topRight', 'right')).to.be.equal('topRight');
                    expect(PaneUtils.getNextPanePos('bottomLeft', 'top')).to.be.equal('topLeft');
                    expect(PaneUtils.getNextPanePos('bottomLeft', 'bottom')).to.be.equal('bottomLeft');
                    expect(PaneUtils.getNextPanePos('bottomLeft', 'left')).to.be.equal('bottomLeft');
                    expect(PaneUtils.getNextPanePos('bottomLeft', 'right')).to.be.equal('bottomRight');
                    expect(PaneUtils.getNextPanePos('bottomRight', 'top')).to.be.equal('topRight');
                    expect(PaneUtils.getNextPanePos('bottomRight', 'bottom')).to.be.equal('bottomRight');
                    expect(PaneUtils.getNextPanePos('bottomRight', 'left')).to.be.equal('bottomLeft');
                    expect(PaneUtils.getNextPanePos('bottomRight', 'right')).to.be.equal('bottomRight');
                });
            });

            // ----------------------------------------------------------------

            describe('method "getRectangleStyleMarkup"', function () {
                it('should exist', function () {
                    expect(PaneUtils).itself.to.respondTo('getRectangleStyleMarkup');
                });
                it('should return the correct mark-up', function () {
                    expect(PaneUtils.getRectangleStyleMarkup({ left: 1, top: 2, width: 3, height: 4 })).to.be.equal('left:1px;top:2px;width:3px;height:4px;');
                });
            });

            // ----------------------------------------------------------------

            describe('method "getSelectionMode"', function () {
                it('should exist', function () {
                    expect(PaneUtils).itself.to.respondTo('getSelectionMode');
                });
                it('should return the correct selection mode', function () {
                    expect(PaneUtils.getSelectionMode({ shiftKey: false, ctrlKey: false, metaKey: false })).to.be.equal('select');
                    expect(PaneUtils.getSelectionMode({ shiftKey: true, ctrlKey: false, metaKey: false })).to.be.equal('extend');
                    expect(PaneUtils.getSelectionMode({ shiftKey: false, ctrlKey: true, metaKey: false })).to.be.equal('append');
                    expect(PaneUtils.getSelectionMode({ shiftKey: true, ctrlKey: true, metaKey: false })).to.be.equal('select');
                    expect(PaneUtils.getSelectionMode({ shiftKey: false, ctrlKey: false, metaKey: true })).to.be.equal('append');
                    expect(PaneUtils.getSelectionMode({ shiftKey: true, ctrlKey: false, metaKey: true })).to.be.equal('select');
                    expect(PaneUtils.getSelectionMode({ shiftKey: false, ctrlKey: true, metaKey: true })).to.be.equal('append');
                    expect(PaneUtils.getSelectionMode({ shiftKey: true, ctrlKey: true, metaKey: true })).to.be.equal('select');
                });
            });

            // ----------------------------------------------------------------

        });
    });
});
