'use strict';

module.exports = function (grunt) {

    grunt.config.extend('copy', {
        static: {
            files: [
                {
                    src: ['apps/**/*.json', '!apps/**/manifest.json'],
                    dest: 'build/'
                }
            ]
        },
        third_party: {
            files: [
                {
                    expand: true,
                    src: ['lib/canvasjs.min.js'],
                    cwd: 'lib/canvasjs/',
                    dest: 'build/apps/io.ox/office/drawinglayer/',
                    filter: 'isFile'
                },
                {
                    expand: true,
                    src: ['lib/pdf.js'],
                    cwd: 'lib/pdfjs/',
                    dest: 'build/apps/io.ox/office/baseframework/',
                    filter: 'isFile'
                },
                {
                    expand: true,
                    src: ['lib/pdftextlayerbuilder.js'],
                    cwd: 'lib/pdfjs/',
                    dest: 'build/apps/io.ox/office/baseframework/',
                    filter: 'isFile'
                }
            ]
        },
        specs: {
            files: [
                {
                    src: ['spec/**/*.js'],
                    expand: true,
                    filter: 'isFile',
                    dest: 'build/'
                },
                {
                    src: ['spec/fixtures/**/*'],
                    expand: true,
                    filter: 'isFile',
                    dest: 'build/'
                }
            ]
        }
    });

    grunt.registerTask('copy_build', [
        'newer:copy:static',
        'newer:copy:apps',
        'newer:copy:themes',
        'newer:copy:specs',
        'newer:copy:third_party'
    ]);
};
