/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2016 OX Software GmbH
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/preview/view/labels',
    ['io.ox/office/baseframework/view/baselabels',
     'gettext!io.ox/office/preview'
    ], function (BaseLabels, gt) {

    'use strict';

    // static class PreviewControls ===========================================

    /**
     * Provides generic caption texts for control groups, menu headers, and
     * other GUI elements for the Viewer application in a single map for
     * convenience.
     *
     * @extends BaseLabels
     */
    var PreviewLabels = _.extend({}, BaseLabels);

    // constants --------------------------------------------------------------

    /**
     * Standard options for a 'Show first page' button.
     *
     * @constant
     */
    PreviewLabels.FIRST_PAGE_BUTTON_OPTIONS = { icon: 'fa-fast-backward', tooltip: gt('Show first page') };

    /**
     * Standard options for the 'Show previous page' button.
     *
     * @constant
     */
    PreviewLabels.PREV_PAGE_BUTTON_OPTIONS = { icon: 'fa-step-backward', tooltip: gt('Show previous page') };

    /**
     * Standard options for the 'Show next page' button.
     *
     * @constant
     */
    PreviewLabels.NEXT_PAGE_BUTTON_OPTIONS = { icon: 'fa-step-forward', tooltip: gt('Show next page') };

    /**
     * Standard options for the 'Show last page' button.
     *
     * @constant
     */
    PreviewLabels.LAST_PAGE_BUTTON_OPTIONS = { icon: 'fa-fast-forward', tooltip: gt('Show last page') };

    // exports ================================================================

    return PreviewLabels;

});
