/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2016 OX Software GmbH
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/drawinglayer/utils/operations', function (DrawingOperations) {

    'use strict';

    // static class DrawingOperations =========================================

    /**
     * Provides constants for the names of generic drawing operations.
     */
    var DrawingOperations = {

        /**
         * Name of the operation that inserts a new drawing object into the
         * document.
         *
         * @constant
         */
        INSERT_DRAWING: 'insertDrawing',

        /**
         * Name of the operation that deletes an existing drawing object from
         * the document.
         *
         * @constant
         */
        DELETE_DRAWING: 'deleteDrawing',

        /**
         * Name of the operation that changes formatting attributes of an
         * existing drawing object in the document.
         *
         * @constant
         */
        SET_DRAWING_ATTRIBUTES: 'setDrawingAttributes',

        /**
         * Name of the operation that inserts a new data series into a chart
         * object.
         *
         * @constant
         */
        INSERT_CHART_DATASERIES: 'insertChartDataSeries',

        /**
         * Name of the operation that deletes an existing data series from a
         * chart object.
         *
         * @constant
         */
        DELETE_CHART_DATASERIES: 'deleteChartDataSeries',

        /**
         * Name of the operation that changes formatting attributes of a data
         * series in a chart object.
         *
         * @constant
         */
        SET_CHART_DATASERIES_ATTRIBUTES: 'setChartDataSeriesAttributes',

        /**
         * Name of the operation that changes formatting attributes of an axis
         * in a chart object.
         *
         * @constant
         */
        SET_CHART_AXIS_ATTRIBUTES: 'setChartAxisAttributes',

        /**
         * Name of the operation that changes formatting attributes of the grid
         * lines attached to an axis in a chart object.
         *
         * @constant
         */
        SET_CHART_GRIDLINE_ATTRIBUTES: 'setChartGridlineAttributes',

        /**
         * Name of the operation that changes formatting attributes of a title
         * (main title, or axis title) in a chart object.
         *
         * @constant
         */
        SET_CHART_TITLE_ATTRIBUTES: 'setChartTitleAttributes',

        /**
         * Name of the operation that changes formatting attributes of the
         * legend in a chart object.
         *
         * @constant
         */
        SET_CHART_LEGEND_ATTRIBUTES: 'setChartLegendAttributes'

    };

    // exports ================================================================

    return DrawingOperations;

});
