/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2012 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.documentconverter;

public interface IDocumentConverterInformationMBean {

    /**
     * @return The total number of jobs that have been processed
     */
    long getJobsProcessed();

    /**
     * @return The ratio of cache hits versus processed job as simple quotient
     */
    double getCacheHitRatio();

    /**
     * @return The ratio of cache hits versus processed job as simple quotient
     */
    double getErrorCacheHitRatio();

    // -------------------------------------------------------------------------

    /**
     * @return The peak number of Jobs in queue for the given priority from the beginning of the last reset/initialization on
     */
    int getPeakJobCountInQueue_Low();

    /**
     * @return The peak number of Jobs in queue for the given priority from the beginning of the last reset/initialization on
     */
    int getPeakJobCountInQueue_Medium();

    /**
     * @return The peak number of Jobs in queue for the given priority from the beginning of the last reset/initialization on
     */
    int getPeakJobCountInQueue_High();

    /**
     * @return The peak number of Jobs in queue for the given priority from the beginning of the last reset/initialization on
     */
    int getPeakJobCountInQueue_Instant();

    /**
     * @return The peak total number of Jobs in queue for from the beginning of the last reset/initialization on
     */
    int getPeakJobCountInQueue_Total();

    // -------------------------------------------------------------------------

    /**
     * @return The toal number of jobs that returned with a timeout error
     */
    long getJobErrorsTimeout();

    /**
     * @return The toal number of jobs that returned with an error in general
     */
    long getJobErrorsTotal();


    // -------------------------------------------------------------------------

    /**
     * @return The median of the jobs time in queue for the given priority from the beginning of the last reset/initialization on
     */
    long getMedianQueueTimeMillis_Low();

    /**
     * @return The median of the jobs time in queue for the given priority from the beginning of the last reset/initialization on
     */
    long getMedianQueueTimeMillis_Medium();

    /**
     * @return The median of the jobs time in queue for the given priority from the beginning of the last reset/initialization on
     */
    long getMedianQueueTimeMillis_High();

    /**
     * @return The median of the jobs time in queue for the given priority from the beginning of the last reset/initialization on
     */
    long getMedianQueueTimeMillis_Instant();

    /**
     * @return The median of the jobs time in queue for all jobs from the beginning of the last reset/initialization on
     */
    long getMedianQueueTimeMillis_Total();

    // -------------------------------------------------------------------------

    /**
     * @return The median of the jobs conversion time for the given priority from the beginning of the last reset/initialization on
     */
    long getMedianConversionTimeMillis_Low();

    /**
     * @return The median of the jobs conversion time for the given priority from the beginning of the last reset/initialization on
     */
    long getMedianConversionTimeMillis_Medium();

    /**
     * @return The median of the jobs conversion time for the given priority from the beginning of the last reset/initialization on
     */
    long getMedianConversionTimeMillis_High();

    /**
     * @return The median of the jobs conversion time for the given priority from the beginning of the last reset/initialization on
     */
    long getMedianConversionTimeMillis_Instant();

    /**
     * @return The median of the jobs conversion time for all jobs from the beginning of the last reset/initialization on
     */
    long getMedianConversionTimeMillis_Total();

    // -------------------------------------------------------------------------

    /**
     * @return The median of the jobs total time for the given priority from the beginning of the last reset/initialization on
     */
    long getMedianJobTimeMillis_Low();

    /**
     * @return The median of the jobs total time for the given priority from the beginning of the last reset/initialization on
     */
    long getMedianJobTimeMillis_Medium();

    /**
     * @return The median of the jobs total time for the given priority from the beginning of the last reset/initialization on
     */
    long getMedianJobTimeMillis_High();

    /**
     * @return The median of the jobs total time for the given priority from the beginning of the last reset/initialization on
     */
    long getMedianJobTimeMillis_Instant();

    /**
     * @return The median of the jobs total time for all jobs from the beginning of the last reset/initialization on
     */
    long getMedianJobTimeMillis_Total();
}
