/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.builders;

import javax.xml.namespace.QName;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.ws.policy.PolicyConstants;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.model.Trust13;
import org.apache.neethi.Assertion;
import org.apache.neethi.AssertionBuilderFactory;
import org.apache.neethi.builders.AssertionBuilder;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Trust13Builder
implements AssertionBuilder<Element> {
    public Assertion build(Element element, AssertionBuilderFactory factory) {
        if ((element = PolicyConstants.findPolicyElement(element)) == null) {
            throw new IllegalArgumentException("Trust13 assertion doesn't contain any Policy");
        }
        Trust13 trust13 = new Trust13(SP12Constants.INSTANCE);
        if (DOMUtils.getFirstChildWithName(element, SP12Constants.MUST_SUPPORT_CLIENT_CHALLENGE) != null) {
            trust13.setMustSupportClientChallenge(true);
        }
        if (DOMUtils.getFirstChildWithName(element, SP12Constants.MUST_SUPPORT_SERVER_CHALLENGE) != null) {
            trust13.setMustSupportServerChallenge(true);
        }
        if (DOMUtils.getFirstChildWithName(element, SP12Constants.REQUIRE_CLIENT_ENTROPY) != null) {
            trust13.setRequireClientEntropy(true);
        }
        if (DOMUtils.getFirstChildWithName(element, SP12Constants.REQUIRE_SERVER_ENTROPY) != null) {
            trust13.setRequireServerEntropy(true);
        }
        if (DOMUtils.getFirstChildWithName(element, SP12Constants.MUST_SUPPORT_ISSUED_TOKENS) != null) {
            trust13.setMustSupportIssuedTokens(true);
        }
        if (DOMUtils.getFirstChildWithName(element, SP12Constants.REQUIRE_REQUEST_SECURITY_TOKEN_COLLECTION) != null) {
            trust13.setRequireRequestSecurityTokenCollection(true);
        }
        if (DOMUtils.getFirstChildWithName(element, SP12Constants.REQUIRE_APPLIES_TO) != null) {
            trust13.setRequireAppliesTo(true);
        }
        return trust13;
    }

    public QName[] getKnownElements() {
        return new QName[]{SP12Constants.TRUST_13};
    }
}

