/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.obs.ant.tasks;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import com.openexchange.obs.api.Architecture;
import com.openexchange.obs.api.Binary;
import com.openexchange.obs.api.BuildServiceClient;
import com.openexchange.obs.api.BuildServiceException;
import com.openexchange.obs.api.Tools;

/**
 * Downloads the binary debian package.
 *
 * @author <a href="mailto:marcus.klein@open-xchange.com">Marcus Klein</a>
 */
public class DownloadPackage extends Task {

    private String url;
    private String login;
    private String password;

    private String projectName;
    private String repository;
    private String arch;
    private String packageName;

    private String path;

    public DownloadPackage() {
        super();
    }

    public final void setPath(final String path) {
        this.path = path;
    }

    public final void setPackage(final String packageName) {
        this.packageName = packageName;
    }

    public final void setProjectName(final String projectName) {
        this.projectName = projectName;
    }

    public final void setRepository(final String repository) {
        this.repository = repository;
    }

    public final void setArch(String arch) {
        this.arch = arch;
    }

    public final void setLogin(final String login) {
        this.login = login;
    }

    public final void setPassword(final String password) {
        this.password = password;
    }

    public final void setUrl(final String url) {
        this.url = url;
    }

    @Override
    public void execute() throws BuildException {
        if (null == arch || 0 == arch.length()) {
            throw new BuildException("Please define system architecture.");
        }
        if (this.path == null || this.path.length() == 0 ) {
            this.path = getProject().getBaseDir().getAbsolutePath();
        }

        try {
            final BuildServiceClient bsc = new BuildServiceClient(url, login, password);
            for (final Binary binary : bsc.getProjectBinaryPackageNames(projectName, repository, Architecture.parse(arch), packageName)) {
                if (!binary.getFilename().endsWith(".deb") && !binary.getFilename().endsWith(".noarch.rpm")) {
                    continue;
                }
                final File file = new File(path, binary.getFilename());
                log("Downloading " + binary.getFilename() + " to " + file.getParent());
                if (file.exists()) {
                    file.delete();
                }
                final OutputStream os = new FileOutputStream(file);
                final InputStream is = bsc.getProjectBinaryPackageByName(projectName, repository, Architecture.parse(arch), packageName, binary.getFilename());
                try {
                    Tools.transfer(is, os);
                } finally {
                    os.close();
                    is.close();
                }
            }
        } catch (final IOException e) {
            throw new BuildException(e.getMessage(), e);
        } catch (final BuildServiceException e) {
            throw new BuildException(e.getMessage(), e);
        }
    }
}
